package org.etsi.mts.tdl.execution.java.tri;

import java.util.function.Consumer;

/**
 * Encapsulation of procedure signature as specified in TDL model that may
 * optionally be mapped to a method that implements the calling of the
 * procedure.
 */
public class Procedure extends NamedElement {
	/**
	 * Optional function that implements this procedure call.
	 * <p>
	 * The function parameters must match the order and types of parameters of the
	 * procedure call. That is, for each parameter of a procedure call, a method
	 * parameter must exist such that the procedure call parameter type is mapped to
	 * the method parameter type (or class).
	 */
	public Consumer<Object[]> function;
}
