package org.etsi.mts.tdl.execution.java.tri;

/**
 * Encapsulation of a connection end-point specification. It's an aggregation of
 * following TDL model elements:
 * <ul>
 * <li>GateInstance</li>
 * <li>GateType</li>
 * <li>ComponentInstance</li>
 * <li>ComponentType</li>
 * <li>ComponentInstanceRole</li>
 * </ul>
 *
 */
public class GateReference {
	public Element gate;
	public Element gateType;
	public Element component;
	public Element componentType;
	public ComponentInstanceRole role;

	public GateReference(Element gate, Element gateType, Element component, Element componentType,
			ComponentInstanceRole role) {
		this.gate = gate;
		this.gateType = gateType;
		this.component = component;
		this.componentType = componentType;
		this.role = role;
	}

	@Override
	public int hashCode() {
		return gate.hashCode() << 8 + gateType.hashCode() << 6 + component.hashCode() << 4
				+ componentType.hashCode() << 2 + role.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof GateReference) {
			GateReference gr = (GateReference) obj;
			return gate.equals(gr.gate) && gateType.equals(gr.gateType) && component.equals(gr.component)
					&& componentType.equals(gr.componentType) && role.equals(gr.role);
		}
		return super.equals(obj);
	}

}