package org.etsi.mts.tdl.openapi2tdl.next.doc;

import java.util.List;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import org.openapitools.codegen.utils.ModelUtils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.PathItem.HttpMethod;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;

public class ICSDetail extends OpenAPIVisitor  {
	int ri = 0;
	int oi = 0;
	private String level = "Detail";

	@Override
	public void preamble(OpenAPI model) {
		content.append(String.format("\n#### %s\n\n", level));

		String header = 
				"| ID | Resource  | Reference | Method | Type  | Request | Response |\n" + 
				"| -- | --------- | --------- | ------ | ----- | ------- | -------- |\n";
		content.append(header);
	}

	@Override
	public void path(String path) {
		ri = 0;
	}
	
	@Override
	public void operation(String path, String method, Operation op) {
		String cleanPath = path.toUpperCase()
				.replaceAll("/", "")
				.replaceAll("[\\{\\}]", "_")
				.replaceAll("_$", "");
		for (String r : op.getResponses().keySet()) {
			ri++;

			String reference = "Path: "+path + " : "+op.getOperationId();
			String response = r;
			String type = "M";
			String resource = path;
			String request = "(fill in request)";

			String id = "D_"+cleanPath
					+"_"+method
					+"_"+r
					+"_00"+ri;
			content.append(
					   "| " + id
					+ " | " + resource
					+ " | " + reference
					+ " | " + method
					+ " | " + type
					+ " | " + request
					+ " | " + response
					+ " |\n");
		}
	}

	@Override
	public void postamble(OpenAPI model) {
		String footer =
				"\n[Table X.Y: Extracted ICS ("+level+")]{custom-style=\"FL\"}\n";
		content.append(footer);
	}
}
