/**
 */
package org.etsi.mts.tdl.structuredobjectives;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.etsi.mts.tdl.tdlPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import tdl='tdl.ecore#/'"
 * @generated
 */
public interface StructuredObjectivesPackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "structuredobjectives";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.etsi.org/spec/TDL/1.3.1/structured";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "structured";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	StructuredObjectivesPackage eINSTANCE = org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ElementImpl <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.ElementImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getElement()
	 * @generated
	 */
	int ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__COMMENT = tdlPackage.ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__ANNOTATION = tdlPackage.ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__NAME = tdlPackage.ELEMENT__NAME;

	/**
	 * The number of structural features of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_FEATURE_COUNT = tdlPackage.ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___CONTAINER = tdlPackage.ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___GET_PARENT_TEST_DESCRIPTION = tdlPackage.ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___GET_TEST_OBJECTIVE = tdlPackage.ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___CONTAINS__ELEMENT = tdlPackage.ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT___GET_NOTES = tdlPackage.ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_OPERATION_COUNT = tdlPackage.ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.StructuredTestObjectiveImpl <em>Structured Test Objective</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredTestObjectiveImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getStructuredTestObjective()
	 * @generated
	 */
	int STRUCTURED_TEST_OBJECTIVE = 1;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__COMMENT = tdlPackage.TEST_OBJECTIVE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__ANNOTATION = tdlPackage.TEST_OBJECTIVE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__NAME = tdlPackage.TEST_OBJECTIVE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__QUALIFIED_NAME = tdlPackage.TEST_OBJECTIVE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Objective URI</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__OBJECTIVE_URI = tdlPackage.TEST_OBJECTIVE__OBJECTIVE_URI;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__DESCRIPTION = tdlPackage.TEST_OBJECTIVE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__CONFIGURATION = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Initial Conditions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__INITIAL_CONDITIONS = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expected Behaviour</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__EXPECTED_BEHAVIOUR = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Final Conditions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__FINAL_CONDITIONS = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pics Reference</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__PICS_REFERENCE = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Variants</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE__VARIANTS = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Structured Test Objective</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE_FEATURE_COUNT = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___CONTAINER = tdlPackage.TEST_OBJECTIVE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___GET_PARENT_TEST_DESCRIPTION = tdlPackage.TEST_OBJECTIVE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___CONFORMS_TO__STRING = tdlPackage.TEST_OBJECTIVE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___GET_ELEMENT_NAMED__STRING = tdlPackage.TEST_OBJECTIVE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.TEST_OBJECTIVE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___GET_TEST_OBJECTIVE = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___CONTAINS__ELEMENT = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___GET_NOTES = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Index Of</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE___INDEX_OF__ELEMENT = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Structured Test Objective</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCTURED_TEST_OBJECTIVE_OPERATION_COUNT = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.InitialConditionsImpl <em>Initial Conditions</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.InitialConditionsImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getInitialConditions()
	 * @generated
	 */
	int INITIAL_CONDITIONS = 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS__CONDITIONS = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Initial Conditions</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Initial Conditions</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_CONDITIONS_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventSequenceImpl <em>Event Sequence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventSequenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventSequence()
	 * @generated
	 */
	int EVENT_SEQUENCE = 3;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE__EVENTS = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Sequence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Event Sequence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SEQUENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceImpl <em>Event Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventOccurrence()
	 * @generated
	 */
	int EVENT_OCCURRENCE = 4;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE__TIME_CONSTRAINT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE__TIME_LABEL = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Event Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ExpectedBehaviourImpl <em>Expected Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.ExpectedBehaviourImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getExpectedBehaviour()
	 * @generated
	 */
	int EXPECTED_BEHAVIOUR = 5;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>When Clause</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR__WHEN_CLAUSE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Then Clause</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR__THEN_CLAUSE = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Expected Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Expected Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPECTED_BEHAVIOUR_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.FinalConditionsImpl <em>Final Conditions</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.FinalConditionsImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getFinalConditions()
	 * @generated
	 */
	int FINAL_CONDITIONS = 6;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS__CONDITIONS = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Final Conditions</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Final Conditions</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINAL_CONDITIONS_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.PICSReferenceImpl <em>PICS Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.PICSReferenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getPICSReference()
	 * @generated
	 */
	int PICS_REFERENCE = 7;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Pics</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE__PICS = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>PICS Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>PICS Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_REFERENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.PICSImpl <em>PICS</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.PICSImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getPICS()
	 * @generated
	 */
	int PICS = 8;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS__COMMENT = tdlPackage.PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS__ANNOTATION = tdlPackage.PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS__NAME = tdlPackage.PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS__QUALIFIED_NAME = tdlPackage.PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>PICS</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_FEATURE_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___CONTAINER = tdlPackage.PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___GET_PARENT_TEST_DESCRIPTION = tdlPackage.PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___CONFORMS_TO__STRING = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___GET_ELEMENT_NAMED__STRING = tdlPackage.PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___GET_TEST_OBJECTIVE = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___CONTAINS__ELEMENT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS___GET_NOTES = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>PICS</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PICS_OPERATION_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EntityImpl <em>Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EntityImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEntity()
	 * @generated
	 */
	int ENTITY = 9;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__COMMENT = tdlPackage.PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__ANNOTATION = tdlPackage.PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__NAME = tdlPackage.PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__QUALIFIED_NAME = tdlPackage.PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_FEATURE_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___CONTAINER = tdlPackage.PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___GET_PARENT_TEST_DESCRIPTION = tdlPackage.PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___CONFORMS_TO__STRING = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___GET_ELEMENT_NAMED__STRING = tdlPackage.PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___GET_TEST_OBJECTIVE = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___CONTAINS__ELEMENT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY___GET_NOTES = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_OPERATION_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventImpl <em>Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEvent()
	 * @generated
	 */
	int EVENT = 10;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__COMMENT = tdlPackage.PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__ANNOTATION = tdlPackage.PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__NAME = tdlPackage.PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__QUALIFIED_NAME = tdlPackage.PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The number of structural features of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_FEATURE_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___CONTAINER = tdlPackage.PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_PARENT_TEST_DESCRIPTION = tdlPackage.PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___CONFORMS_TO__STRING = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_ELEMENT_NAMED__STRING = tdlPackage.PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_TEST_OBJECTIVE = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___CONTAINS__ELEMENT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_NOTES = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OPERATION_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceSpecificationImpl <em>Event Occurrence Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceSpecificationImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventOccurrenceSpecification()
	 * @generated
	 */
	int EVENT_OCCURRENCE_SPECIFICATION = 11;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__COMMENT = EVENT_OCCURRENCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__ANNOTATION = EVENT_OCCURRENCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__NAME = EVENT_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__TIME_CONSTRAINT = EVENT_OCCURRENCE__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__TIME_LABEL = EVENT_OCCURRENCE__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Entity Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__ENTITY_REFERENCE = EVENT_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Event Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__EVENT_REFERENCE = EVENT_OCCURRENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Opposite Entity Reference</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__OPPOSITE_ENTITY_REFERENCE = EVENT_OCCURRENCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Event Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION__EVENT_ARGUMENT = EVENT_OCCURRENCE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Event Occurrence Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION_FEATURE_COUNT = EVENT_OCCURRENCE_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION___CONTAINER = EVENT_OCCURRENCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION___GET_PARENT_TEST_DESCRIPTION = EVENT_OCCURRENCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION___GET_TEST_OBJECTIVE = EVENT_OCCURRENCE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION___CONTAINS__ELEMENT = EVENT_OCCURRENCE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION___GET_NOTES = EVENT_OCCURRENCE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Event Occurrence Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OCCURRENCE_SPECIFICATION_OPERATION_COUNT = EVENT_OCCURRENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EntityReferenceImpl <em>Entity Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EntityReferenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEntityReference()
	 * @generated
	 */
	int ENTITY_REFERENCE = 12;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE__ENTITY = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE__COMPONENT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Entity Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Entity Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_REFERENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventReferenceImpl <em>Event Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventReferenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventReference()
	 * @generated
	 */
	int EVENT_REFERENCE = 13;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE__EVENT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Event Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_REFERENCE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ValueImpl <em>Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.ValueImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getValue()
	 * @generated
	 */
	int VALUE = 14;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE__NAME = ELEMENT__NAME;

	/**
	 * The number of structural features of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventArgumentImpl <em>Event Argument</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventArgumentImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventArgument()
	 * @generated
	 */
	int EVENT_ARGUMENT = 15;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT__NAME = ELEMENT__NAME;

	/**
	 * The number of structural features of the '<em>Event Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Event Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ARGUMENT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.DataReferenceImpl <em>Data Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.DataReferenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getDataReference()
	 * @generated
	 */
	int DATA_REFERENCE = 16;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE__COMMENT = VALUE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE__ANNOTATION = VALUE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE__NAME = VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE__CONTENT = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE___CONTAINER = VALUE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE___GET_PARENT_TEST_DESCRIPTION = VALUE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE___GET_TEST_OBJECTIVE = VALUE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE___CONTAINS__ELEMENT = VALUE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE___GET_NOTES = VALUE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Data Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_REFERENCE_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ContentImpl <em>Content</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.ContentImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getContent()
	 * @generated
	 */
	int CONTENT = 17;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__VALUE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__CONTENT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__MEMBER = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Content</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Content</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueImpl <em>Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getLiteralValue()
	 * @generated
	 */
	int LITERAL_VALUE = 18;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE__COMMENT = VALUE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE__ANNOTATION = VALUE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE__NAME = VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE__CONTENT = VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE__DATA_TYPE = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_FEATURE_COUNT = VALUE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE___CONTAINER = VALUE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE___GET_PARENT_TEST_DESCRIPTION = VALUE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE___GET_TEST_OBJECTIVE = VALUE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE___CONTAINS__ELEMENT = VALUE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE___GET_NOTES = VALUE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ContentReferenceImpl <em>Content Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.ContentReferenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getContentReference()
	 * @generated
	 */
	int CONTENT_REFERENCE = 19;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE__COMMENT = VALUE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE__ANNOTATION = VALUE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE__NAME = VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Content</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE__CONTENT = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Content Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE___CONTAINER = VALUE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE___GET_PARENT_TEST_DESCRIPTION = VALUE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE___GET_TEST_OBJECTIVE = VALUE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE___CONTAINS__ELEMENT = VALUE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE___GET_NOTES = VALUE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Content Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_REFERENCE_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueReferenceImpl <em>Literal Value Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueReferenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getLiteralValueReference()
	 * @generated
	 */
	int LITERAL_VALUE_REFERENCE = 20;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE__COMMENT = VALUE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE__ANNOTATION = VALUE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE__NAME = VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Content</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE__CONTENT = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Literal Value Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE___CONTAINER = VALUE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE___GET_PARENT_TEST_DESCRIPTION = VALUE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE___GET_TEST_OBJECTIVE = VALUE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE___CONTAINS__ELEMENT = VALUE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE___GET_NOTES = VALUE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Literal Value Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_REFERENCE_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.RepeatedEventSequenceImpl <em>Repeated Event Sequence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.RepeatedEventSequenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getRepeatedEventSequence()
	 * @generated
	 */
	int REPEATED_EVENT_SEQUENCE = 21;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE__COMMENT = EVENT_SEQUENCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE__ANNOTATION = EVENT_SEQUENCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE__NAME = EVENT_SEQUENCE__NAME;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE__EVENTS = EVENT_SEQUENCE__EVENTS;

	/**
	 * The feature id for the '<em><b>Repetitions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE__REPETITIONS = EVENT_SEQUENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interval</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE__INTERVAL = EVENT_SEQUENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Repeated Event Sequence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE_FEATURE_COUNT = EVENT_SEQUENCE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE___CONTAINER = EVENT_SEQUENCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE___GET_PARENT_TEST_DESCRIPTION = EVENT_SEQUENCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE___GET_TEST_OBJECTIVE = EVENT_SEQUENCE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE___CONTAINS__ELEMENT = EVENT_SEQUENCE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE___GET_NOTES = EVENT_SEQUENCE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Repeated Event Sequence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPEATED_EVENT_SEQUENCE_OPERATION_COUNT = EVENT_SEQUENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventTemplateOccurrenceImpl <em>Event Template Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventTemplateOccurrenceImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventTemplateOccurrence()
	 * @generated
	 */
	int EVENT_TEMPLATE_OCCURRENCE = 22;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__COMMENT = EVENT_OCCURRENCE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__ANNOTATION = EVENT_OCCURRENCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__NAME = EVENT_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Time Constraint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__TIME_CONSTRAINT = EVENT_OCCURRENCE__TIME_CONSTRAINT;

	/**
	 * The feature id for the '<em><b>Time Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__TIME_LABEL = EVENT_OCCURRENCE__TIME_LABEL;

	/**
	 * The feature id for the '<em><b>Event Template</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__EVENT_TEMPLATE = EVENT_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity Binding</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__ENTITY_BINDING = EVENT_OCCURRENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Occurrence Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE__OCCURRENCE_ARGUMENT = EVENT_OCCURRENCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Event Template Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE_FEATURE_COUNT = EVENT_OCCURRENCE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE___CONTAINER = EVENT_OCCURRENCE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE___GET_PARENT_TEST_DESCRIPTION = EVENT_OCCURRENCE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE___GET_TEST_OBJECTIVE = EVENT_OCCURRENCE___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE___CONTAINS__ELEMENT = EVENT_OCCURRENCE___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE___GET_NOTES = EVENT_OCCURRENCE___GET_NOTES;

	/**
	 * The number of operations of the '<em>Event Template Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_TEMPLATE_OCCURRENCE_OPERATION_COUNT = EVENT_OCCURRENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventSpecificationTemplateImpl <em>Event Specification Template</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventSpecificationTemplateImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventSpecificationTemplate()
	 * @generated
	 */
	int EVENT_SPECIFICATION_TEMPLATE = 23;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE__COMMENT = tdlPackage.PACKAGEABLE_ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE__ANNOTATION = tdlPackage.PACKAGEABLE_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE__NAME = tdlPackage.PACKAGEABLE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE__QUALIFIED_NAME = tdlPackage.PACKAGEABLE_ELEMENT__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Event Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE__EVENT_SPECIFICATION = tdlPackage.PACKAGEABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Specification Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE_FEATURE_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___CONTAINER = tdlPackage.PACKAGEABLE_ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___GET_PARENT_TEST_DESCRIPTION = tdlPackage.PACKAGEABLE_ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___CONFORMS_TO__STRING = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___GET_ELEMENT_NAMED__STRING = tdlPackage.PACKAGEABLE_ELEMENT___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.PACKAGEABLE_ELEMENT___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___GET_TEST_OBJECTIVE = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___CONTAINS__ELEMENT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE___GET_NOTES = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Event Specification Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SPECIFICATION_TEMPLATE_OPERATION_COUNT = tdlPackage.PACKAGEABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EntityBindingImpl <em>Entity Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.EntityBindingImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEntityBinding()
	 * @generated
	 */
	int ENTITY_BINDING = 24;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Template Entity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING__TEMPLATE_ENTITY = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Occurrence Entity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING__OCCURRENCE_ENTITY = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Entity Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Entity Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_BINDING_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.VariantsImpl <em>Variants</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.VariantsImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getVariants()
	 * @generated
	 */
	int VARIANTS = 25;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Variants</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS__VARIANTS = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Variants</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Variants</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANTS_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.TestObjectiveVariantImpl <em>Test Objective Variant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.TestObjectiveVariantImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getTestObjectiveVariant()
	 * @generated
	 */
	int TEST_OBJECTIVE_VARIANT = 26;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__COMMENT = tdlPackage.TEST_OBJECTIVE__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__ANNOTATION = tdlPackage.TEST_OBJECTIVE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__NAME = tdlPackage.TEST_OBJECTIVE__NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__QUALIFIED_NAME = tdlPackage.TEST_OBJECTIVE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Objective URI</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__OBJECTIVE_URI = tdlPackage.TEST_OBJECTIVE__OBJECTIVE_URI;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__DESCRIPTION = tdlPackage.TEST_OBJECTIVE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Pics Reference</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__PICS_REFERENCE = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bindings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT__BINDINGS = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Test Objective Variant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT_FEATURE_COUNT = tdlPackage.TEST_OBJECTIVE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___CONTAINER = tdlPackage.TEST_OBJECTIVE___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___GET_PARENT_TEST_DESCRIPTION = tdlPackage.TEST_OBJECTIVE___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___CONFORMS_TO__STRING = tdlPackage.TEST_OBJECTIVE___CONFORMS_TO__STRING;

	/**
	 * The operation id for the '<em>Get Element Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___GET_ELEMENT_NAMED__STRING = tdlPackage.TEST_OBJECTIVE___GET_ELEMENT_NAMED__STRING;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___CONFORMS_TO__PACKAGEABLEELEMENT = tdlPackage.TEST_OBJECTIVE___CONFORMS_TO__PACKAGEABLEELEMENT;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___GET_TEST_OBJECTIVE = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___CONTAINS__ELEMENT = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT___GET_NOTES = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Test Objective Variant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEST_OBJECTIVE_VARIANT_OPERATION_COUNT = tdlPackage.TEST_OBJECTIVE_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.VariantBindingImpl <em>Variant Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.VariantBindingImpl
	 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getVariantBinding()
	 * @generated
	 */
	int VARIANT_BINDING = 27;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING__COMMENT = ELEMENT__COMMENT;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING__ANNOTATION = ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING__VALUE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bound To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING__BOUND_TO = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variant Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Container</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING___CONTAINER = ELEMENT___CONTAINER;

	/**
	 * The operation id for the '<em>Get Parent Test Description</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING___GET_PARENT_TEST_DESCRIPTION = ELEMENT___GET_PARENT_TEST_DESCRIPTION;

	/**
	 * The operation id for the '<em>Get Test Objective</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING___GET_TEST_OBJECTIVE = ELEMENT___GET_TEST_OBJECTIVE;

	/**
	 * The operation id for the '<em>Contains</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING___CONTAINS__ELEMENT = ELEMENT___CONTAINS__ELEMENT;

	/**
	 * The operation id for the '<em>Get Notes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING___GET_NOTES = ELEMENT___GET_NOTES;

	/**
	 * The number of operations of the '<em>Variant Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_BINDING_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.Element <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Element
	 * @generated
	 */
	EClass getElement();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.structuredobjectives.Element#getTestObjective() <em>Get Test Objective</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Test Objective</em>' operation.
	 * @see org.etsi.mts.tdl.structuredobjectives.Element#getTestObjective()
	 * @generated
	 */
	EOperation getElement__GetTestObjective();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.structuredobjectives.Element#contains(org.etsi.mts.tdl.structuredobjectives.Element) <em>Contains</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Contains</em>' operation.
	 * @see org.etsi.mts.tdl.structuredobjectives.Element#contains(org.etsi.mts.tdl.structuredobjectives.Element)
	 * @generated
	 */
	EOperation getElement__Contains__Element();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.structuredobjectives.Element#getNotes() <em>Get Notes</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Notes</em>' operation.
	 * @see org.etsi.mts.tdl.structuredobjectives.Element#getNotes()
	 * @generated
	 */
	EOperation getElement__GetNotes();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective <em>Structured Test Objective</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Structured Test Objective</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective
	 * @generated
	 */
	EClass getStructuredTestObjective();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Configuration</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getConfiguration()
	 * @see #getStructuredTestObjective()
	 * @generated
	 */
	EReference getStructuredTestObjective_Configuration();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getInitialConditions <em>Initial Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Initial Conditions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getInitialConditions()
	 * @see #getStructuredTestObjective()
	 * @generated
	 */
	EReference getStructuredTestObjective_InitialConditions();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getExpectedBehaviour <em>Expected Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expected Behaviour</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getExpectedBehaviour()
	 * @see #getStructuredTestObjective()
	 * @generated
	 */
	EReference getStructuredTestObjective_ExpectedBehaviour();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getFinalConditions <em>Final Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Final Conditions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getFinalConditions()
	 * @see #getStructuredTestObjective()
	 * @generated
	 */
	EReference getStructuredTestObjective_FinalConditions();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getPicsReference <em>Pics Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Pics Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getPicsReference()
	 * @see #getStructuredTestObjective()
	 * @generated
	 */
	EReference getStructuredTestObjective_PicsReference();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getVariants <em>Variants</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Variants</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#getVariants()
	 * @see #getStructuredTestObjective()
	 * @generated
	 */
	EReference getStructuredTestObjective_Variants();

	/**
	 * Returns the meta object for the '{@link org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#indexOf(org.etsi.mts.tdl.structuredobjectives.Element) <em>Index Of</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Index Of</em>' operation.
	 * @see org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective#indexOf(org.etsi.mts.tdl.structuredobjectives.Element)
	 * @generated
	 */
	EOperation getStructuredTestObjective__IndexOf__Element();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.InitialConditions <em>Initial Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Initial Conditions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.InitialConditions
	 * @generated
	 */
	EClass getInitialConditions();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.InitialConditions#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Conditions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.InitialConditions#getConditions()
	 * @see #getInitialConditions()
	 * @generated
	 */
	EReference getInitialConditions_Conditions();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventSequence <em>Event Sequence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Sequence</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventSequence
	 * @generated
	 */
	EClass getEventSequence();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.EventSequence#getEvents <em>Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Events</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventSequence#getEvents()
	 * @see #getEventSequence()
	 * @generated
	 */
	EReference getEventSequence_Events();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrence <em>Event Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Occurrence</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrence
	 * @generated
	 */
	EClass getEventOccurrence();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrence#getTimeConstraint <em>Time Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Time Constraint</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrence#getTimeConstraint()
	 * @see #getEventOccurrence()
	 * @generated
	 */
	EReference getEventOccurrence_TimeConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrence#getTimeLabel <em>Time Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Time Label</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrence#getTimeLabel()
	 * @see #getEventOccurrence()
	 * @generated
	 */
	EReference getEventOccurrence_TimeLabel();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour <em>Expected Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expected Behaviour</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour
	 * @generated
	 */
	EClass getExpectedBehaviour();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour#getWhenClause <em>When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>When Clause</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour#getWhenClause()
	 * @see #getExpectedBehaviour()
	 * @generated
	 */
	EReference getExpectedBehaviour_WhenClause();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour#getThenClause <em>Then Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Then Clause</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour#getThenClause()
	 * @see #getExpectedBehaviour()
	 * @generated
	 */
	EReference getExpectedBehaviour_ThenClause();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.FinalConditions <em>Final Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Final Conditions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.FinalConditions
	 * @generated
	 */
	EClass getFinalConditions();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.FinalConditions#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Conditions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.FinalConditions#getConditions()
	 * @see #getFinalConditions()
	 * @generated
	 */
	EReference getFinalConditions_Conditions();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.PICSReference <em>PICS Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PICS Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.PICSReference
	 * @generated
	 */
	EClass getPICSReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.PICSReference#getPics <em>Pics</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Pics</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.PICSReference#getPics()
	 * @see #getPICSReference()
	 * @generated
	 */
	EReference getPICSReference_Pics();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.PICS <em>PICS</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PICS</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.PICS
	 * @generated
	 */
	EClass getPICS();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.Entity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Entity
	 * @generated
	 */
	EClass getEntity();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.Event <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Event
	 * @generated
	 */
	EClass getEvent();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification <em>Event Occurrence Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Occurrence Specification</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification
	 * @generated
	 */
	EClass getEventOccurrenceSpecification();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEntityReference <em>Entity Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Entity Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEntityReference()
	 * @see #getEventOccurrenceSpecification()
	 * @generated
	 */
	EReference getEventOccurrenceSpecification_EntityReference();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventReference <em>Event Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Event Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventReference()
	 * @see #getEventOccurrenceSpecification()
	 * @generated
	 */
	EReference getEventOccurrenceSpecification_EventReference();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getOppositeEntityReference <em>Opposite Entity Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Opposite Entity Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getOppositeEntityReference()
	 * @see #getEventOccurrenceSpecification()
	 * @generated
	 */
	EReference getEventOccurrenceSpecification_OppositeEntityReference();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventArgument <em>Event Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Event Argument</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification#getEventArgument()
	 * @see #getEventOccurrenceSpecification()
	 * @generated
	 */
	EReference getEventOccurrenceSpecification_EventArgument();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EntityReference <em>Entity Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EntityReference
	 * @generated
	 */
	EClass getEntityReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.EntityReference#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EntityReference#getEntity()
	 * @see #getEntityReference()
	 * @generated
	 */
	EReference getEntityReference_Entity();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.EntityReference#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EntityReference#getComponent()
	 * @see #getEntityReference()
	 * @generated
	 */
	EReference getEntityReference_Component();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventReference <em>Event Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventReference
	 * @generated
	 */
	EClass getEventReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.EventReference#getEvent <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Event</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventReference#getEvent()
	 * @see #getEventReference()
	 * @generated
	 */
	EReference getEventReference_Event();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.Value <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Value
	 * @generated
	 */
	EClass getValue();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventArgument <em>Event Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Argument</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventArgument
	 * @generated
	 */
	EClass getEventArgument();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.DataReference <em>Data Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.DataReference
	 * @generated
	 */
	EClass getDataReference();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.DataReference#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Content</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.DataReference#getContent()
	 * @see #getDataReference()
	 * @generated
	 */
	EReference getDataReference_Content();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.Content <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Content</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Content
	 * @generated
	 */
	EClass getContent();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.Content#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Content#getValue()
	 * @see #getContent()
	 * @generated
	 */
	EReference getContent_Value();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.Content#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Content</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Content#getContent()
	 * @see #getContent()
	 * @generated
	 */
	EReference getContent_Content();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.Content#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Member</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Content#getMember()
	 * @see #getContent()
	 * @generated
	 */
	EReference getContent_Member();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.LiteralValue <em>Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal Value</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.LiteralValue
	 * @generated
	 */
	EClass getLiteralValue();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.LiteralValue#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Content</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.LiteralValue#getContent()
	 * @see #getLiteralValue()
	 * @generated
	 */
	EReference getLiteralValue_Content();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.LiteralValue#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.LiteralValue#getDataType()
	 * @see #getLiteralValue()
	 * @generated
	 */
	EReference getLiteralValue_DataType();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.ContentReference <em>Content Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Content Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.ContentReference
	 * @generated
	 */
	EClass getContentReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.ContentReference#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Content</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.ContentReference#getContent()
	 * @see #getContentReference()
	 * @generated
	 */
	EReference getContentReference_Content();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.LiteralValueReference <em>Literal Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal Value Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.LiteralValueReference
	 * @generated
	 */
	EClass getLiteralValueReference();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.LiteralValueReference#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Content</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.LiteralValueReference#getContent()
	 * @see #getLiteralValueReference()
	 * @generated
	 */
	EReference getLiteralValueReference_Content();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.RepeatedEventSequence <em>Repeated Event Sequence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Repeated Event Sequence</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.RepeatedEventSequence
	 * @generated
	 */
	EClass getRepeatedEventSequence();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.RepeatedEventSequence#getRepetitions <em>Repetitions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Repetitions</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.RepeatedEventSequence#getRepetitions()
	 * @see #getRepeatedEventSequence()
	 * @generated
	 */
	EReference getRepeatedEventSequence_Repetitions();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.RepeatedEventSequence#getInterval <em>Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Interval</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.RepeatedEventSequence#getInterval()
	 * @see #getRepeatedEventSequence()
	 * @generated
	 */
	EReference getRepeatedEventSequence_Interval();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence <em>Event Template Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Template Occurrence</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence
	 * @generated
	 */
	EClass getEventTemplateOccurrence();

	/**
	 * Returns the meta object for the reference '{@link org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence#getEventTemplate <em>Event Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Event Template</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence#getEventTemplate()
	 * @see #getEventTemplateOccurrence()
	 * @generated
	 */
	EReference getEventTemplateOccurrence_EventTemplate();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence#getEntityBinding <em>Entity Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Entity Binding</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence#getEntityBinding()
	 * @see #getEventTemplateOccurrence()
	 * @generated
	 */
	EReference getEventTemplateOccurrence_EntityBinding();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence#getOccurrenceArgument <em>Occurrence Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Occurrence Argument</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventTemplateOccurrence#getOccurrenceArgument()
	 * @see #getEventTemplateOccurrence()
	 * @generated
	 */
	EReference getEventTemplateOccurrence_OccurrenceArgument();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EventSpecificationTemplate <em>Event Specification Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Specification Template</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventSpecificationTemplate
	 * @generated
	 */
	EClass getEventSpecificationTemplate();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EventSpecificationTemplate#getEventSpecification <em>Event Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Event Specification</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EventSpecificationTemplate#getEventSpecification()
	 * @see #getEventSpecificationTemplate()
	 * @generated
	 */
	EReference getEventSpecificationTemplate_EventSpecification();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.EntityBinding <em>Entity Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Binding</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EntityBinding
	 * @generated
	 */
	EClass getEntityBinding();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EntityBinding#getTemplateEntity <em>Template Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Template Entity</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EntityBinding#getTemplateEntity()
	 * @see #getEntityBinding()
	 * @generated
	 */
	EReference getEntityBinding_TemplateEntity();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.EntityBinding#getOccurrenceEntity <em>Occurrence Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Occurrence Entity</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.EntityBinding#getOccurrenceEntity()
	 * @see #getEntityBinding()
	 * @generated
	 */
	EReference getEntityBinding_OccurrenceEntity();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.Variants <em>Variants</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variants</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Variants
	 * @generated
	 */
	EClass getVariants();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.Variants#getVariants <em>Variants</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variants</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.Variants#getVariants()
	 * @see #getVariants()
	 * @generated
	 */
	EReference getVariants_Variants();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant <em>Test Objective Variant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Test Objective Variant</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant
	 * @generated
	 */
	EClass getTestObjectiveVariant();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant#getPicsReference <em>Pics Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Pics Reference</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant#getPicsReference()
	 * @see #getTestObjectiveVariant()
	 * @generated
	 */
	EReference getTestObjectiveVariant_PicsReference();

	/**
	 * Returns the meta object for the containment reference list '{@link org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant#getBindings <em>Bindings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Bindings</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant#getBindings()
	 * @see #getTestObjectiveVariant()
	 * @generated
	 */
	EReference getTestObjectiveVariant_Bindings();

	/**
	 * Returns the meta object for class '{@link org.etsi.mts.tdl.structuredobjectives.VariantBinding <em>Variant Binding</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variant Binding</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.VariantBinding
	 * @generated
	 */
	EClass getVariantBinding();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.VariantBinding#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.VariantBinding#getValue()
	 * @see #getVariantBinding()
	 * @generated
	 */
	EReference getVariantBinding_Value();

	/**
	 * Returns the meta object for the containment reference '{@link org.etsi.mts.tdl.structuredobjectives.VariantBinding#getBoundTo <em>Bound To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Bound To</em>'.
	 * @see org.etsi.mts.tdl.structuredobjectives.VariantBinding#getBoundTo()
	 * @see #getVariantBinding()
	 * @generated
	 */
	EReference getVariantBinding_BoundTo();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	StructuredObjectivesFactory getStructuredObjectivesFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ElementImpl <em>Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.ElementImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getElement()
		 * @generated
		 */
		EClass ELEMENT = eINSTANCE.getElement();

		/**
		 * The meta object literal for the '<em><b>Get Test Objective</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ELEMENT___GET_TEST_OBJECTIVE = eINSTANCE.getElement__GetTestObjective();

		/**
		 * The meta object literal for the '<em><b>Contains</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ELEMENT___CONTAINS__ELEMENT = eINSTANCE.getElement__Contains__Element();

		/**
		 * The meta object literal for the '<em><b>Get Notes</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation ELEMENT___GET_NOTES = eINSTANCE.getElement__GetNotes();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.StructuredTestObjectiveImpl <em>Structured Test Objective</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredTestObjectiveImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getStructuredTestObjective()
		 * @generated
		 */
		EClass STRUCTURED_TEST_OBJECTIVE = eINSTANCE.getStructuredTestObjective();

		/**
		 * The meta object literal for the '<em><b>Configuration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_TEST_OBJECTIVE__CONFIGURATION = eINSTANCE.getStructuredTestObjective_Configuration();

		/**
		 * The meta object literal for the '<em><b>Initial Conditions</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_TEST_OBJECTIVE__INITIAL_CONDITIONS = eINSTANCE.getStructuredTestObjective_InitialConditions();

		/**
		 * The meta object literal for the '<em><b>Expected Behaviour</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_TEST_OBJECTIVE__EXPECTED_BEHAVIOUR = eINSTANCE.getStructuredTestObjective_ExpectedBehaviour();

		/**
		 * The meta object literal for the '<em><b>Final Conditions</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_TEST_OBJECTIVE__FINAL_CONDITIONS = eINSTANCE.getStructuredTestObjective_FinalConditions();

		/**
		 * The meta object literal for the '<em><b>Pics Reference</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_TEST_OBJECTIVE__PICS_REFERENCE = eINSTANCE.getStructuredTestObjective_PicsReference();

		/**
		 * The meta object literal for the '<em><b>Variants</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STRUCTURED_TEST_OBJECTIVE__VARIANTS = eINSTANCE.getStructuredTestObjective_Variants();

		/**
		 * The meta object literal for the '<em><b>Index Of</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation STRUCTURED_TEST_OBJECTIVE___INDEX_OF__ELEMENT = eINSTANCE.getStructuredTestObjective__IndexOf__Element();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.InitialConditionsImpl <em>Initial Conditions</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.InitialConditionsImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getInitialConditions()
		 * @generated
		 */
		EClass INITIAL_CONDITIONS = eINSTANCE.getInitialConditions();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INITIAL_CONDITIONS__CONDITIONS = eINSTANCE.getInitialConditions_Conditions();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventSequenceImpl <em>Event Sequence</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventSequenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventSequence()
		 * @generated
		 */
		EClass EVENT_SEQUENCE = eINSTANCE.getEventSequence();

		/**
		 * The meta object literal for the '<em><b>Events</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_SEQUENCE__EVENTS = eINSTANCE.getEventSequence_Events();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceImpl <em>Event Occurrence</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventOccurrence()
		 * @generated
		 */
		EClass EVENT_OCCURRENCE = eINSTANCE.getEventOccurrence();

		/**
		 * The meta object literal for the '<em><b>Time Constraint</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_OCCURRENCE__TIME_CONSTRAINT = eINSTANCE.getEventOccurrence_TimeConstraint();

		/**
		 * The meta object literal for the '<em><b>Time Label</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_OCCURRENCE__TIME_LABEL = eINSTANCE.getEventOccurrence_TimeLabel();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ExpectedBehaviourImpl <em>Expected Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.ExpectedBehaviourImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getExpectedBehaviour()
		 * @generated
		 */
		EClass EXPECTED_BEHAVIOUR = eINSTANCE.getExpectedBehaviour();

		/**
		 * The meta object literal for the '<em><b>When Clause</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXPECTED_BEHAVIOUR__WHEN_CLAUSE = eINSTANCE.getExpectedBehaviour_WhenClause();

		/**
		 * The meta object literal for the '<em><b>Then Clause</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXPECTED_BEHAVIOUR__THEN_CLAUSE = eINSTANCE.getExpectedBehaviour_ThenClause();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.FinalConditionsImpl <em>Final Conditions</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.FinalConditionsImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getFinalConditions()
		 * @generated
		 */
		EClass FINAL_CONDITIONS = eINSTANCE.getFinalConditions();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FINAL_CONDITIONS__CONDITIONS = eINSTANCE.getFinalConditions_Conditions();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.PICSReferenceImpl <em>PICS Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.PICSReferenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getPICSReference()
		 * @generated
		 */
		EClass PICS_REFERENCE = eINSTANCE.getPICSReference();

		/**
		 * The meta object literal for the '<em><b>Pics</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PICS_REFERENCE__PICS = eINSTANCE.getPICSReference_Pics();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.PICSImpl <em>PICS</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.PICSImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getPICS()
		 * @generated
		 */
		EClass PICS = eINSTANCE.getPICS();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EntityImpl <em>Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EntityImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEntity()
		 * @generated
		 */
		EClass ENTITY = eINSTANCE.getEntity();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventImpl <em>Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEvent()
		 * @generated
		 */
		EClass EVENT = eINSTANCE.getEvent();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceSpecificationImpl <em>Event Occurrence Specification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventOccurrenceSpecificationImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventOccurrenceSpecification()
		 * @generated
		 */
		EClass EVENT_OCCURRENCE_SPECIFICATION = eINSTANCE.getEventOccurrenceSpecification();

		/**
		 * The meta object literal for the '<em><b>Entity Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_OCCURRENCE_SPECIFICATION__ENTITY_REFERENCE = eINSTANCE.getEventOccurrenceSpecification_EntityReference();

		/**
		 * The meta object literal for the '<em><b>Event Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_OCCURRENCE_SPECIFICATION__EVENT_REFERENCE = eINSTANCE.getEventOccurrenceSpecification_EventReference();

		/**
		 * The meta object literal for the '<em><b>Opposite Entity Reference</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_OCCURRENCE_SPECIFICATION__OPPOSITE_ENTITY_REFERENCE = eINSTANCE.getEventOccurrenceSpecification_OppositeEntityReference();

		/**
		 * The meta object literal for the '<em><b>Event Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_OCCURRENCE_SPECIFICATION__EVENT_ARGUMENT = eINSTANCE.getEventOccurrenceSpecification_EventArgument();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EntityReferenceImpl <em>Entity Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EntityReferenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEntityReference()
		 * @generated
		 */
		EClass ENTITY_REFERENCE = eINSTANCE.getEntityReference();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_REFERENCE__ENTITY = eINSTANCE.getEntityReference_Entity();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_REFERENCE__COMPONENT = eINSTANCE.getEntityReference_Component();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventReferenceImpl <em>Event Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventReferenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventReference()
		 * @generated
		 */
		EClass EVENT_REFERENCE = eINSTANCE.getEventReference();

		/**
		 * The meta object literal for the '<em><b>Event</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_REFERENCE__EVENT = eINSTANCE.getEventReference_Event();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ValueImpl <em>Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.ValueImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getValue()
		 * @generated
		 */
		EClass VALUE = eINSTANCE.getValue();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventArgumentImpl <em>Event Argument</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventArgumentImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventArgument()
		 * @generated
		 */
		EClass EVENT_ARGUMENT = eINSTANCE.getEventArgument();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.DataReferenceImpl <em>Data Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.DataReferenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getDataReference()
		 * @generated
		 */
		EClass DATA_REFERENCE = eINSTANCE.getDataReference();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_REFERENCE__CONTENT = eINSTANCE.getDataReference_Content();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ContentImpl <em>Content</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.ContentImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getContent()
		 * @generated
		 */
		EClass CONTENT = eINSTANCE.getContent();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT__VALUE = eINSTANCE.getContent_Value();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT__CONTENT = eINSTANCE.getContent_Content();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT__MEMBER = eINSTANCE.getContent_Member();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueImpl <em>Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getLiteralValue()
		 * @generated
		 */
		EClass LITERAL_VALUE = eINSTANCE.getLiteralValue();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LITERAL_VALUE__CONTENT = eINSTANCE.getLiteralValue_Content();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LITERAL_VALUE__DATA_TYPE = eINSTANCE.getLiteralValue_DataType();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.ContentReferenceImpl <em>Content Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.ContentReferenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getContentReference()
		 * @generated
		 */
		EClass CONTENT_REFERENCE = eINSTANCE.getContentReference();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT_REFERENCE__CONTENT = eINSTANCE.getContentReference_Content();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueReferenceImpl <em>Literal Value Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.LiteralValueReferenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getLiteralValueReference()
		 * @generated
		 */
		EClass LITERAL_VALUE_REFERENCE = eINSTANCE.getLiteralValueReference();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LITERAL_VALUE_REFERENCE__CONTENT = eINSTANCE.getLiteralValueReference_Content();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.RepeatedEventSequenceImpl <em>Repeated Event Sequence</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.RepeatedEventSequenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getRepeatedEventSequence()
		 * @generated
		 */
		EClass REPEATED_EVENT_SEQUENCE = eINSTANCE.getRepeatedEventSequence();

		/**
		 * The meta object literal for the '<em><b>Repetitions</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPEATED_EVENT_SEQUENCE__REPETITIONS = eINSTANCE.getRepeatedEventSequence_Repetitions();

		/**
		 * The meta object literal for the '<em><b>Interval</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPEATED_EVENT_SEQUENCE__INTERVAL = eINSTANCE.getRepeatedEventSequence_Interval();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventTemplateOccurrenceImpl <em>Event Template Occurrence</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventTemplateOccurrenceImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventTemplateOccurrence()
		 * @generated
		 */
		EClass EVENT_TEMPLATE_OCCURRENCE = eINSTANCE.getEventTemplateOccurrence();

		/**
		 * The meta object literal for the '<em><b>Event Template</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_TEMPLATE_OCCURRENCE__EVENT_TEMPLATE = eINSTANCE.getEventTemplateOccurrence_EventTemplate();

		/**
		 * The meta object literal for the '<em><b>Entity Binding</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_TEMPLATE_OCCURRENCE__ENTITY_BINDING = eINSTANCE.getEventTemplateOccurrence_EntityBinding();

		/**
		 * The meta object literal for the '<em><b>Occurrence Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_TEMPLATE_OCCURRENCE__OCCURRENCE_ARGUMENT = eINSTANCE.getEventTemplateOccurrence_OccurrenceArgument();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EventSpecificationTemplateImpl <em>Event Specification Template</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EventSpecificationTemplateImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEventSpecificationTemplate()
		 * @generated
		 */
		EClass EVENT_SPECIFICATION_TEMPLATE = eINSTANCE.getEventSpecificationTemplate();

		/**
		 * The meta object literal for the '<em><b>Event Specification</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_SPECIFICATION_TEMPLATE__EVENT_SPECIFICATION = eINSTANCE.getEventSpecificationTemplate_EventSpecification();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.EntityBindingImpl <em>Entity Binding</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.EntityBindingImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getEntityBinding()
		 * @generated
		 */
		EClass ENTITY_BINDING = eINSTANCE.getEntityBinding();

		/**
		 * The meta object literal for the '<em><b>Template Entity</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_BINDING__TEMPLATE_ENTITY = eINSTANCE.getEntityBinding_TemplateEntity();

		/**
		 * The meta object literal for the '<em><b>Occurrence Entity</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_BINDING__OCCURRENCE_ENTITY = eINSTANCE.getEntityBinding_OccurrenceEntity();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.VariantsImpl <em>Variants</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.VariantsImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getVariants()
		 * @generated
		 */
		EClass VARIANTS = eINSTANCE.getVariants();

		/**
		 * The meta object literal for the '<em><b>Variants</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIANTS__VARIANTS = eINSTANCE.getVariants_Variants();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.TestObjectiveVariantImpl <em>Test Objective Variant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.TestObjectiveVariantImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getTestObjectiveVariant()
		 * @generated
		 */
		EClass TEST_OBJECTIVE_VARIANT = eINSTANCE.getTestObjectiveVariant();

		/**
		 * The meta object literal for the '<em><b>Pics Reference</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_OBJECTIVE_VARIANT__PICS_REFERENCE = eINSTANCE.getTestObjectiveVariant_PicsReference();

		/**
		 * The meta object literal for the '<em><b>Bindings</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEST_OBJECTIVE_VARIANT__BINDINGS = eINSTANCE.getTestObjectiveVariant_Bindings();

		/**
		 * The meta object literal for the '{@link org.etsi.mts.tdl.structuredobjectives.impl.VariantBindingImpl <em>Variant Binding</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.VariantBindingImpl
		 * @see org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl#getVariantBinding()
		 * @generated
		 */
		EClass VARIANT_BINDING = eINSTANCE.getVariantBinding();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIANT_BINDING__VALUE = eINSTANCE.getVariantBinding_Value();

		/**
		 * The meta object literal for the '<em><b>Bound To</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIANT_BINDING__BOUND_TO = eINSTANCE.getVariantBinding_BoundTo();

	}

} //StructuredObjectivesPackage
