/**
 */
package org.etsi.mts.tdl.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.etsi.mts.tdl.BehaviourDescription;
import org.etsi.mts.tdl.FormalParameter;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.tdlPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Test Description</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.etsi.mts.tdl.impl.TestDescriptionImpl#getTestConfiguration <em>Test Configuration</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.TestDescriptionImpl#getFormalParameter <em>Formal Parameter</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.TestDescriptionImpl#getBehaviourDescription <em>Behaviour Description</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.TestDescriptionImpl#getTestObjective <em>Test Objective</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.TestDescriptionImpl#isIsLocallyOrdered <em>Is Locally Ordered</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TestDescriptionImpl extends PackageableElementImpl implements TestDescription
{
	/**
	 * The cached value of the '{@link #getTestConfiguration() <em>Test Configuration</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestConfiguration()
	 * @generated
	 * @ordered
	 */
	protected TestConfiguration testConfiguration;

	/**
	 * The cached value of the '{@link #getFormalParameter() <em>Formal Parameter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormalParameter()
	 * @generated
	 * @ordered
	 */
	protected EList<FormalParameter> formalParameter;

	/**
	 * The cached value of the '{@link #getBehaviourDescription() <em>Behaviour Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehaviourDescription()
	 * @generated
	 * @ordered
	 */
	protected BehaviourDescription behaviourDescription;

	/**
	 * The cached value of the '{@link #getTestObjective() <em>Test Objective</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestObjective()
	 * @generated
	 * @ordered
	 */
	protected EList<TestObjective> testObjective;

	/**
	 * The default value of the '{@link #isIsLocallyOrdered() <em>Is Locally Ordered</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsLocallyOrdered()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_LOCALLY_ORDERED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsLocallyOrdered() <em>Is Locally Ordered</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsLocallyOrdered()
	 * @generated
	 * @ordered
	 */
	protected boolean isLocallyOrdered = IS_LOCALLY_ORDERED_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TestDescriptionImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return tdlPackage.Literals.TEST_DESCRIPTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TestConfiguration getTestConfiguration()
	{
		if (testConfiguration != null && testConfiguration.eIsProxy())
		{
			InternalEObject oldTestConfiguration = (InternalEObject)testConfiguration;
			testConfiguration = (TestConfiguration)eResolveProxy(oldTestConfiguration);
			if (testConfiguration != oldTestConfiguration)
			{
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, tdlPackage.TEST_DESCRIPTION__TEST_CONFIGURATION, oldTestConfiguration, testConfiguration));
			}
		}
		return testConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TestConfiguration basicGetTestConfiguration()
	{
		return testConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTestConfiguration(TestConfiguration newTestConfiguration)
	{
		TestConfiguration oldTestConfiguration = testConfiguration;
		testConfiguration = newTestConfiguration;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, tdlPackage.TEST_DESCRIPTION__TEST_CONFIGURATION, oldTestConfiguration, testConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<FormalParameter> getFormalParameter()
	{
		if (formalParameter == null)
		{
			formalParameter = new EObjectContainmentEList<FormalParameter>(FormalParameter.class, this, tdlPackage.TEST_DESCRIPTION__FORMAL_PARAMETER);
		}
		return formalParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BehaviourDescription getBehaviourDescription()
	{
		return behaviourDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBehaviourDescription(BehaviourDescription newBehaviourDescription, NotificationChain msgs)
	{
		BehaviourDescription oldBehaviourDescription = behaviourDescription;
		behaviourDescription = newBehaviourDescription;
		if (eNotificationRequired())
		{
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION, oldBehaviourDescription, newBehaviourDescription);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBehaviourDescription(BehaviourDescription newBehaviourDescription)
	{
		if (newBehaviourDescription != behaviourDescription)
		{
			NotificationChain msgs = null;
			if (behaviourDescription != null)
				msgs = ((InternalEObject)behaviourDescription).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION, null, msgs);
			if (newBehaviourDescription != null)
				msgs = ((InternalEObject)newBehaviourDescription).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION, null, msgs);
			msgs = basicSetBehaviourDescription(newBehaviourDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION, newBehaviourDescription, newBehaviourDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TestObjective> getTestObjective()
	{
		if (testObjective == null)
		{
			testObjective = new EObjectResolvingEList<TestObjective>(TestObjective.class, this, tdlPackage.TEST_DESCRIPTION__TEST_OBJECTIVE);
		}
		return testObjective;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIsLocallyOrdered()
	{
		return isLocallyOrdered;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIsLocallyOrdered(boolean newIsLocallyOrdered)
	{
		boolean oldIsLocallyOrdered = isLocallyOrdered;
		isLocallyOrdered = newIsLocallyOrdered;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, tdlPackage.TEST_DESCRIPTION__IS_LOCALLY_ORDERED, oldIsLocallyOrdered, isLocallyOrdered));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case tdlPackage.TEST_DESCRIPTION__FORMAL_PARAMETER:
				return ((InternalEList<?>)getFormalParameter()).basicRemove(otherEnd, msgs);
			case tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION:
				return basicSetBehaviourDescription(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case tdlPackage.TEST_DESCRIPTION__TEST_CONFIGURATION:
				if (resolve) return getTestConfiguration();
				return basicGetTestConfiguration();
			case tdlPackage.TEST_DESCRIPTION__FORMAL_PARAMETER:
				return getFormalParameter();
			case tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION:
				return getBehaviourDescription();
			case tdlPackage.TEST_DESCRIPTION__TEST_OBJECTIVE:
				return getTestObjective();
			case tdlPackage.TEST_DESCRIPTION__IS_LOCALLY_ORDERED:
				return isIsLocallyOrdered();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case tdlPackage.TEST_DESCRIPTION__TEST_CONFIGURATION:
				setTestConfiguration((TestConfiguration)newValue);
				return;
			case tdlPackage.TEST_DESCRIPTION__FORMAL_PARAMETER:
				getFormalParameter().clear();
				getFormalParameter().addAll((Collection<? extends FormalParameter>)newValue);
				return;
			case tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION:
				setBehaviourDescription((BehaviourDescription)newValue);
				return;
			case tdlPackage.TEST_DESCRIPTION__TEST_OBJECTIVE:
				getTestObjective().clear();
				getTestObjective().addAll((Collection<? extends TestObjective>)newValue);
				return;
			case tdlPackage.TEST_DESCRIPTION__IS_LOCALLY_ORDERED:
				setIsLocallyOrdered((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case tdlPackage.TEST_DESCRIPTION__TEST_CONFIGURATION:
				setTestConfiguration((TestConfiguration)null);
				return;
			case tdlPackage.TEST_DESCRIPTION__FORMAL_PARAMETER:
				getFormalParameter().clear();
				return;
			case tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION:
				setBehaviourDescription((BehaviourDescription)null);
				return;
			case tdlPackage.TEST_DESCRIPTION__TEST_OBJECTIVE:
				getTestObjective().clear();
				return;
			case tdlPackage.TEST_DESCRIPTION__IS_LOCALLY_ORDERED:
				setIsLocallyOrdered(IS_LOCALLY_ORDERED_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case tdlPackage.TEST_DESCRIPTION__TEST_CONFIGURATION:
				return testConfiguration != null;
			case tdlPackage.TEST_DESCRIPTION__FORMAL_PARAMETER:
				return formalParameter != null && !formalParameter.isEmpty();
			case tdlPackage.TEST_DESCRIPTION__BEHAVIOUR_DESCRIPTION:
				return behaviourDescription != null;
			case tdlPackage.TEST_DESCRIPTION__TEST_OBJECTIVE:
				return testObjective != null && !testObjective.isEmpty();
			case tdlPackage.TEST_DESCRIPTION__IS_LOCALLY_ORDERED:
				return isLocallyOrdered != IS_LOCALLY_ORDERED_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (isLocallyOrdered: ");
		result.append(isLocallyOrdered);
		result.append(')');
		return result.toString();
	}

} //TestDescriptionImpl
