package org.etsi.mts.tdl.execution.java.tri;

import com.google.inject.Provides;
import com.google.inject.Singleton;

/**
 * Example of Guice injector module that is used by execution engine to
 * configure the environment specific adapters.
 * <p>
 * Note that you should only use this interface as an example to provide all
 * relevant implementations and you shouldn't implement this interface directly
 * as extending it breaks the annotation declarations.
 */
public interface ProviderModule extends com.google.inject.Module {
	@Provides
	@Singleton
	SystemAdapter provideSystemAdapter();

	@Provides
	@Singleton
	Validator provideValidator();

	@Provides
	@Singleton
	Reporter provideReporter();

	@Provides
	@Singleton
	default PredefinedFunctions providePredefinedFunctions(RuntimeHelper helper) {
		return new PredefinedFunctions(helper);
	}

	@Provides
	@Singleton
	RuntimeHelper provideRuntimeHelper();
}
