package org.etsi.mts.tdl.execution.java.tri;

import java.util.ArrayList;
import java.util.List;

/**
 * Generic class for encapsulating information about model elements. The
 * concrete type of the element is specified by a sub-class or the context where
 * the element is used. Note that the element does not always represent a TDL
 * meta-class.
 *
 */
public class Element {
	/**
	 * The name of the element as specified in TDL model.
	 */
	public String name;

	/**
	 * The annotations assigned to the element as specified in TDL model.
	 */
	public List<ElementAnnotation> annotations = new ArrayList<ElementAnnotation>();

	public Element() {
	}

	public Element(String name) {
		this.name = name;
	}
}
