package org.etsi.mts.tdl.execution.java.tri;

/**
 * Extends {@link Data Data} to provide name of a parameter. The argument is
 * specified using <code>type</code> and <code>value</code>.
 */
public class Argument<T, V> extends Data<T, V> {
	/**
	 * Name of the parameter as specified in TDL model.
	 */
	private String parameterName;

	public Argument(T type, V value, String parameterName) {
		super(type, value);
		this.parameterName = parameterName;
	}

	public String getParameterName() {
		return parameterName;
	}
}
