/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractExporterDelegate;
import org.docx4j.convert.out.common.AbstractWmlExporter;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFOExporter
extends AbstractWmlExporter<FOSettings, FOConversionContext> {
    private static Logger log = LoggerFactory.getLogger(AbstractFOExporter.class);
    protected static final int DEFAULT_START_SIZE = 10240;

    protected AbstractFOExporter(AbstractExporterDelegate<FOSettings, FOConversionContext> exporterDelegate) {
        super(exporterDelegate);
    }

    @Override
    protected FOConversionContext createContext(FOSettings conversionSettings, WordprocessingMLPackage preprocessedPackage, ConversionSectionWrappers sectionWrappers) {
        return new FOConversionContext(conversionSettings, preprocessedPackage, sectionWrappers);
    }

    @Override
    protected OutputStream createIntermediateOutputStream(OutputStream outputStream) throws Docx4JException {
        return new ByteArrayOutputStream(10240);
    }

    @Override
    protected void postprocess(FOSettings conversionSettings, AbstractConversionContext conversionContext, OutputStream intermediateOutputStream, OutputStream outputStream) throws Docx4JException {
        String foDocument = null;
        File dumpFoFile = conversionSettings.getFoDumpFile();
        FOConversionContext foConversionContext = (FOConversionContext)conversionContext;
        try {
            foDocument = ((ByteArrayOutputStream)intermediateOutputStream).toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            foDocument = ((ByteArrayOutputStream)intermediateOutputStream).toString();
        }
        if (log.isDebugEnabled()) {
            log.debug(foDocument);
        }
        if (dumpFoFile != null) {
            try {
                FileUtils.writeStringToFile((File)dumpFoFile, (String)foDocument, (String)"UTF-8");
                log.info("Saved " + dumpFoFile.getPath());
            }
            catch (IOException e) {
                log.warn("fo file couldn't be dumped to " + dumpFoFile.getPath() + ": " + e, (Throwable)e);
            }
        }
        foConversionContext.getFORenderer().render(foDocument, conversionSettings, foConversionContext.isRequires2Pass(), this.createPageNumberInformation(foConversionContext), outputStream);
    }

    protected List<FORenderer.SectionPageInformation> createPageNumberInformation(FOConversionContext conversionContext) {
        List<ConversionSectionWrapper> wrapperList = null;
        ArrayList<FoSectionPageInformation> ret = Collections.EMPTY_LIST;
        ConversionSectionWrapper section = null;
        String sectionId = null;
        String pageFoFormat = null;
        String pageWordFormat = null;
        FoSectionPageInformation pageNumberInformation = null;
        if (conversionContext.isRequires2Pass()) {
            wrapperList = conversionContext.getSections().getList();
            ret = new ArrayList<FoSectionPageInformation>(wrapperList.size());
            for (int i = 0; i < wrapperList.size(); ++i) {
                section = wrapperList.get(i);
                pageWordFormat = section.getPageNumberInformation().getPageFormat();
                pageFoFormat = FormattingSwitchHelper.getFoPageNumberFormat(pageWordFormat);
                sectionId = section.getId();
                if (pageFoFormat == null) {
                    pageFoFormat = "1";
                }
                pageNumberInformation = new FoSectionPageInformation("field_numpages_" + sectionId + "_value", pageFoFormat, "field_sectionpages_" + sectionId + "_value", pageFoFormat);
                ret.add(pageNumberInformation);
            }
        }
        return ret;
    }

    protected static class FoSectionPageInformation
    implements FORenderer.SectionPageInformation {
        protected String documentPageCountID = null;
        protected String documentPageCountFoFormat = null;
        protected String sectionPageCountID = null;
        protected String sectionPageCountFoFormat = null;

        public FoSectionPageInformation(String documentPageCountID, String documentPageCountFoFormat, String sectionPageCountID, String sectionPageCountFoFormat) {
            this.documentPageCountID = documentPageCountID;
            this.documentPageCountFoFormat = documentPageCountFoFormat;
            this.sectionPageCountID = sectionPageCountID;
            this.sectionPageCountFoFormat = sectionPageCountFoFormat;
        }

        public String getDocumentPageCountID() {
            return this.documentPageCountID;
        }

        public String getDocumentPageCountFoFormat() {
            return this.documentPageCountFoFormat;
        }

        public String getSectionPageCountID() {
            return this.sectionPageCountID;
        }

        public String getSectionPageCountFoFormat() {
            return this.sectionPageCountFoFormat;
        }
    }
}

