/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfDraw {
    private static int getWindingRule(HwmfGraphics ctx) {
        return ctx.getProperties().getPolyfillMode().awtFlag;
    }

    public static class WmfSelectObject
    implements HwmfRecord {
        private int objectIndex;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.selectObject;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.objectIndex = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.objectIndex);
        }
    }

    public static class WmfChord
    extends WmfArc {
        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.chord;
        }
    }

    public static class WmfPie
    extends WmfArc {
        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.pie;
        }
    }

    public static class WmfArc
    implements HwmfRecord {
        private int yEndArc;
        private int xEndArc;
        private int yStartArc;
        private int xStartArc;
        private int bottomRect;
        private int rightRect;
        private int topRect;
        private int leftRect;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.arc;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.yEndArc = leis.readShort();
            this.xEndArc = leis.readShort();
            this.yStartArc = leis.readShort();
            this.xStartArc = leis.readShort();
            this.bottomRect = leis.readShort();
            this.rightRect = leis.readShort();
            this.topRect = leis.readShort();
            this.leftRect = leis.readShort();
            return 16;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            boolean fillShape;
            int arcClosure;
            double endAngle;
            int x = Math.min(this.leftRect, this.rightRect);
            int y = Math.min(this.topRect, this.bottomRect);
            int w = Math.abs(this.leftRect - this.rightRect - 1);
            int h = Math.abs(this.topRect - this.bottomRect - 1);
            double startAngle = Math.toDegrees(Math.atan2(-((double)this.yStartArc - ((double)this.topRect + (double)h / 2.0)), (double)this.xStartArc - ((double)this.leftRect + (double)w / 2.0)));
            double arcAngle = endAngle - startAngle + (double)((endAngle = Math.toDegrees(Math.atan2(-((double)this.yEndArc - ((double)this.topRect + (double)h / 2.0)), (double)this.xEndArc - ((double)this.leftRect + (double)w / 2.0)))) - startAngle > 0.0 ? 0 : 360);
            if (startAngle < 0.0) {
                startAngle += 360.0;
            }
            switch (this.getRecordType()) {
                default: {
                    arcClosure = 0;
                    fillShape = false;
                    break;
                }
                case chord: {
                    arcClosure = 1;
                    fillShape = true;
                    break;
                }
                case pie: {
                    arcClosure = 2;
                    fillShape = true;
                }
            }
            Arc2D.Double s = new Arc2D.Double(x, y, w, h, startAngle, arcAngle, arcClosure);
            if (fillShape) {
                ctx.fill(s);
            } else {
                ctx.draw(s);
            }
        }
    }

    public static class WmfRoundRect
    implements HwmfRecord {
        private int height;
        private int width;
        private int bottomRect;
        private int rightRect;
        private int topRect;
        private int leftRect;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.roundRect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.height = leis.readShort();
            this.width = leis.readShort();
            this.bottomRect = leis.readShort();
            this.rightRect = leis.readShort();
            this.topRect = leis.readShort();
            this.leftRect = leis.readShort();
            return 12;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            int x = Math.min(this.leftRect, this.rightRect);
            int y = Math.min(this.topRect, this.bottomRect);
            int w = Math.abs(this.leftRect - this.rightRect - 1);
            int h = Math.abs(this.topRect - this.bottomRect - 1);
            RoundRectangle2D.Double s = new RoundRectangle2D.Double(x, y, w, h, this.width, this.height);
            ctx.fill(s);
        }
    }

    public static class WmfSetPixel
    implements HwmfRecord {
        HwmfColorRef colorRef;
        private int y;
        private int x;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setPixel;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.colorRef = new HwmfColorRef();
            int size = this.colorRef.init(leis);
            this.y = leis.readShort();
            this.x = leis.readShort();
            return 4 + size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D.Double s = new Rectangle2D.Double(this.x, this.y, 1.0, 1.0);
            ctx.fill(s);
        }
    }

    public static class WmfRectangle
    implements HwmfRecord {
        private int bottomRect;
        private int rightRect;
        private int topRect;
        private int leftRect;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.frameRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.bottomRect = leis.readShort();
            this.rightRect = leis.readShort();
            this.topRect = leis.readShort();
            this.leftRect = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            int x = Math.min(this.leftRect, this.rightRect);
            int y = Math.min(this.topRect, this.bottomRect);
            int w = Math.abs(this.leftRect - this.rightRect - 1);
            int h = Math.abs(this.topRect - this.bottomRect - 1);
            Rectangle2D.Double s = new Rectangle2D.Double(x, y, w, h);
            ctx.fill(s);
        }
    }

    public static class WmfPolyPolygon
    implements HwmfRecord {
        private List<Path2D> polyList = new ArrayList<Path2D>();

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.polyPolygon;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int numberOfPolygons = leis.readUShort();
            int[] pointsPerPolygon = new int[numberOfPolygons];
            int size = 2;
            for (int i = 0; i < numberOfPolygons; ++i) {
                pointsPerPolygon[i] = leis.readUShort();
                size += 2;
            }
            for (int nPoints : pointsPerPolygon) {
                Path2D.Double poly = new Path2D.Double();
                for (int i = 0; i < nPoints; ++i) {
                    short x = leis.readShort();
                    short y = leis.readShort();
                    size += 4;
                    if (i == 0) {
                        ((Path2D)poly).moveTo(x, y);
                        continue;
                    }
                    ((Path2D)poly).lineTo(x, y);
                }
                poly.closePath();
                this.polyList.add(poly);
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            if (this.polyList.isEmpty()) {
                return;
            }
            int windingRule = HwmfDraw.getWindingRule(ctx);
            Area area = null;
            for (Path2D poly : this.polyList) {
                Path2D p = (Path2D)poly.clone();
                p.setWindingRule(windingRule);
                Area newArea = new Area(p);
                if (area == null) {
                    area = newArea;
                    continue;
                }
                area.exclusiveOr(newArea);
            }
            ctx.fill(area);
        }
    }

    public static class WmfFrameRegion
    implements HwmfRecord {
        private int regionIndex;
        private int brushIndex;
        private int height;
        private int width;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.frameRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.regionIndex = leis.readUShort();
            this.brushIndex = leis.readUShort();
            this.height = leis.readShort();
            this.width = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.brushIndex);
            ctx.applyObjectTableEntry(this.regionIndex);
            Rectangle inner = ctx.getProperties().getRegion().getBounds();
            double x = ((RectangularShape)inner).getX() - (double)this.width;
            double y = ((RectangularShape)inner).getY() - (double)this.height;
            double w = ((RectangularShape)inner).getWidth() + (double)(2 * this.width);
            double h = ((RectangularShape)inner).getHeight() + (double)(2 * this.height);
            Rectangle2D.Double outer = new Rectangle2D.Double(x, y, w, h);
            Area frame = new Area(outer);
            frame.subtract(new Area(inner));
            ctx.fill(frame);
        }
    }

    public static class WmfEllipse
    implements HwmfRecord {
        private int bottomRect;
        private int rightRect;
        private int topRect;
        private int leftRect;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.ellipse;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.bottomRect = leis.readShort();
            this.rightRect = leis.readShort();
            this.topRect = leis.readShort();
            this.leftRect = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            int x = Math.min(this.leftRect, this.rightRect);
            int y = Math.min(this.topRect, this.bottomRect);
            int w = Math.abs(this.leftRect - this.rightRect - 1);
            int h = Math.abs(this.topRect - this.bottomRect - 1);
            Ellipse2D.Double s = new Ellipse2D.Double(x, y, w, h);
            ctx.fill(s);
        }
    }

    public static class WmfPolyline
    extends WmfPolygon {
        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.polyline;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Path2D shape = this.getShape();
            Path2D p = (Path2D)shape.clone();
            p.setWindingRule(HwmfDraw.getWindingRule(ctx));
            ctx.draw(p);
        }
    }

    public static class WmfPolygon
    implements HwmfRecord {
        private Path2D poly = new Path2D.Double();

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.polygon;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int numberofPoints = leis.readShort();
            for (int i = 0; i < numberofPoints; ++i) {
                short x = leis.readShort();
                short y = leis.readShort();
                if (i == 0) {
                    this.poly.moveTo(x, y);
                    continue;
                }
                this.poly.lineTo(x, y);
            }
            return 2 + numberofPoints * 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Path2D shape = this.getShape();
            Path2D p = (Path2D)shape.clone();
            p.setWindingRule(HwmfDraw.getWindingRule(ctx));
            ctx.fill(p);
        }

        protected Path2D getShape() {
            return (Path2D)this.poly.clone();
        }
    }

    public static class WmfLineTo
    implements HwmfRecord {
        private int y;
        private int x;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.lineTo;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.y = leis.readShort();
            this.x = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Point2D start = ctx.getProperties().getLocation();
            Line2D.Double line = new Line2D.Double(start.getX(), start.getY(), this.x, this.y);
            ctx.draw(line);
            ctx.getProperties().setLocation(this.x, this.y);
        }
    }

    public static class WmfMoveTo
    implements HwmfRecord {
        private int y;
        private int x;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.moveTo;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.y = leis.readShort();
            this.x = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setLocation(this.x, this.y);
        }
    }
}

