package org.etsi.mts.tdl.constraints.ui.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.constraints.evl.Validator;

import com.google.inject.Guice;
import com.google.inject.Injector;

/**
 * Our sample handler extends AbstractHandler, an IHandler base class.
 * @see org.eclipse.core.commands.IHandler
 * @see org.eclipse.core.commands.AbstractHandler
 */
public class ValidationHandler extends AbstractHandler {

	private IWorkbenchWindow window;

	/**
	 * The constructor.
	 */
	public ValidationHandler() {
	}
	
	/**
	 * the command has been executed, so extract extract the needed information
	 * from the application context.
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		IEditorInput input = HandlerUtil.getActiveEditorInput(event);
		IFile file = null;
		IProject project = null;
		if (input != null && input instanceof FileEditorInput) {
			file = ((FileEditorInput) input).getFile();
			project = file.getProject();
		} else if (selection !=null && selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			Object firstElement = structuredSelection.getFirstElement();
			if (firstElement instanceof IFile) {
				file = (IFile) firstElement;
				project = file.getProject();
			}
		}
		
		if (file !=null) {
			URI uri = URI.createPlatformResourceURI(file.getFullPath().toString(), true);

			Injector injector = Guice.createInjector();
			XtextResourceSet rs = injector.getInstance(XtextResourceSet.class);
			Resource r = rs.getResource(uri, true);
			//DONE: either here or in Validator -> currently Validator
//			EcoreUtil.resolveAll(xr);
			
			Validator validator = new Validator();
			String messages = "";
			try {
				List<UnsatisfiedConstraint> violations = validator.validate(r);
				for (UnsatisfiedConstraint v : violations) {
					messages += v.getMessage()+"\n";
					//TODO: this can only work with XtextResources
					if (((EObject) v.getInstance()).eResource() instanceof XtextResource) {
						ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject) v.getInstance());
						String text = "\tLine "+node.getStartLine()+"-"+node.getEndLine()+ ":\n\t"+node.getText().trim();
						messages += "  "+text+"\n\n";
					} else {
						//TODO: dump tree-based representation?
					}
				}

				if (violations.size() == 0) {
					messages = "No violations!";
				}
			} catch (Exception e) {
				messages = "An error occurred:" 
						+ e.getMessage().replaceAll("\n.+epsilon/", "\n  at (epsilon/");
			}
			//DONE: Add custom scrollable dialog 
			ScrollableMessageDialog sdialog = new ScrollableMessageDialog(Display.getDefault().getActiveShell(), "Validation Results", null, "The following constraint violations occurred while validating '"+uri.lastSegment()+"':", MessageDialog.INFORMATION, new String[]{"OK"}, 0, messages);
			sdialog.open();
		}
		return null;
	}

	//TODO: cleanup - attempt to load resources manually..
	private void addResourcePaths(IProject project, XtextResourceSet xrs) {
		ArrayList<String> resourcePaths = new ArrayList<>();
		try {
			Map<String,Object> extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
			project.accept(new IResourceVisitor() {

				@Override
				public boolean visit(IResource resource) throws CoreException {
					System.out.println(resource.getFullPath());
					if (extensionToFactoryMap.containsKey(resource.getFileExtension())) {
						resourcePaths.add(resource.getFullPath().toOSString());
					}
					return true;
				}
				
			});
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		for (String p : resourcePaths) {
			URI pURI = URI.createPlatformResourceURI(p, true);
			Resource pr = xrs.getResource(pURI, true);
			try {
				pr.load(Collections.emptyMap());
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	@Override
	public boolean isEnabled() {
		return true;
	}
}
