/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractVisitorExporterDelegate;
import org.docx4j.convert.out.common.AbstractVisitorExporterGenerator;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.convert.out.fo.XsltFOFunctions;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.images.WordXmlPictureE10;
import org.docx4j.model.images.WordXmlPictureE20;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STTabJc;
import org.docx4j.wml.STTabTlc;
import org.docx4j.wml.Style;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOExporterVisitorGenerator
extends AbstractVisitorExporterGenerator<FOConversionContext> {
    private static Logger log = LoggerFactory.getLogger(FOExporterVisitorGenerator.class);
    private static String XSL_FO = "http://www.w3.org/1999/XSL/Format";
    public static final AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<FOConversionContext> GENERATOR_FACTORY = new AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<FOConversionContext>(){

        @Override
        public AbstractVisitorExporterGenerator<FOConversionContext> createInstance(FOConversionContext conversionContext, Document document, Node parentNode) {
            return new FOExporterVisitorGenerator(conversionContext, document, parentNode);
        }
    };

    private FOExporterVisitorGenerator(FOConversionContext conversionContext, Document document, Node parentNode) {
        super(conversionContext, document, parentNode);
    }

    @Override
    protected AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<FOConversionContext> getFactory() {
        return GENERATOR_FACTORY;
    }

    @Override
    protected DocumentFragment createImage(int imgType, FOConversionContext conversionContext, Object anchorOrInline) {
        switch (imgType) {
            case 1: {
                return WordXmlPictureE10.createXslFoImgE10((AbstractWmlConversionContext)conversionContext, anchorOrInline);
            }
            case 2: {
                return WordXmlPictureE20.createXslFoImgE20((AbstractWmlConversionContext)conversionContext, anchorOrInline);
            }
        }
        return null;
    }

    @Override
    protected Element createNode(Document doc, int nodeType) {
        switch (nodeType) {
            case 1: {
                return this.document.createElementNS(XSL_FO, "block");
            }
            case 2: {
                return this.document.createElementNS(XSL_FO, "inline");
            }
        }
        return null;
    }

    @Override
    protected void handleBr(Br br) {
        boolean firstBr = true;
        R r = (R)br.getParent();
        int pos = this.getPos(r.getContent(), br);
        if (pos < 0) {
            log.error("Couldn't locate w:br in w:r");
        } else if (pos == 0) {
            Object rParent = r.getParent();
            if (rParent instanceof P) {
                List<Object> list;
                Object previous;
                Object beforeR;
                P parentP = (P)rParent;
                pos = this.getPos(parentP.getContent(), r);
                if (pos < 0) {
                    log.error("Couldn't locate w:r in w:p");
                } else if (pos > 0 && (beforeR = parentP.getContent().get(pos - 1)) instanceof R && (previous = (list = ((R)beforeR).getContent()).get(list.size() - 1)) instanceof Br) {
                    firstBr = false;
                }
            } else {
                log.info("TODO: handle run parent " + rParent.getClass().getName());
            }
        } else {
            Object previous = r.getContent().get(pos - 1);
            if (previous instanceof Br) {
                firstBr = false;
            }
        }
        if (!firstBr && (br.getType() == null || br.getType().equals((Object)STBrType.TEXT_WRAPPING))) {
            Element ret = this.createNode(this.document, 1);
            ret.setAttribute("linefeed-treatment", "preserve");
            ret.setAttribute("white-space-treatment", "preserve");
            ret.setTextContent("\n");
            this.getCurrentParent().appendChild(ret);
        } else {
            this.convertToNode(this.conversionContext, br, "w:br", this.document, this.getCurrentParent());
        }
        if (br.getType() != null && br.getType().equals((Object)STBrType.PAGE)) {
            this.currentSpan = null;
        }
    }

    @Override
    protected void convertTabToNode(FOConversionContext conversionContext, Document document) throws DOMException {
        if (!conversionContext.isInComplexFieldDefinition()) {
            if (this.pPr != null && this.pPr.getTabs() != null) {
                CTTabStop tabStop = this.pPr.getTabs().getTab().get(0);
                if (tabStop != null && tabStop.getLeader().equals((Object)STTabTlc.DOT) && tabStop.getVal().equals((Object)STTabJc.RIGHT)) {
                    Element foLeader = document.createElementNS(XSL_FO, "leader");
                    foLeader.setAttribute("leader-length.minimum", "12pt");
                    foLeader.setAttribute("leader-length.maximum", "100%");
                    foLeader.setAttribute("leader-length.optimum", "40pt");
                    foLeader.setAttribute("leader-pattern", "dots");
                    this.getCurrentParent().appendChild(foLeader);
                } else {
                    this.getCurrentParent().appendChild(document.createTextNode("\u00a0\u00a0\u00a0"));
                }
            } else {
                this.getCurrentParent().appendChild(document.createTextNode("\u00a0\u00a0\u00a0"));
            }
        }
    }

    @Override
    protected Element handlePPr(FOConversionContext conversionContext, PPr pPrDirect, boolean sdt, Element currentParent) {
        Style defaultParagraphStyle;
        Element ret = currentParent;
        PropertyResolver propertyResolver = conversionContext.getPropertyResolver();
        String defaultParagraphStyleId = "Normal";
        if (conversionContext.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false) != null && (defaultParagraphStyle = conversionContext.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle()) != null) {
            defaultParagraphStyleId = defaultParagraphStyle.getStyleId();
        }
        String pStyleVal = null;
        pStyleVal = pPrDirect != null && pPrDirect.getPStyle() != null ? pPrDirect.getPStyle().getVal() : defaultParagraphStyleId;
        this.getLog().debug("style '" + pStyleVal);
        try {
            this.pPr = propertyResolver.getEffectivePPr(pPrDirect);
            this.getLog().debug("getting rPr for paragraph style");
            this.rPr = propertyResolver.getEffectiveRPr(null, pPrDirect);
            RPr rPrParagraphMark = XmlUtils.deepCopy(this.rPr);
            if (pPrDirect != null) {
                StyleUtil.apply(pPrDirect.getRPr(), rPrParagraphMark);
            }
            if (this.getLog().isDebugEnabled() && this.pPr != null) {
                this.getLog().debug(XmlUtils.marshaltoString((Object)this.pPr, true, true));
            }
            boolean inlist = false;
            boolean indentHandledByNumbering = false;
            Element foBlockElement = null;
            Element foListBlock = null;
            if (this.pPr != null && this.pPr.getNumPr() != null && this.pPr.getNumPr().getNumId() != null && this.pPr.getNumPr().getNumId().getVal().longValue() != 0L) {
                Emulator.ResultTriple triple;
                inlist = true;
                foListBlock = this.document.createElementNS(XSL_FO, "list-block");
                currentParent.appendChild(foListBlock);
                if (this.pPr.getShd() != null) {
                    PShading pShading = new PShading(this.pPr.getShd());
                    pShading.setXslFO(foListBlock);
                }
                Element foListItem = this.document.createElementNS(XSL_FO, "list-item");
                foListBlock.appendChild(foListItem);
                Element foListItemLabel = this.document.createElementNS(XSL_FO, "list-item-label");
                foListItem.appendChild(foListItemLabel);
                Element foListItemLabelBody = this.document.createElementNS(XSL_FO, "block");
                foListItemLabel.appendChild(foListItemLabelBody);
                Element foListItemBody = this.document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-body");
                foListItem.appendChild(foListItemBody);
                foListItemBody.setAttribute("start-indent", "body-start()");
                if (pPrDirect != null && pPrDirect.getNumPr() != null) {
                    triple = Emulator.getNumber(conversionContext.getWmlPackage(), pStyleVal, pPrDirect.getNumPr().getNumId().getVal().toString(), pPrDirect.getNumPr().getIlvl().getVal().toString());
                } else {
                    PPrBase.NumPr.Ilvl ilvl = this.pPr.getNumPr().getIlvl();
                    String ilvlString = ilvl == null ? "0" : ilvl.getVal().toString();
                    triple = null;
                    if (this.pPr.getNumPr().getNumId() != null) {
                        triple = Emulator.getNumber(conversionContext.getWmlPackage(), pStyleVal, this.pPr.getNumPr().getNumId().getVal().toString(), ilvlString);
                    }
                }
                if (triple == null) {
                    this.getLog().warn("computed number ResultTriple was null");
                    if (this.getLog().isDebugEnabled()) {
                        foListItemLabelBody.setTextContent("nrt");
                    }
                } else if (triple.getRPr() == null) {
                    if (this.pPr.getRPr() == null) {
                        XsltFOFunctions.setFont(conversionContext, foListItemLabelBody, this.pPr, this.rPr, triple.getNumString());
                    } else {
                        FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), rPrParagraphMark, foListItemLabel);
                        FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), rPrParagraphMark, foListItemBody);
                        XsltFOFunctions.setFont(conversionContext, foListItemLabelBody, this.pPr, rPrParagraphMark, triple.getNumString());
                    }
                } else {
                    RPr actual = XmlUtils.deepCopy(triple.getRPr());
                    XsltFOFunctions.setFont(conversionContext, foListItemLabelBody, this.pPr, actual, triple.getNumString());
                    StyleUtil.apply(rPrParagraphMark, actual);
                    FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), actual, foListItemLabel);
                    FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), actual, foListItemBody);
                }
                int numChars = 1;
                if (triple.getBullet() != null) {
                    foListItemLabelBody.setTextContent(triple.getBullet());
                } else if (triple.getNumString() == null) {
                    this.getLog().warn("computed NumString was null!");
                    if (this.getLog().isDebugEnabled()) {
                        foListItemLabelBody.setTextContent("nns");
                    }
                    numChars = 0;
                } else {
                    Text number = this.document.createTextNode(triple.getNumString());
                    foListItemLabelBody.appendChild(number);
                    numChars = triple.getNumString().length();
                }
                Indent indent = new Indent(pPrDirect.getInd(), triple.getIndent());
                if (indent.isHanging()) {
                    indent.setXslFOListBlock(foListBlock, -1);
                } else {
                    int numWidth = 90 * numChars;
                    int pdbs = XsltFOFunctions.getDistanceToNextTabStop(conversionContext, indent.getNumberPosition(), numWidth, pPrDirect.getTabs(), conversionContext.getWmlPackage().getMainDocumentPart().getDocumentSettingsPart());
                    indent.setXslFOListBlock(foListBlock, pdbs);
                }
                indentHandledByNumbering = true;
                foBlockElement = this.document.createElementNS(XSL_FO, "block");
                foListItemBody.appendChild(foBlockElement);
                ret = foBlockElement;
            }
            if (this.pPr != null) {
                boolean ignoreBorders = !sdt;
                this.createFoAttributes(conversionContext, this.pPr, currentParent, inlist, ignoreBorders);
            }
            if (this.rPr != null) {
                if (foListBlock == null) {
                    FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), this.rPr, currentParent);
                } else {
                    FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), this.rPr, foListBlock);
                }
            }
        }
        catch (Exception e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    protected void createFoAttributes(FOConversionContext conversionContext, PPr pPr, Element foBlockElement, boolean inList, boolean ignoreBorders) {
        CTTabStop tabStop;
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)conversionContext.getWmlPackage(), pPr);
        for (Property p : properties) {
            if (p == null || ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom)) continue;
            if (inList && !(p instanceof Indent)) {
                p.setXslFO(foBlockElement);
                continue;
            }
            if (inList) continue;
            p.setXslFO(foBlockElement);
        }
        if (pPr == null) {
            return;
        }
        if (pPr.getBidi() != null && pPr.getBidi().isVal() && pPr.getJc() != null) {
            if (pPr.getJc().getVal().equals((Object)JcEnumeration.RIGHT)) {
                foBlockElement.setAttribute("text-align", "left");
            } else if (pPr.getJc().getVal().equals((Object)JcEnumeration.LEFT)) {
                foBlockElement.setAttribute("text-align", "right");
            }
        }
        if (pPr.getTabs() != null && (tabStop = pPr.getTabs().getTab().get(0)) != null && tabStop.getVal().equals((Object)STTabJc.RIGHT)) {
            foBlockElement.setAttribute("text-align-last", "justify");
        }
    }

    protected static void applyFoAttributes(List<Property> properties, Element foElement) {
        if (properties != null && !properties.isEmpty()) {
            for (int i = 0; i < properties.size(); ++i) {
                properties.get(i).setXslFO(foElement);
            }
        }
    }

    protected static void createFoAttributes(TrPr trPr, Element foBlockElement) {
        if (trPr == null) {
            return;
        }
        FOExporterVisitorGenerator.applyFoAttributes(PropertyFactory.createProperties(trPr), foBlockElement);
    }

    protected static void createFoAttributes(TcPr tcPr, Element foBlockElement) {
        if (tcPr == null) {
            return;
        }
        FOExporterVisitorGenerator.applyFoAttributes(PropertyFactory.createProperties(tcPr), foBlockElement);
    }

    @Override
    protected void handleRPr(FOConversionContext conversionContext, PPr pPrDirect, RPr rPrDirect, Element currentParent) {
        PropertyResolver propertyResolver = conversionContext.getPropertyResolver();
        try {
            RPr rPr = propertyResolver.getEffectiveRPr(rPrDirect, pPrDirect);
            if (this.getLog().isDebugEnabled() && rPr != null) {
                this.getLog().debug(XmlUtils.marshaltoString((Object)rPr, true, true));
            }
            FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), rPr, currentParent);
        }
        catch (Exception e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    protected static void createFoAttributes(WordprocessingMLPackage wmlPackage, RPr rPr, Element foInlineElement) {
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)wmlPackage, rPr);
        for (Property p : properties) {
            p.setXslFO(foInlineElement);
        }
    }

    @Override
    protected void rtlAwareAppendChildToCurrentP(Element spanEl) {
        if (this.rPr != null && this.rPr.getRtl() != null && this.rPr.getRtl().isVal()) {
            spanEl.removeAttribute("direction");
            Element bidiOverride = this.document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:bidi-override");
            bidiOverride.setAttribute("unicode-bidi", "embed");
            bidiOverride.setAttribute("direction", "rtl");
            bidiOverride.appendChild(spanEl);
            this.currentP.appendChild(bidiOverride);
        } else {
            this.currentP.appendChild(spanEl);
        }
    }
}

