package org.etsi.mts.tdl.execution.java.rt.core;

import java.util.Hashtable;
import java.util.Map;

import org.etsi.mts.tdl.execution.java.tri.Mapping;

public class MappingImpl extends ElementImpl implements Mapping, TriImpl<MappingImpl, MappingImpl> {
	private String mappingName;

	private boolean resource;
	private boolean parameter;
	private String uri;

	private MappingImpl container;
	private Map<String, MappingImpl> parameters = new Hashtable<String, MappingImpl>();

	public MappingImpl() {
	}

	public MappingImpl(String mappingName, String uri) {
		this.mappingName = mappingName;
		this.uri = uri;
	}

	@Override
	public String getUri() {
		return uri;
	}

	@Override
	public String getMappingName() {
		return mappingName;
	}

	public MappingImpl setIsResource(boolean resource) {
		this.resource = resource;
		return this;
	}

	public MappingImpl setIsParameter(boolean parameter) {
		this.parameter = parameter;
		return this;
	}

	@Override
	public boolean isResource() {
		return resource;
	}

	@Override
	public boolean isParameter() {
		return parameter;
	}

	public MappingImpl setResource(MappingImpl container) {
		this.container = container;
		return this;
	}

	@Override
	public MappingImpl getResource() {
		return container;
	}

	@Override
	public MappingImpl setParameter(String name, MappingImpl mapping) {
		this.parameters.put(name, mapping);
		return this;
	}

	@Override
	public MappingImpl getParameter(String name) {
		return this.parameters.get(name);
	}

	@Override
	public MappingImpl setName(String name, String qualifiedName) {
		this.name = name;
		return this;
	}
	
	@Override
	public MappingImpl addAnnotation(String key, String value) {
		super.addAnnotation(key, value);
		return this;
	}

}
