/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.ComplexFieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.fields.merge.DataFieldName;
import org.docx4j.model.fields.merge.MailMerger;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Body;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMergerWithNext
extends MailMerger {
    private static Logger log = LoggerFactory.getLogger(MailMergerWithNext.class);

    public static void performLabelMerge(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data) throws Docx4JException {
        MailMerger.FormTextFieldNames formTextFieldNames = new MailMerger.FormTextFieldNames();
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        List<Object> mdpResults = MailMergerWithNext.perform(input, input.getMainDocumentPart().getContent(), data, formTextFieldNames);
        input.getMainDocumentPart().getContent().clear();
        input.getMainDocumentPart().getContent().addAll(mdpResults);
    }

    private static List<Object> perform(WordprocessingMLPackage input, List<Object> contentList, List<Map<DataFieldName, String>> data, MailMerger.FormTextFieldNames formTextFieldNames) throws Docx4JException {
        Body shell = Context.getWmlObjectFactory().createBody();
        shell.getContent().addAll(contentList);
        Body shellClone = XmlUtils.deepCopy(shell);
        ComplexFieldLocator fl = new ComplexFieldLocator();
        new TraversalUtil(shellClone, fl);
        log.info("Found " + fl.getStarts().size() + " fields ");
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        MailMergerWithNext.canonicaliseStarts(fl, fieldRefs);
        int datamapIndex = 0;
        Map<DataFieldName, String> datamap = data.get(datamapIndex);
        for (FieldRef fr : fieldRefs) {
            if (fr.getFldName().equals("MERGEFIELD")) {
                String instr = MailMergerWithNext.extractInstr(fr.getInstructions());
                String datafieldName = MailMergerWithNext.getDatafieldNameFromInstr(instr);
                String val = datamap.get(new DataFieldName(datafieldName));
                String gFormat = null;
                if (val == null || val.length() == 0) {
                    if (fieldFate.equals((Object)MailMerger.OutputField.REMOVED)) {
                        MailMergerWithNext.removeSimpleField(fr);
                        String text = MailMergerWithNext.getTextInsideContent(fr.getParent());
                        if (StringUtils.isBlank((String)text) && data.size() > datamapIndex) {
                            MailMergerWithNext.recursiveRemove(shellClone, fr.getParent());
                        }
                    }
                } else {
                    FldSimpleModel fsm = new FldSimpleModel();
                    try {
                        fsm.build(instr);
                        val = FormattingSwitchHelper.applyFormattingSwitch(input, fsm, val);
                        gFormat = FormattingSwitchHelper.findFirstSwitchValue("\\*", fsm.getFldParameters(), true);
                    }
                    catch (TransformerException e) {
                        log.warn("Can't format the field", (Throwable)e);
                    }
                    fr.setResult(val);
                }
                if (fieldFate.equals((Object)MailMerger.OutputField.AS_FORMTEXT_REGULAR)) {
                    log.debug(gFormat);
                    List<Object> instructions = fr.getInstructions();
                    if (instructions.size() != 1) {
                        log.error("TODO MERGEFIELD field contained complex instruction");
                        continue;
                    }
                    Object o = XmlUtils.unwrap(instructions.get(0));
                    if (!(o instanceof Text)) {
                        log.error("TODO: set FORMTEXT in" + o.getClass().getName());
                        log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
                        continue;
                    }
                    ((Text)o).setValue("FORMTEXT");
                    String fieldName = formTextFieldNames.generateName(datafieldName);
                    log.debug("Field name normalisation: " + datafieldName + " -> " + fieldName);
                    MailMergerWithNext.setFormFieldProperties(fr, fieldName, null);
                    R resultR = fr.getResultsSlot();
                    if (resultR.getRPr() == null || resultR.getRPr().getHighlight() == null) continue;
                    resultR.getRPr().setHighlight(null);
                    continue;
                }
                if (fieldFate.equals((Object)MailMerger.OutputField.KEEP_MERGEFIELD)) continue;
                fr.getParent().getContent().remove(fr.getBeginRun());
                fr.getParent().getContent().remove(fr.getEndRun());
                continue;
            }
            if (!fr.getFldName().equals("NEXT")) continue;
            MailMergerWithNext.removeSimpleField(fr);
            if (++datamapIndex >= data.size()) {
                datamap = new HashMap<DataFieldName, String>();
                continue;
            }
            datamap = data.get(datamapIndex);
        }
        return shellClone.getContent();
    }
}

