/**
 */
package org.etsi.mts.tdl.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.IdResolver.IdResolverExtension;
import org.eclipse.ocl.pivot.library.collection.CollectionAsOrderedSetOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsSetOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.ComponentInstanceRole;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.Interaction;
import org.etsi.mts.tdl.Target;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.tdlTables;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Behaviour</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.etsi.mts.tdl.impl.BehaviourImpl#getTestObjective <em>Test Objective</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class BehaviourImpl extends ElementImpl implements Behaviour
{
	/**
	 * The cached value of the '{@link #getTestObjective() <em>Test Objective</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestObjective()
	 * @generated
	 * @ordered
	 */
	protected EList<TestObjective> testObjective;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BehaviourImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return tdlPackage.Literals.BEHAVIOUR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TestObjective> getTestObjective()
	{
		if (testObjective == null) {
			testObjective = new EObjectResolvingEList<TestObjective>(TestObjective.class, this, tdlPackage.BEHAVIOUR__TEST_OBJECTIVE);
		}
		return testObjective;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Boolean isTesterInputEvent()
	{
		/**
		 *
		 * if
		 *   self.oclIsKindOf(TimeOut) or
		 *   self.oclIsKindOf(Quiescence) or
		 *   self.oclIsKindOf(Interaction) and
		 *   self.oclAsType(Interaction).sourceGate.component.role = ComponentInstanceRole::SUT and
		 *   self.oclAsType(Interaction)
		 *   .target->exists(t | t.targetGate.component.role = ComponentInstanceRole::Tester)
		 * then true
		 * else false
		 * endif
		 */
		final /*@NonInvalid*/ Executor executor = PivotUtil.getExecutor(this);
		final /*@NonInvalid*/ IdResolver idResolver = executor.getIdResolver();
		final /*@NonInvalid*/ org.eclipse.ocl.pivot.Class TYP_tdl_c_c_Quiescence_0 = idResolver.getClass(tdlTables.CLSSid_Quiescence, null);
		final /*@NonInvalid*/ org.eclipse.ocl.pivot.Class TYP_tdl_c_c_TimeOut_0 = idResolver.getClass(tdlTables.CLSSid_TimeOut, null);
		final /*@NonInvalid*/ boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, this, TYP_tdl_c_c_TimeOut_0).booleanValue();
		final /*@NonInvalid*/ Boolean or;
		if (oclIsKindOf) {
			or = ValueUtil.TRUE_VALUE;
		}
		else {
			final /*@NonInvalid*/ boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, this, TYP_tdl_c_c_Quiescence_0).booleanValue();
			if (oclIsKindOf_0) {
				or = ValueUtil.TRUE_VALUE;
			}
			else {
				or = ValueUtil.FALSE_VALUE;
			}
		}
		final /*@Thrown*/ Boolean or_0;
		if (or == ValueUtil.TRUE_VALUE) {
			or_0 = ValueUtil.TRUE_VALUE;
		}
		else {
			/*@Caught*/ Object CAUGHT_and_0;
			try {
				/*@Caught*/ Object CAUGHT_and;
				try {
					final /*@NonInvalid*/ org.eclipse.ocl.pivot.Class TYP_tdl_c_c_Interaction_0 = idResolver.getClass(tdlTables.CLSSid_Interaction, null);
					final /*@NonInvalid*/ boolean oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, this, TYP_tdl_c_c_Interaction_0).booleanValue();
					final /*@Thrown*/ Boolean and;
					if (!oclIsKindOf_1) {
						and = ValueUtil.FALSE_VALUE;
					}
					else {
						/*@Caught*/ Object CAUGHT_eq;
						try {
							final /*@Thrown*/ Interaction oclAsType = (Interaction)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, this, TYP_tdl_c_c_Interaction_0);
							final /*@Thrown*/ GateReference sourceGate = oclAsType.getSourceGate();
							final /*@Thrown*/ ComponentInstance component = sourceGate.getComponent();
							final /*@Thrown*/ ComponentInstanceRole role = component.getRole();
							final /*@Thrown*/ EnumerationLiteralId BOXED_role = tdlTables.ENUMid_ComponentInstanceRole.getEnumerationLiteralId(ClassUtil.nonNullState(role.getName()));
							final /*@Thrown*/ boolean eq = BOXED_role == tdlTables.ELITid_SUT;
							CAUGHT_eq = eq;
						}
						catch (Exception e) {
							CAUGHT_eq = ValueUtil.createInvalidValue(e);
						}
						if (CAUGHT_eq == ValueUtil.FALSE_VALUE) {
							and = ValueUtil.FALSE_VALUE;
						}
						else {
							if (CAUGHT_eq instanceof InvalidValueException) {
								throw (InvalidValueException)CAUGHT_eq;
							}
							and = ValueUtil.TRUE_VALUE;
						}
					}
					CAUGHT_and = and;
				}
				catch (Exception e) {
					CAUGHT_and = ValueUtil.createInvalidValue(e);
				}
				final /*@Thrown*/ Boolean and_0;
				if (CAUGHT_and == ValueUtil.FALSE_VALUE) {
					and_0 = ValueUtil.FALSE_VALUE;
				}
				else {
					/*@Caught*/ Object CAUGHT_exists;
					try {
						final /*@NonInvalid*/ org.eclipse.ocl.pivot.Class TYP_tdl_c_c_Interaction_2 = idResolver.getClass(tdlTables.CLSSid_Interaction, null);
						final /*@Thrown*/ Interaction oclAsType_0 = (Interaction)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, this, TYP_tdl_c_c_Interaction_2);
						final /*@Thrown*/ List<Target> target = oclAsType_0.getTarget();
						final /*@Thrown*/ SetValue BOXED_target = idResolver.createSetOfAll(tdlTables.SET_CLSSid_Target, target);
						/*@Thrown*/ Object accumulator = ValueUtil.FALSE_VALUE;
						Iterator<Object> ITERATOR_t = BOXED_target.iterator();
						/*@Thrown*/ Boolean exists;
						while (true) {
							if (!ITERATOR_t.hasNext()) {
								if (accumulator == ValueUtil.FALSE_VALUE) {
									exists = ValueUtil.FALSE_VALUE;
								}
								else {
									throw (InvalidValueException)accumulator;
								}
								break;
							}
							/*@NonInvalid*/ Target t = (Target)ITERATOR_t.next();
							/**
							 * t.targetGate.component.role = ComponentInstanceRole::Tester
							 */
							final /*@NonInvalid*/ GateReference targetGate = t.getTargetGate();
							final /*@NonInvalid*/ ComponentInstance component_0 = targetGate.getComponent();
							final /*@NonInvalid*/ ComponentInstanceRole role_0 = component_0.getRole();
							final /*@NonInvalid*/ EnumerationLiteralId BOXED_role_0 = tdlTables.ENUMid_ComponentInstanceRole.getEnumerationLiteralId(ClassUtil.nonNullState(role_0.getName()));
							final /*@NonInvalid*/ boolean eq_0 = BOXED_role_0 == tdlTables.ELITid_Tester;
							//
							if (eq_0) {					// Normal successful body evaluation result
								exists = ValueUtil.TRUE_VALUE;
								break;														// Stop immediately
							}
							else if (!eq_0) {				// Normal unsuccessful body evaluation result
								;															// Carry on
							}
							else {															// Impossible badly typed result
								accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "exists");
							}
						}
						CAUGHT_exists = exists;
					}
					catch (Exception e) {
						CAUGHT_exists = ValueUtil.createInvalidValue(e);
					}
					if (CAUGHT_exists == ValueUtil.FALSE_VALUE) {
						and_0 = ValueUtil.FALSE_VALUE;
					}
					else {
						if (CAUGHT_and instanceof InvalidValueException) {
							throw (InvalidValueException)CAUGHT_and;
						}
						if (CAUGHT_exists instanceof InvalidValueException) {
							throw (InvalidValueException)CAUGHT_exists;
						}
						if ((CAUGHT_and == null) || (CAUGHT_exists == null)) {
							and_0 = null;
						}
						else {
							and_0 = ValueUtil.TRUE_VALUE;
						}
					}
				}
				CAUGHT_and_0 = and_0;
			}
			catch (Exception e) {
				CAUGHT_and_0 = ValueUtil.createInvalidValue(e);
			}
			if (CAUGHT_and_0 == ValueUtil.TRUE_VALUE) {
				or_0 = ValueUtil.TRUE_VALUE;
			}
			else {
				if (CAUGHT_and_0 instanceof InvalidValueException) {
					throw (InvalidValueException)CAUGHT_and_0;
				}
				if ((or == null) || (CAUGHT_and_0 == null)) {
					or_0 = null;
				}
				else {
					or_0 = ValueUtil.FALSE_VALUE;
				}
			}
		}
		if (or_0 == null) {
			throw new InvalidValueException("Null if condition");
		}
		/*@NonInvalid*/ boolean local_0;
		if (or_0) {
			local_0 = true;
		}
		else {
			local_0 = false;
		}
		return local_0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<ComponentInstance> getParticipatingComponents()
	{
		/**
		 *
		 * if
		 *   self.getParentTestDescription()
		 *   ->exists(td | td.isLocallyOrdered)
		 * then OrderedSet{}
		 * else
		 *   self.getParentTestDescription()
		 *   .testConfiguration.componentInstance->asOrderedSet()
		 * endif
		 */
		final /*@NonInvalid*/ Executor executor = PivotUtil.getExecutor(this);
		final /*@NonInvalid*/ IdResolver idResolver = executor.getIdResolver();
		final /*@NonInvalid*/ TestDescription getParentTestDescription = this.getParentTestDescription();
		final /*@NonInvalid*/ SetValue oclAsSet = OclAnyOclAsSetOperation.INSTANCE.evaluate(executor, tdlTables.SET_CLSSid_TestDescription, getParentTestDescription);
		/*@Thrown*/ Object accumulator = ValueUtil.FALSE_VALUE;
		Iterator<Object> ITERATOR_td = oclAsSet.iterator();
		/*@NonInvalid*/ Boolean exists;
		while (true) {
			if (!ITERATOR_td.hasNext()) {
				if (accumulator == ValueUtil.FALSE_VALUE) {
					exists = ValueUtil.FALSE_VALUE;
				}
				else {
					throw (InvalidValueException)accumulator;
				}
				break;
			}
			/*@NonInvalid*/ TestDescription td = (TestDescription)ITERATOR_td.next();
			/**
			 * td.isLocallyOrdered
			 */
			final /*@NonInvalid*/ boolean isLocallyOrdered = td.isIsLocallyOrdered();
			//
			if (isLocallyOrdered) {					// Normal successful body evaluation result
				exists = ValueUtil.TRUE_VALUE;
				break;														// Stop immediately
			}
			else if (!isLocallyOrdered) {				// Normal unsuccessful body evaluation result
				;															// Carry on
			}
			else {															// Impossible badly typed result
				accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "exists");
			}
		}
		if (exists == null) {
			throw new InvalidValueException("Null if condition");
		}
		/*@NonInvalid*/ OrderedSetValue local_0;
		if (exists) {
			local_0 = tdlTables.OrderedSet;
		}
		else {
			final /*@NonInvalid*/ TestConfiguration testConfiguration = getParentTestDescription.getTestConfiguration();
			final /*@NonInvalid*/ List<ComponentInstance> componentInstance = testConfiguration.getComponentInstance();
			final /*@NonInvalid*/ SetValue BOXED_componentInstance = idResolver.createSetOfAll(tdlTables.SET_CLSSid_ComponentInstance, componentInstance);
			final /*@NonInvalid*/ OrderedSetValue asOrderedSet = CollectionAsOrderedSetOperation.INSTANCE.evaluate(BOXED_componentInstance);
			local_0 = asOrderedSet;
		}
		final /*@NonInvalid*/ List<ComponentInstance> ECORE_local_0 = ((IdResolverExtension)idResolver).ecoreValueOfAll(ComponentInstance.class, local_0);
		return (EList<ComponentInstance>)ECORE_local_0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID) {
			case tdlPackage.BEHAVIOUR__TEST_OBJECTIVE:
				return getTestObjective();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID) {
			case tdlPackage.BEHAVIOUR__TEST_OBJECTIVE:
				getTestObjective().clear();
				getTestObjective().addAll((Collection<? extends TestObjective>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID) {
			case tdlPackage.BEHAVIOUR__TEST_OBJECTIVE:
				getTestObjective().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID) {
			case tdlPackage.BEHAVIOUR__TEST_OBJECTIVE:
				return testObjective != null && !testObjective.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
	{
		switch (operationID) {
			case tdlPackage.BEHAVIOUR___IS_TESTER_INPUT_EVENT:
				return isTesterInputEvent();
			case tdlPackage.BEHAVIOUR___GET_PARTICIPATING_COMPONENTS:
				return getParticipatingComponents();
		}
		return super.eInvoke(operationID, arguments);
	}

} //BehaviourImpl
