/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.poibrowser;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.poi.poifs.poibrowser.Util;

public class ExtendableTreeCellRenderer
implements TreeCellRenderer {
    protected Map<Class<?>, TreeCellRenderer> renderers = new HashMap();

    public ExtendableTreeCellRenderer() {
        this.register(Object.class, new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selectedCell, boolean expanded, boolean leaf, int row, boolean hasCellFocus) {
                String s = value.toString();
                JLabel l = new JLabel(s + "  ");
                if (this.selected) {
                    Util.invert(l);
                    l.setOpaque(true);
                }
                return l;
            }
        });
    }

    public void register(Class<?> c, TreeCellRenderer renderer) {
        this.renderers.put(c, renderer);
    }

    public void unregister(Class<?> c) {
        if (c == Object.class) {
            throw new IllegalArgumentException("Renderer for Object cannot be unregistered.");
        }
        this.renderers.put(c, null);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObject;
        String NULL = "null";
        if (value == null) {
            userObject = "null";
        } else {
            userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject == null) {
                userObject = "null";
            }
        }
        TreeCellRenderer r = this.findRenderer(userObject.getClass());
        return r.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected TreeCellRenderer findRenderer(Class<?> c) {
        TreeCellRenderer r = this.renderers.get(c);
        if (r != null) {
            return r;
        }
        Class<?> superclass = c.getSuperclass();
        if (superclass != null) {
            return this.findRenderer(superclass);
        }
        return null;
    }
}

