/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.eventusermodel.examples;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FromHowTo {
    public void processFirstSheet(String filename) throws Exception {
        try (OPCPackage pkg = OPCPackage.open((String)filename, (PackageAccess)PackageAccess.READ);){
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            try (InputStream sheet = (InputStream)r.getSheetsData().next();){
                InputSource sheetSource = new InputSource(sheet);
                parser.parse(sheetSource);
            }
        }
    }

    public void processAllSheets(String filename) throws Exception {
        try (OPCPackage pkg = OPCPackage.open((String)filename, (PackageAccess)PackageAccess.READ);){
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            Iterator sheets = r.getSheetsData();
            while (sheets.hasNext()) {
                System.out.println("Processing new sheet:\n");
                try (InputStream sheet = (InputStream)sheets.next();){
                    InputSource sheetSource = new InputSource(sheet);
                    parser.parse(sheetSource);
                }
                System.out.println("");
            }
        }
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException, ParserConfigurationException {
        XMLReader parser = SAXHelper.newXMLReader();
        SheetHandler handler = new SheetHandler(sst);
        parser.setContentHandler(handler);
        return parser;
    }

    public static void main(String[] args) throws Exception {
        FromHowTo howto = new FromHowTo();
        howto.processFirstSheet(args[0]);
        howto.processAllSheets(args[0]);
    }

    private static class SheetHandler
    extends DefaultHandler {
        private final SharedStringsTable sst;
        private String lastContents;
        private boolean nextIsString;
        private boolean inlineStr;
        private final LruCache<Integer, String> lruCache = new LruCache(50);

        private SheetHandler(SharedStringsTable sst) {
            this.sst = sst;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                System.out.print(attributes.getValue("r") + " - ");
                String cellType = attributes.getValue("t");
                this.nextIsString = cellType != null && cellType.equals("s");
                this.inlineStr = cellType != null && cellType.equals("inlineStr");
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.nextIsString) {
                Integer idx = Integer.valueOf(this.lastContents);
                this.lastContents = (String)this.lruCache.get(idx);
                if (this.lastContents == null && !this.lruCache.containsKey(idx)) {
                    this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx.intValue())).toString();
                    this.lruCache.put(idx, this.lastContents);
                }
                this.nextIsString = false;
            }
            if (name.equals("v") || this.inlineStr && name.equals("c")) {
                System.out.println(this.lastContents);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.lastContents = this.lastContents + new String(ch, start, length);
        }

        private static class LruCache<A, B>
        extends LinkedHashMap<A, B> {
            private final int maxEntries;

            public LruCache(int maxEntries) {
                super(maxEntries + 1, 1.0f, true);
                this.maxEntries = maxEntries;
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<A, B> eldest) {
                return super.size() > this.maxEntries;
            }
        }
    }
}

