package org.etsi.mts.tdl.importers.ui.handlers;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.asn2tdl.ASN2TDLTranslator;
import org.etsi.mts.tdl.json2tdl.JSON2TDLTranslator;
import org.etsi.mts.tdl.openapi2tdl.next.OpenAPI2TDLTranslatorNext;
import org.etsi.mts.tdl.openapi2tdl.next.doc.Doc;
import org.etsi.mts.tdl.to2tdl.TO2TDLTranslator;
import org.etsi.mts.tdl.transform.AbstractTranslator;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;

/**
 * Our sample handler extends AbstractHandler, an IHandler base class.
 * @see org.eclipse.core.commands.IHandler
 * @see org.eclipse.core.commands.AbstractHandler
 */
public class DocumentationHandler extends AbstractHandler {
	private IWorkbenchWindow window;

	public DocumentationHandler() {
		init();
	}

	private void init() {
	}

	private void loadTargetFormat(String bundleName, String label, String extension) {
	}

	/**
	 * the command has been executed, so extract extract the needed information
	 * from the application context.
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		init();
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		IEditorInput input = HandlerUtil.getActiveEditorInput(event);
		IFile file = null;
		if (input != null && input instanceof FileEditorInput && ((FileEditorInput) input).getFile().getName().endsWith("yaml")) {
			file = ((FileEditorInput) input).getFile();
		} else if (selection !=null && selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			Object firstElement = structuredSelection.getFirstElement();
			if (firstElement instanceof IFile) {
				file = (IFile) firstElement;
			}
		}
		
		if (file !=null) {
			String filepath = file.getLocation().toFile().getAbsolutePath();
			Doc doc = new Doc();
			try {
				//TODO: make configurable
				doc.processModel(filepath, true);
				Files.writeString(Path.of(filepath+"-RQ-ICS-TSS.md"), doc.getContent());
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				showErrorDialog(e);
			}
		}
		//TODO: throw proper execution exceptions?
		return null;
	}

	private void showErrorDialog(Exception e) {
		MessageDialog errorDialog = new MessageDialog(
				Display.getDefault().getActiveShell(), 
				"Translation error...", 
				null, 
				"An error occurred during the documentation generation. "
				+ "It may be due to problems occurring while processing the input, "
				+ "e.g if the input could not be processed. "
				+ "See details for a more technical description:\n\n"
				+ e.getMessage()
				,		
				MessageDialog.ERROR, 
				0, 
				new String[] {"OK"});
		errorDialog.open();
	}
	
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	@Override
	public boolean isEnabled() {
		return true;
	}

}
