package org.etsi.mts.tdl.execution.java.tri;

/**
 * Representation of a TDL model element of class <i>DataResourceMapping</i>,
 * <i>DataElementMapping</i> or <i>ParameterMapping</i>.
 */
public interface Mapping extends Element {
	/**
	 * Get the name applied to the associated <i>DataResourceMapping</i> element
	 * using the predefined <i>MappingName</i> annotation.
	 * 
	 * @return A distinctive name for this mapping.
	 */
	String getMappingName();

	/**
	 * If this is a resource mapping.
	 * 
	 * @return <b>true</b> if this type represents a <i>DataResourceMapping</i>
	 *         element.
	 */
	boolean isResource();

	/**
	 * If this is a parameter mapping.
	 * 
	 * @return <b>true</b> if this type represents a <i>ParameterMapping</i>
	 *         element.
	 */
	boolean isParameter();

	/**
	 * Get the type-sepcific URI for this mapping.
	 * 
	 * @return The URI of this mapping as specified in corresponding model element.
	 */
	String getUri();

	/**
	 * Get the resource mapping for this data mapping.
	 * 
	 * @return The <code>Mapping</code> representing the <i>DataResourceMapping</i>
	 *         element referenced by the associated <i>DataElementMapping</i>
	 *         element.
	 */
	Mapping getResource();

	/**
	 * Get the parameter mappings of this data mapping.
	 * 
	 * @param parameterName Name of the parameter as returned by
	 *                      {@link Type#getParameters() Type.getParameters()} or
	 *                      {@link Value#getParameters() Value.getParameters()}.
	 * @return A <code>Mapping</code> representing a <i>ParameterMapping</i>
	 *         element.
	 */
	Mapping getParameterMapping(String parameterName);

}
