/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractSymbolWriter;
import org.docx4j.convert.out.html.BrWriter;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolWriter
extends AbstractSymbolWriter {
    private static final Logger log = LoggerFactory.getLogger(BrWriter.class);

    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node modelContent, Writer.TransformState state, Document doc) throws TransformerException {
        R.Sym modelData = (R.Sym)unmarshalledNode;
        String value = modelData.getChar();
        if (value.startsWith("F0") || value.startsWith("f0")) {
            value = value.substring(2);
        }
        Text theChar = doc.createTextNode(new String(this.hexStringToByteArray(value)));
        DocumentFragment docfrag = doc.createDocumentFragment();
        String fontName = modelData.getFont();
        PhysicalFont pf = context.getWmlPackage().getFontMapper().get(fontName);
        if (pf == null) {
            log.warn("No physical font present for:" + fontName);
            docfrag.appendChild(theChar);
        } else {
            Element span = doc.createElement("span");
            docfrag.appendChild(span);
            span.setAttribute("style", "font-family: '" + pf.getName() + "'");
            span.appendChild(theChar);
        }
        return docfrag;
    }

    protected byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

