package org.etsi.mts.tdl;

import java.net.URISyntaxException;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.etsi.mts.tdl.extendedconfigurations.ExtendedConfigurationsPackage;
import org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator implements BundleActivator {

	@Override
	public void start(BundleContext context) throws Exception {

		// TODO disabled for now
//		registerValidator("model/tdl-structured-constraints.ocl", StructuredObjectivesPackage.eINSTANCE, context);
//		registerValidator("model/tdl-configurations-constraints.ocl", ExtendedConfigurationsPackage.eINSTANCE, context);
//		registerValidator("model/tdl-constraints.ocl", tdlPackage.eINSTANCE, context);

	}

	void registerValidator(String path, EPackage ePakcage, BundleContext context) {

		Path oclPath = new Path(path);
		URL oclURL = FileLocator.find(context.getBundle(), oclPath);

		URI oclURI;
		try {
			oclURI = URI.createURI(oclURL.toURI().toString());
			CompleteOCLEObjectValidator validator = new CompleteOCLEObjectValidator(ePakcage, oclURI);
			EValidator.Registry.INSTANCE.put(tdlPackage.eINSTANCE, validator);
		} catch (URISyntaxException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void stop(BundleContext context) throws Exception {
		EValidator.Registry.INSTANCE.remove(StructuredObjectivesPackage.eINSTANCE);
		EValidator.Registry.INSTANCE.remove(ExtendedConfigurationsPackage.eINSTANCE);
		EValidator.Registry.INSTANCE.remove(tdlPackage.eINSTANCE);
	}

}
