package org.etsi.mts.tdl.document.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Content implements Serializable {
	private static final long serialVersionUID = 5798123716729347047L;
	Content parent;
	List<Content> content = new ArrayList<>();
	List<Attribute> attributes = new ArrayList<>();
	List<Note> notes = new ArrayList<>();
	String text;
	public Content() {
		
	}
	
	public Content(Content p, String text) {
		this(p, text, true);
	}
	public Content(Content p, String text, boolean index) {
		this.setParent(p);
		this.setText(text);
		getDocument().index(this);
	}
	
	public Content getParent() {
		return parent;
	}
	public void setParent(Content parent) {
		this.parent = parent;
		this.parent.getContent().add(this);
	}
	public List<Content> getContent() {
		return content;
	}
	public void setContent(List<Content> content) {
		this.content = content;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public Document getDocument() {
		if (getParent()!=null) {
			return getParent().getDocument();
		} else if (this instanceof Document) {
			return (Document)this;
		}
		return null;
	}
	public String getContentText() {
		String output = getText();
		for (Content c:getContent()) {
			output+="\n"+c.getContentText();
		}
		return output;
	}

	@Override
	public String toString() {
		return "Content: " + text + "";
	}

	public List<Attribute> getAttributes() {
		return attributes;
	}

	public void setAttributes(List<Attribute> attributes) {
		this.attributes = attributes;
	}

	public List<Note> getNotes() {
		return notes;
	}

	public void setNotes(List<Note> notes) {
		this.notes = notes;
	}
	
	
}
