package org.etsi.mts.tdl.openapi2tdl.next.doc;

import org.openapitools.codegen.utils.ModelUtils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;

public class Describe extends OpenAPIVisitor  {

	@Override
	public void preamble(OpenAPI model) {
		System.out.printf("Title: %s\n", model.getInfo().getTitle());
	}

	@Override
	public void path(String path) {
		System.out.printf("Path %s:\n", path);
	}

	@Override
	public void operation(String path, String method, Operation op) {
		System.out.printf("  %s: [%s] %s\n", method,
				op.getOperationId(), op.getSummary());
		if (op.getParameters() != null) {
			for (Parameter param : op.getParameters()) {
				if (param.get$ref() != null) {
					param = ModelUtils.getReferencedParameter(model, param);
				}
				System.out.printf("    %s[%s]:, %s - %s\n", param.getName(), param.getIn(), getParameterType(param),
						param.getDescription());
			}
		}
		if (op.getResponses() != null) {
			for (String r : op.getResponses().keySet()) {
				ApiResponse response = op.getResponses().get(r);
				if (response.get$ref() != null) {
					response = ModelUtils.getReferencedApiResponse(model, response);
				}
				System.out.printf("    %s: %s\n", r, response.getDescription());
				if (response.getContent() != null) {
					for (String c : response.getContent().keySet()) {
						Schema<?> schema = response.getContent().get(c).getSchema();
						if (schema.get$ref() != null) {
							String schemaName = ModelUtils.getSimpleRef(schema.get$ref());
							System.out.printf("      %s\n",schemaName);
//							schema = ModelUtils.getReferencedSchema(model, op.getResponses().get(r).getContent().get(c).getSchema());
						}
//						System.out.printf("      %s\n",op.getResponses().get(r).getContent().get(c).getSchema().getName());
					}
				}
			}
		}
	}
	
}
