/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.bibliography.CTSources;
import org.docx4j.docProps.coverPageProps.CoverPageProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.PackageRelsUtil;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.io.ExternalResourceUtils;
import org.docx4j.openpackaging.io.Load;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DefaultXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCoverPagePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.digitalsignature.XmlSignaturePart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.opendope.answers.Answers;
import org.opendope.components.Components;
import org.opendope.conditions.Conditions;
import org.opendope.questions.Questionnaire;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LoadFromZipNG
extends Load {
    private static Logger log = LoggerFactory.getLogger(LoadFromZipNG.class);

    public static void main(String[] args) throws Exception {
        String filepath = System.getProperty("user.dir") + "/sample-docs/FontEmbedded.docx";
        log.info("Path: " + filepath);
        LoadFromZipNG loader = new LoadFromZipNG();
        loader.get(filepath);
    }

    public OpcPackage get(String filepath) throws Docx4JException {
        return this.get(new File(filepath));
    }

    public static byte[] getBytesFromInputStream(InputStream is) throws Exception {
        BufferedInputStream bufIn = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        int c = bufIn.read();
        while (c != -1) {
            bos.write(c);
            c = bufIn.read();
        }
        bos.flush();
        baos.flush();
        bos.close();
        return baos.toByteArray();
    }

    public OpcPackage get(File f) throws Docx4JException {
        log.info("Filepath = " + f.getPath());
        ZipFile zf = null;
        try {
            if (!f.exists()) {
                log.info("Couldn't find " + f.getPath());
            }
            zf = new ZipFile(f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Docx4JException("Couldn't get ZipFile", ioe);
        }
        HashMap<String, ByteArray> partByteArrays = new HashMap<String, ByteArray>();
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            log.info("\n\n" + entry.getName() + "\n");
            Object in = null;
            try {
                byte[] bytes = LoadFromZipNG.getBytesFromInputStream(zf.getInputStream(entry));
                partByteArrays.put(entry.getName(), new ByteArray(bytes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            zf.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return this.process(partByteArrays);
    }

    public OpcPackage get(InputStream is) throws Docx4JException {
        HashMap<String, ByteArray> partByteArrays = new HashMap<String, ByteArray>();
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                byte[] bytes = LoadFromZipNG.getBytesFromInputStream(zis);
                partByteArrays.put(entry.getName(), new ByteArray(bytes));
            }
            zis.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new Docx4JException("Error processing zip file (is it a zip file?)", e);
        }
        return this.process(partByteArrays);
    }

    private OpcPackage process(HashMap<String, ByteArray> partByteArrays) throws Docx4JException {
        long startTime = System.currentTimeMillis();
        ContentTypeManager ctm = new ContentTypeManager();
        try {
            InputStream is = LoadFromZipNG.getInputStreamFromZippedPart(partByteArrays, "[Content_Types].xml");
            ctm.parseContentTypesFile(is);
        }
        catch (IOException e) {
            throw new Docx4JException("Couldn't get [Content_Types].xml from ZipFile", e);
        }
        catch (NullPointerException e) {
            throw new Docx4JException("Couldn't get [Content_Types].xml from ZipFile", e);
        }
        RelationshipsPart rp = RelationshipsPart.createPackageRels();
        this.populatePackageRels(partByteArrays, rp);
        String mainPartName = PackageRelsUtil.getNameOfMainPart(rp);
        String pkgContentType = ctm.getContentType(new PartName("/" + mainPartName));
        OpcPackage p = ctm.createPackage(pkgContentType);
        log.info("Instantiated package of type " + p.getClass().getName());
        p.setRelationships(rp);
        rp.setSourceP(p);
        this.addPartsFromRelationships(partByteArrays, p, rp, ctm);
        LoadFromZipNG.registerCustomXmlDataStorageParts(p);
        long endTime = System.currentTimeMillis();
        log.info("package read;  elapsed time: " + Math.round(endTime - startTime) + " ms");
        return p;
    }

    private void populatePackageRels(HashMap<String, ByteArray> partByteArrays, RelationshipsPart rp) throws Docx4JException {
        InputStream is = null;
        try {
            is = LoadFromZipNG.getInputStreamFromZippedPart(partByteArrays, "_rels/.rels");
            if (is == null) {
                throw new Docx4JException("_rels/.rels appears to be missing from this package!");
            }
            rp.unmarshal(is);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Docx4JException("Error getting document from Zipped Part: _rels/.rels ", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private RelationshipsPart getRelationshipsPartFromZip(Base p, HashMap<String, ByteArray> partByteArrays, String partName) throws Docx4JException {
        RelationshipsPart rp = null;
        InputStream is = null;
        try {
            is = LoadFromZipNG.getInputStreamFromZippedPart(partByteArrays, partName);
            rp = p.getRelationshipsPart(true);
            rp.unmarshal(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Docx4JException("Error getting document from Zipped Part:" + partName, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        }
        return rp;
    }

    private static InputStream getInputStreamFromZippedPart(HashMap<String, ByteArray> partByteArrays, String partName) throws IOException {
        ByteArray bytes = partByteArrays.get(partName);
        if (bytes == null) {
            throw new IOException("part '" + partName + "' not found");
        }
        return bytes.getInputStream();
    }

    private void addPartsFromRelationships(HashMap<String, ByteArray> partByteArrays, Base source, RelationshipsPart rp, ContentTypeManager ctm) throws Docx4JException {
        OpcPackage pkg = source.getPackage();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.debug("\n For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget() + ", type: " + r.getType());
            try {
                this.getPart(partByteArrays, pkg, rp, r, ctm);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
    }

    private void getPart(HashMap<String, ByteArray> partByteArrays, OpcPackage pkg, RelationshipsPart rp, Relationship r, ContentTypeManager ctm) throws Docx4JException, InvalidFormatException, URISyntaxException {
        Base source = null;
        String resolvedPartUri = null;
        if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink")) {
            log.info("Encountered (but not loading) hyperlink " + r.getTarget());
            return;
        }
        if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
            if (this.loadExternalTargets && r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image")) {
                log.info("Loading external resource " + r.getTarget() + " of type " + r.getType());
                BinaryPart bp = ExternalResourceUtils.getExternalResource(r.getTarget());
                pkg.getExternalResources().put(bp.getExternalTarget(), bp);
            } else {
                log.info("Encountered (but not loading) external resource " + r.getTarget() + " of type " + r.getType());
            }
            return;
        }
        source = rp.getSourceP();
        resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
        resolvedPartUri = resolvedPartUri.substring(1);
        String relationshipType = r.getType();
        if (pkg.handled.get(resolvedPartUri) != null) {
            Part part = pkg.getParts().getParts().get(new PartName("/" + resolvedPartUri));
            if (source.setPartShortcut(part, relationshipType)) {
                log.debug("Convenience method established from " + source.getPartName() + " to " + part.getPartName());
            }
            part.getSourceRelationships().add(r);
            return;
        }
        Part part = LoadFromZipNG.getRawPart(partByteArrays, ctm, resolvedPartUri, r);
        if (source.setPartShortcut(part, relationshipType)) {
            log.debug("Convenience method established from " + source.getPartName() + " to " + part.getPartName());
        }
        if (part instanceof BinaryPart || part instanceof DefaultXmlPart) {
            part.setRelationshipType(relationshipType);
        }
        rp.loadPart(part, r);
        pkg.handled.put(resolvedPartUri, resolvedPartUri);
        RelationshipsPart rrp = this.getRelationshipsPart(partByteArrays, part);
        if (rrp != null) {
            this.addPartsFromRelationships(partByteArrays, part, rrp, ctm);
        }
    }

    public RelationshipsPart getRelationshipsPart(HashMap<String, ByteArray> partByteArrays, Part part) throws Docx4JException, InvalidFormatException {
        RelationshipsPart rrp = null;
        String relPart = PartName.getRelationshipsPartName(part.getPartName().getName().substring(1));
        if (partByteArrays.get(relPart) == null) {
            log.debug("No relationships " + relPart);
            return null;
        }
        log.debug("Found relationships " + relPart);
        rrp = this.getRelationshipsPartFromZip(part, partByteArrays, relPart);
        part.setRelationships(rrp);
        return rrp;
    }

    public static Part getRawPart(HashMap<String, ByteArray> partByteArrays, ContentTypeManager ctm, String resolvedPartUri, Relationship rel) throws Docx4JException {
        Part part;
        block32: {
            part = null;
            InputStream is = null;
            try {
                try {
                    log.debug("resolved uri: " + resolvedPartUri);
                    is = LoadFromZipNG.getInputStreamFromZippedPart(partByteArrays, resolvedPartUri);
                    part = ctm.getPart("/" + resolvedPartUri, rel);
                    log.info("ctm returned " + part.getClass().getName());
                    if (part instanceof ThemePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcThemePart);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof DocPropsCorePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsCore);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof DocPropsCustomPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsCustom);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof DocPropsExtendedPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsExtended);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof CustomXmlDataStoragePropertiesPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcCustomXmlProperties);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof XmlSignaturePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcXmlDSig);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof JaxbXmlPart) {
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block32;
                    }
                    if (part instanceof BinaryPart) {
                        log.debug("Detected BinaryPart " + part.getClass().getName());
                        ((BinaryPart)part).setBinaryData(is);
                        break block32;
                    }
                    if (part instanceof CustomXmlDataStoragePart) {
                        try {
                            Unmarshaller u = Context.jc.createUnmarshaller();
                            Object o = u.unmarshal(is);
                            log.debug(o.getClass().getName());
                            PartName name = part.getPartName();
                            if (o instanceof CoverPageProperties) {
                                part = new DocPropsCoverPagePart(name);
                                ((DocPropsCoverPagePart)part).setJaxbElement((CoverPageProperties)o);
                                break block32;
                            }
                            if (o instanceof Conditions) {
                                part = new ConditionsPart(name);
                                ((ConditionsPart)part).setJaxbElement((Conditions)o);
                                break block32;
                            }
                            if (o instanceof Xpaths) {
                                part = new XPathsPart(name);
                                ((XPathsPart)part).setJaxbElement((Xpaths)o);
                                break block32;
                            }
                            if (o instanceof Questionnaire) {
                                part = new QuestionsPart(name);
                                ((QuestionsPart)part).setJaxbElement((Questionnaire)o);
                                break block32;
                            }
                            if (o instanceof Answers) {
                                part = new StandardisedAnswersPart(name);
                                ((StandardisedAnswersPart)part).setJaxbElement((Answers)o);
                                break block32;
                            }
                            if (o instanceof Components) {
                                part = new ComponentsPart(name);
                                ((ComponentsPart)part).setJaxbElement((Components)o);
                                break block32;
                            }
                            if (o instanceof JAXBElement && XmlUtils.unwrap(o) instanceof CTSources) {
                                part = new BibliographyPart(name);
                                ((BibliographyPart)part).setJaxbElement((JAXBElement)o);
                                break block32;
                            }
                            log.error("TODO: handle known CustomXmlPart part  " + o.getClass().getName());
                            CustomXmlDataStorage data = LoadFromZipNG.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        catch (UnmarshalException ue) {
                            log.warn("No JAXB model for this CustomXmlDataStorage part; " + ue.getMessage());
                            CustomXmlDataStorage data = LoadFromZipNG.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        break block32;
                    }
                    if (part instanceof XmlPart) {
                        ((XmlPart)part).setDocument(is);
                        break block32;
                    }
                    log.error("No suitable part found for: " + resolvedPartUri);
                    part = null;
                }
                catch (PartUnrecognisedException e) {
                    log.error("PartUnrecognisedException shouldn't happen anymore!", (Throwable)e);
                    part = LoadFromZipNG.getBinaryPart(partByteArrays, ctm, resolvedPartUri);
                    log.warn("Using BinaryPart for " + resolvedPartUri);
                    ((BinaryPart)part).setBinaryData(is);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Docx4JException("Failed to getPart", ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }
        if (part == null) {
            throw new Docx4JException("cannot find part " + resolvedPartUri + " from rel " + rel.getId() + "=" + rel.getTarget());
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Part getBinaryPart(HashMap<String, ByteArray> partByteArrays, ContentTypeManager ctm, String resolvedPartUri) throws Docx4JException {
        BinaryPart part = null;
        InputStream in = null;
        try {
            in = partByteArrays.get(resolvedPartUri).getInputStream();
            part = new BinaryPart(new PartName("/" + resolvedPartUri));
            part.setContentType(new ContentType(ctm.getContentType(new PartName("/" + resolvedPartUri))));
            part.setBinaryData(in);
            log.info("Stored as BinaryData");
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        }
        return part;
    }

    public static class ByteArray
    implements Serializable {
        private static final long serialVersionUID = -784146312250361899L;
        private byte[] bytes;
        private String mimetype;

        public byte[] getBytes() {
            return this.bytes;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public ByteArray(ByteBuffer bb, String mimetype) {
            bb.clear();
            this.bytes = new byte[bb.capacity()];
            bb.get(this.bytes, 0, this.bytes.length);
            this.mimetype = mimetype;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public int getLength() {
            return this.bytes.length;
        }
    }
}

