/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.flatOpcXml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.io.FileUtils;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.Output;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.docx4j.xmlPackage.ObjectFactory;
import org.docx4j.xmlPackage.Package;
import org.docx4j.xmlPackage.XmlData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FlatOpcXmlCreator
implements Output {
    private static Logger log = LoggerFactory.getLogger(FlatOpcXmlCreator.class);
    public OpcPackage packageIn;
    private HashMap<String, String> handled = new HashMap();
    private static ObjectFactory factory = new ObjectFactory();
    private Package pkgResult;

    public FlatOpcXmlCreator(OpcPackage p) {
        this.packageIn = p;
    }

    public Package get() throws Docx4JException {
        try {
            this.pkgResult = factory.createPackage();
            RelationshipsPart rp = this.packageIn.getRelationshipsPart();
            this.saveRawXmlPart(rp);
            this.addPartsFromRelationships(rp);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof Docx4JException) {
                throw (Docx4JException)e;
            }
            throw new Docx4JException("Failed to save package", e);
        }
        log.info("...Done!");
        return this.pkgResult;
    }

    public void marshal(OutputStream os) throws Docx4JException {
        if (this.pkgResult == null) {
            if (this.packageIn == null) {
                throw new Docx4JException("No zipped package to convert to Flat OPC Package");
            }
            this.get();
        }
        try {
            JAXBContext jc = Context.jcXmlPackage;
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal((Object)this.pkgResult, os);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Couldn't marshall Flat OPC Package", (Exception)((Object)e));
        }
    }

    public void saveRawXmlPart(Part part) throws Docx4JException {
        org.docx4j.xmlPackage.Part partResult = FlatOpcXmlCreator.createRawXmlPart(part);
        this.pkgResult.getPart().add(partResult);
    }

    public static org.docx4j.xmlPackage.Part createRawXmlPart(Part part) throws Docx4JException {
        String partName = part.getPartName().getName();
        org.docx4j.xmlPackage.Part partResult = factory.createPart();
        if (partName.startsWith("/")) {
            partResult.setName(partName);
        } else {
            partResult.setName("/" + partName);
        }
        String ct = part.getContentType();
        if (ct == null) {
            log.error("Content type not set! ");
        } else {
            partResult.setContentType(ct);
        }
        XmlData dataResult = factory.createXmlData();
        partResult.setXmlData(dataResult);
        Document w3cDoc = null;
        if (part instanceof JaxbXmlPart) {
            try {
                w3cDoc = XmlUtils.getNewDocumentBuilder().newDocument();
                ((JaxbXmlPart)part).marshal(w3cDoc, NamespacePrefixMapperUtils.getPrefixMapper());
                dataResult.setAny(w3cDoc.getDocumentElement());
                log.info("PUT SUCCESS: " + partName);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Problem saving part " + partName, (Throwable)e);
                throw new Docx4JException("Problem saving part " + partName, e);
            }
        } else if (part instanceof CustomXmlDataStoragePart) {
            try {
                dataResult.setAny(((CustomXmlDataStoragePart)part).getData().getDocument().getDocumentElement());
                log.info("PUT SUCCESS: " + partName);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Problem saving part " + partName, (Throwable)e);
                throw new Docx4JException("Problem saving part " + partName, e);
            }
        } else if (part instanceof XmlPart) {
            Document doc = ((XmlPart)part).getDocument();
            dataResult.setAny(doc.getDocumentElement());
        } else {
            log.error("PROBLEM - No suitable part found for: " + partName);
        }
        return partResult;
    }

    public void addPartsFromRelationships(RelationshipsPart rp) throws Docx4JException {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.info("For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget());
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                log.warn("Encountered external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            try {
                String resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
                resolvedPartUri = resolvedPartUri.substring(1);
                log.info("Getting part /" + resolvedPartUri);
                Part part = this.packageIn.getParts().get(new PartName("/" + resolvedPartUri));
                if (part == null) {
                    log.error("Part " + resolvedPartUri + " not found!");
                } else {
                    log.info(part.getClass().getName());
                }
                this.savePart(part);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
    }

    public void savePart(Part part) throws Docx4JException, IOException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        if (this.handled.get(resolvedPartUri) != null) {
            log.debug(".. duplicate save avoided ..");
            return;
        }
        if (part instanceof BinaryPart) {
            log.info(".. saving binary stuff");
            this.saveRawBinaryPart(part);
        } else {
            log.info(".. saving ");
            this.saveRawXmlPart(part);
        }
        this.handled.put(resolvedPartUri, resolvedPartUri);
        if (part.getRelationshipsPart() != null && part.getRelationshipsPart().getJaxbElement() != null && ((Relationships)part.getRelationshipsPart().getJaxbElement()).getRelationship() != null && ((Relationships)part.getRelationshipsPart().getJaxbElement()).getRelationship().size() > 0) {
            RelationshipsPart rrp = part.getRelationshipsPart();
            log.info("Found relationships " + rrp.getPartName());
            String relPart = PartName.getRelationshipsPartName(resolvedPartUri);
            log.info("Cf constructed name " + relPart);
            this.saveRawXmlPart(rrp);
            this.addPartsFromRelationships(rrp);
        } else {
            log.info("No relationships for " + resolvedPartUri);
        }
    }

    protected void saveRawBinaryPart(Part part) throws Docx4JException {
        org.docx4j.xmlPackage.Part partResult = FlatOpcXmlCreator.createRawBinaryPart(part);
        this.pkgResult.getPart().add(partResult);
    }

    public static org.docx4j.xmlPackage.Part createRawBinaryPart(Part part) throws Docx4JException {
        String resolvedPartUri = part.getPartName().getName();
        org.docx4j.xmlPackage.Part partResult = factory.createPart();
        partResult.setName(resolvedPartUri);
        partResult.setContentType(part.getContentType());
        try {
            partResult.setCompression("store");
            partResult.setBinaryData(((BinaryPart)part).getBytes());
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
        log.info("PUT SUCCESS: " + resolvedPartUri);
        return partResult;
    }

    public static String wrapInXmlPart(String xml, String partName, String contentType) {
        return "<pkg:part pkg:name=\"" + partName + "\"" + " pkg:contentType=\"" + contentType + "\"" + " xmlns:pkg=\"http://schemas.microsoft.com/office/2006/xmlPackage\">" + "<pkg:xmlData>" + xml + "</pkg:xmlData>" + "</pkg:part>";
    }

    public static String wrapInBinaryPart(byte[] base64, String partName, String contentType) {
        try {
            return "<pkg:part pkg:name=\"" + partName + "\"" + " pkg:contentType=\"" + contentType + "\"" + " xmlns:pkg=\"http://schemas.microsoft.com/office/2006/xmlPackage\">" + "<pkg:binaryData>" + new String(base64, "UTF-8") + "</pkg:binaryData>" + "</pkg:part>";
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Document getFlatDomDocument(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        Document doc;
        FlatOpcXmlCreator worker = new FlatOpcXmlCreator(wordMLPackage);
        Package pkg = worker.get();
        try {
            JAXBContext jc = Context.jcXmlPackage;
            Marshaller marshaller = jc.createMarshaller();
            doc = XmlUtils.neww3cDomDocument();
            marshaller.marshal((Object)pkg, (Node)doc);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Couldn't marshal Flat OPC to DOM", (Exception)((Object)e));
        }
        return doc;
    }

    public void output(Result result) throws Docx4JException {
        TransformerFactory tfactory = XmlUtils.getTransformerFactory();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(FlatOpcXmlCreator.getFlatDomDocument((WordprocessingMLPackage)this.packageIn)), result);
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to create Flat OPC output", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/ole_tests/wmv_CT.pptx";
        OpcPackage wordMLPackage = OpcPackage.load(new File(inputfilepath));
        FlatOpcXmlCreator worker = new FlatOpcXmlCreator(wordMLPackage);
        Package result = worker.get();
        boolean suppressDeclaration = true;
        boolean prettyprint = true;
        String data = XmlUtils.marshaltoString(result, suppressDeclaration, prettyprint, Context.jcXmlPackage);
        FileUtils.writeStringToFile((File)new File(System.getProperty("user.dir") + "/ole_tests/wmv_CT.xml"), (String)data);
    }
}

