package org.etsi.mts.tdl.ui.wizard
import org.eclipse.xtext.ui.wizard.template.ProjectTemplate
import com.google.inject.Inject
import org.eclipse.xtext.ui.PluginImageHelper
import org.eclipse.core.runtime.Status
import static org.eclipse.core.runtime.IStatus.*
import org.eclipse.xtext.ui.wizard.template.IProjectGenerator
import org.eclipse.xtext.ui.util.PluginProjectFactory
import org.eclipse.jdt.core.JavaCore
import org.eclipse.xtext.ui.XtextProjectHelper
import org.etsi.mts.tdl.tx.ui.internal.TxActivator
import org.eclipse.swt.graphics.Image
import java.util.List
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.Path
import org.eclipse.ui.PlatformUI
import org.eclipse.ui.ide.IDE
import org.eclipse.swt.widgets.Display

//TODO: customise
@ProjectTemplate(label="TDLtx", icon="project_template.png", description="<p><b>TDLtx</b></p>
<p>This is a parameterized project for TDLtx. You can set a parameter to modify the content in the generated file
and a parameter to set the path the file is created in.</p><p><img href=\"project_template.png\"/></p>")
final class TDLtxProject {
    //TODO: remove after testing
	val advanced = check("Advanced:", false)
	val advancedGroup = group("Properties")
//	val name = combo("Package Name:", #["Example", "Sample", "Tutorial", "Pack"], "The name of the package", advancedGroup)
    val name = text("Main Package Name:", "Main", "The name of the main package")
	val path = text("Path:", "tdl", "The package path to place the files in", advancedGroup)
	//TODO: add other options
	val importStandard = check("Import TDL Library", true, "Import TDL standard library definitions.", advancedGroup)
	val importHTTP = check("Import HTTP Library", false, "Import TDL HTTP library definitions.", advancedGroup)
	val extendedNature = check("Add additional natures", false, "Add Eclipse Plug-in and Java natures", advancedGroup)

    @Inject
    PluginImageHelper pluginImageHelper

	override protected updateVariables() {
		name.enabled = advanced.value
		path.enabled = advanced.value
		importStandard.enabled = advanced.value
		importHTTP.enabled = advanced.value
		extendedNature.enabled = advanced.value
		if (!advanced.value) {
			name.value = "Main"
			path.value = "tdl"
			importStandard.value = true
			importHTTP.value = false
			extendedNature.value = false
		}
	}

	override protected validate() {
		//TODO: validate name as well
		if (path.value.matches('[a-z][a-z0-9_.]*(/[a-z][a-z0-9_.]*)*'))
			null
		else
			new Status(ERROR, "Wizard", "'" + path + "' is not a valid package name")
			//TODO: validate data definitions as well
	}

	override generateProjects(IProjectGenerator generator) {
		generator.generate(new PluginProjectFactory => [
			projectName = projectInfo.projectName
			location = projectInfo.locationPath
			projectNatures += #[XtextProjectHelper.NATURE_ID, "org.etsi.mts.tdl.nature"]
			builderIds += #[XtextProjectHelper.BUILDER_ID]
			if (extendedNature.value) {
	            projectNatures += #[JavaCore.NATURE_ID, "org.eclipse.pde.PluginNature"]
	            builderIds += #[JavaCore.BUILDER_ID]
			}
			folders += "src"
			//TODO: remove hardcoded import
			var imports = ""
			if (importStandard.value) {
	            addFile('''src/«path»/TDL.tdltx''', TemplateHelper.getLibrary("TDL"))
	            imports += "Import all from TDL\n"
			}
			if (importHTTP.value) {
				addFile('''src/«path»/HTTP.tdltx''', TemplateHelper.getLibrary("HTTP"))
				imports += "Import all from HTTP\n"
				imports += "Import all from HTTP.MessageBased\n"
			}
			addFile('''src/«path»/«name».tdltx''', '''
				/*
				 * This is an example package
				 */
				Package «name» {
				    «imports»
				    //example type
				    Type float
				    //define additional elements here
				}
			''')
		])
		//TODO: make more robust and share among other templates
		open(projectInfo.projectName+"/src/"+path+"/"+name+".tdltx")		
	}
	
	private def open(String filePath) {
        val path = new Path(filePath)
		val ifile=ResourcesPlugin.getWorkspace().getRoot().getFile(path)
//        val page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		val page = PlatformUI.workbench.workbenchWindows.get(0).activePage
		Display.^default.asyncExec(new Runnable() {
			
			override run() {
				IDE.openEditor(page, ifile)
			}
			
        })
	}
	
    protected override List<Pair<String, Image>> getImages() {
        #["project_template.png".image]
    }
    private def image(String id) {
        id -> pluginImageHelper.getImage('''platform:/plugin/«TxActivator.PLUGIN_ID»/«id»''')
    }
	
}
