/*
 * generated by Xtext 2.10.0
 */
package org.etsi.mts.tdl.scoping;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.etsi.mts.tdl.DataInstanceUse;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.GateInstance;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.MemberReference;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.structuredobjectives.Content;
import org.etsi.mts.tdl.structuredobjectives.LiteralValue;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
public class TPLan2ScopeProvider extends AbstractDeclarativeScopeProvider {
	
	@Override
	public IScope getScope(EObject context, EReference reference) {
		if (PackageableElement.class.isAssignableFrom(reference.getEType().getInstanceClass())
				&& !(context instanceof ElementImport)) {
			EList<EObject> elements = getScopedElementsOfType(context, reference.getEType().getInstanceClass());
			return Scopes.scopeFor(elements);
		}
		if (reference.getEType().getInstanceClass() == GateInstance.class) {
			if (context instanceof GateReference) {
				GateReference gate = (GateReference) context;
				if (gate.getComponent().getType()!=null) {
					IScope scope = Scopes.scopeFor(gate.getComponent().getType().getGateInstance());
					return scope;
				}
			}
		} else if (Parameter.class.isAssignableFrom(reference.getEType().getInstanceClass())) {
			if (context instanceof MemberAssignment) {
				if (context.eContainer() instanceof StructuredDataInstance) {
					IScope scope = Scopes.scopeFor(((StructuredDataType)((StructuredDataInstance)context.eContainer()).getDataType()).allMembers());
					return scope;
				}
			} else if (context instanceof ParameterBinding) {
				if (context.eContainer() instanceof DataInstanceUse) {
					if (((DataInstanceUse)context.eContainer()).getDataInstance() instanceof StructuredDataInstance) {
						IScope scope = Scopes.scopeFor(((StructuredDataType)((StructuredDataInstance)((DataInstanceUse)context.eContainer()).getDataInstance()).getDataType()).allMembers());
						return scope;
					}
				}
			} else if (context instanceof MemberReference) {
				if (((DataUse)context.eContainer()).getReduction().indexOf(context)>0) {
					EObject targetContext = ((DataUse)context.eContainer()).getReduction().get(((DataUse)context.eContainer()).getReduction().indexOf(context)-1);
					if (((MemberReference)targetContext).getMember()!=null) {
						if (((MemberReference)targetContext).getMember().getDataType() instanceof StructuredDataType) {
							IScope scope = Scopes.scopeFor(((StructuredDataType)((MemberReference)targetContext).getMember().getDataType()).allMembers());
							return scope;
						}
					}
				} 
				if (context.eContainer() instanceof DataInstanceUse) {
					if (((DataInstanceUse)context.eContainer()).getDataInstance() instanceof StructuredDataInstance) {
						IScope scope = Scopes.scopeFor(((StructuredDataType)((StructuredDataInstance)((DataInstanceUse)context.eContainer()).getDataInstance()).getDataType()).allMembers());
						return scope;
					}
				}
			} else if (context instanceof Content) {
				if (context.eContainer() instanceof LiteralValue) {
					if (((LiteralValue)context.eContainer()).getDataType() instanceof StructuredDataType) {
						IScope scope = Scopes.scopeFor(((StructuredDataType)((LiteralValue)context.eContainer()).getDataType()).allMembers());
						return scope;
					}
				} else if (context.eContainer() instanceof Content) {
					if (((Content)context.eContainer()).getMember().getDataType() instanceof StructuredDataType) {
						IScope scope = Scopes.scopeFor(((StructuredDataType)((Content)context.eContainer()).getMember().getDataType()).allMembers());
						return scope;
					}
				}
			}
		} else {
		}
		
		return super.getScope(context, reference);
	}
	
	public IScope scope_ElementImport_importedElement(ElementImport context, EReference ref) {
		EList<EObject> elements = new BasicEList<>();
		Package ip = context.getImportedPackage();
		for (PackageableElement e : ip.getPackagedElement()) {
			elements.add(e);
		}
		IScope scope = Scopes.scopeFor(elements);
		return scope;
	}
	
	private Package getPackage(EObject e) {
		if (e.eContainer()!=null) {
			if (e.eContainer() instanceof Package) {
				return (Package)e.eContainer();
			} else {
				return getPackage(e.eContainer());
			}
		} else {
			return (Package)e;
		}
	}
	
	private EList<EObject> getScopedElementsOfType(EObject context, Class c) {
		EList<EObject> elements = new BasicEList<>();
		Package p = getPackage(context);
		
		//within same package
		for (PackageableElement e : p.getPackagedElement()) {
			if (c.isInstance(e)) {
				elements.add(e);
			}
		}
		
		//within imported packages
		for (ElementImport i : p.getImport()) {
			Package ip = i.getImportedPackage();
			if (ip != null) {
				if (i.getImportedElement().isEmpty()) {
					//import all
					for (PackageableElement e : ip.getPackagedElement()) {
						if (c.isInstance(e)) {
							elements.add(e);
						}
					}
				} else {
					//specific imports
					for (PackageableElement e : i.getImportedElement()) {
						if (c.isInstance(e)) {
							elements.add(e);
						}
					}
				}
			}
		}
		return elements;
	}
}
