# TOP: TDL Open source Project

Welcome to the TOP TDL repository.

More info at [TDL website](https://tdl.etsi.org)

## Installing the plug-ins

The TDL tools are available as a set of Eclipse plug-ins. You need to first be able to run Eclipse. The [Eclipse Neon Modeling Tools](http://www.eclipse.org/downloads/packages/eclipse-modeling-tools/neon3) distribution contains most of the necessary prerequisites for the TDL tools.

Once Eclipse is up and running, you need to add the [update site](http://tdl.etsi.org/eclipse/neon/) for the TDL tools: 

    https://tdl.etsi.org/eclipse/neon

After the update site is added, the list of plug-ins and features shall be shown in the installation dialog (menu item Help->Install New Software..). Select the desired features and proceed with the installation, which will require Eclipse to be restarted once the installation is finished.

Find more detailed information at [Installation wiki](https://tdl.etsi.org/wiki/index.php/Installation).

## Using the plug-ins

Before any models can be created, you need to create a TDL project. In file menu select New and Project...
In the following page, locate the TDL Project and continue to complete the wizard. A file `model.tdl` is created which contains the basic structure of TDL model.

To create a new Generic **TDL diagram**:

* right click on the project and select Create Representation
* select the Generic TDL and on the next page select the root package in the model.tdl file

To create a new TDL model by means of the **TDLan2 textual representation**: 

* right click on a project or a folder in the package explorer and select New -> File,
* type the filename ending with `.tdlan2` and 
* the corresponding editor shall be automatically opened.

To create a new TDL model by means of the TDLan2 textual representation for **structured test objectives**:

* right click on a project or a folder in the package explorer and select New -> File, 
* type the filename ending with `.tplan2` and 
* the corresponding editor shall be automatically opened.

To translate a TDL model from the TDLan2 textual representation to the **XF format** (or the other way around) open the source model and press the <code>T</code> icon on the toolbar. The resulting model shall be stored in the same folder as the source model with the type of the model (`.tdlan2` or `.tdl`) appended to the name of the source model.

More information on using the plugins is available at [Usage wiki](https://tdl.etsi.org/wiki/index.php/Usage).

## Setting up a local environment for development and testing

 * Download and install Eclipse Modeling Tools package
 * Install following additional components from Eclipse Marketplace
     * Sirius
     * Eclipse Xtext
     * Epsilon
     * Eclipse OCL
 * Check out the repository
 * Import the plug-ins in the Eclipse workspace
 * Generate the meta-model code
     * Open the `tdl.genmodel` 
     * Right click on the top-node and generate model code 
 * Generate textual editor code
     * Open the `GenerateTDLan2.mwe`
     * Right click and select Run As -> MWE2 Workflow
     * Additionally (or alternatively) repeat the same steps for the `GenerateTPLan2.mwe` (for editing structured test objectives)
     * Additionally (or alternatively) repeat the same steps for the `GenerateData.mwe` (for the graphical viewer)

## Implementation of the TDL mapping to TTCN-3

The TDL mapping to TTCN-3 relies on some functionalities from [TRex2 / T3Tools](https://t3tools.informatik.uni-goettingen.de/trac). Before installing or developing the implementation of the TDL mapping to TTCN-3, the corresponding components need to be installed from the following update site:

    https://t3tools.informatik.uni-goettingen.de/downloads/trex2/

After installation, to apply the transformation of a TDL model into TTCN-3 code, open the TDL model (making sure it is selected) and press the `T3` icon on the toolbar. This shall result in the generation of a `.ttcn3` file with the same name in the same folder as the model.