/**
 */
package org.etsi.mts.tdl.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.etsi.mts.tdl.Action;
import org.etsi.mts.tdl.ActionBehaviour;
import org.etsi.mts.tdl.ActionReference;
import org.etsi.mts.tdl.AlternativeBehaviour;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.AnyValue;
import org.etsi.mts.tdl.AnyValueOrOmit;
import org.etsi.mts.tdl.Assertion;
import org.etsi.mts.tdl.Assignment;
import org.etsi.mts.tdl.AtomicBehaviour;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.BehaviourDescription;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.BoundedLoopBehaviour;
import org.etsi.mts.tdl.Break;
import org.etsi.mts.tdl.CollectionDataInstance;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.CombinedBehaviour;
import org.etsi.mts.tdl.Comment;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.ComponentInstanceBinding;
import org.etsi.mts.tdl.ComponentType;
import org.etsi.mts.tdl.CompoundBehaviour;
import org.etsi.mts.tdl.ConditionalBehaviour;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.Constraint;
import org.etsi.mts.tdl.ConstraintType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataElementUse;
import org.etsi.mts.tdl.DataInstance;
import org.etsi.mts.tdl.DataInstanceUse;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.DefaultBehaviour;
import org.etsi.mts.tdl.DynamicDataUse;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.ExceptionalBehaviour;
import org.etsi.mts.tdl.Extension;
import org.etsi.mts.tdl.FormalParameter;
import org.etsi.mts.tdl.FormalParameterUse;
import org.etsi.mts.tdl.Function;
import org.etsi.mts.tdl.FunctionCall;
import org.etsi.mts.tdl.GateInstance;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.GateType;
import org.etsi.mts.tdl.InlineAction;
import org.etsi.mts.tdl.Interaction;
import org.etsi.mts.tdl.InterruptBehaviour;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.MemberReference;
import org.etsi.mts.tdl.Message;
import org.etsi.mts.tdl.MultipleCombinedBehaviour;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.OmitValue;
import org.etsi.mts.tdl.OptionalBehaviour;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.ParallelBehaviour;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.PredefinedFunction;
import org.etsi.mts.tdl.PredefinedFunctionCall;
import org.etsi.mts.tdl.ProcedureCall;
import org.etsi.mts.tdl.ProcedureParameter;
import org.etsi.mts.tdl.ProcedureSignature;
import org.etsi.mts.tdl.Quiescence;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.SingleCombinedBehaviour;
import org.etsi.mts.tdl.SpecialValueUse;
import org.etsi.mts.tdl.StaticDataUse;
import org.etsi.mts.tdl.Stop;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.Target;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestDescriptionReference;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.Time;
import org.etsi.mts.tdl.TimeConstraint;
import org.etsi.mts.tdl.TimeLabel;
import org.etsi.mts.tdl.TimeLabelUse;
import org.etsi.mts.tdl.TimeOperation;
import org.etsi.mts.tdl.TimeOut;
import org.etsi.mts.tdl.Timer;
import org.etsi.mts.tdl.TimerOperation;
import org.etsi.mts.tdl.TimerStart;
import org.etsi.mts.tdl.TimerStop;
import org.etsi.mts.tdl.UnboundedLoopBehaviour;
import org.etsi.mts.tdl.ValueAssignment;
import org.etsi.mts.tdl.Variable;
import org.etsi.mts.tdl.VariableUse;
import org.etsi.mts.tdl.VerdictAssignment;
import org.etsi.mts.tdl.Wait;
import org.etsi.mts.tdl.tdlPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.etsi.mts.tdl.tdlPackage
 * @generated
 */
public class tdlSwitch<T> extends Switch<T>
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static tdlPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public tdlSwitch()
	{
		if (modelPackage == null) {
			modelPackage = tdlPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage)
	{
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID) {
			case tdlPackage.ELEMENT: {
				Element element = (Element)theEObject;
				T result = caseElement(element);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COMMENT: {
				Comment comment = (Comment)theEObject;
				T result = caseComment(comment);
				if (result == null) result = caseElement(comment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ANNOTATION: {
				Annotation annotation = (Annotation)theEObject;
				T result = caseAnnotation(annotation);
				if (result == null) result = caseElement(annotation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ANNOTATION_TYPE: {
				AnnotationType annotationType = (AnnotationType)theEObject;
				T result = caseAnnotationType(annotationType);
				if (result == null) result = casePackageableElement(annotationType);
				if (result == null) result = caseNamedElement(annotationType);
				if (result == null) result = caseElement(annotationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PACKAGEABLE_ELEMENT: {
				PackageableElement packageableElement = (PackageableElement)theEObject;
				T result = casePackageableElement(packageableElement);
				if (result == null) result = caseNamedElement(packageableElement);
				if (result == null) result = caseElement(packageableElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.NAMED_ELEMENT: {
				NamedElement namedElement = (NamedElement)theEObject;
				T result = caseNamedElement(namedElement);
				if (result == null) result = caseElement(namedElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PACKAGE: {
				org.etsi.mts.tdl.Package package_ = (org.etsi.mts.tdl.Package)theEObject;
				T result = casePackage(package_);
				if (result == null) result = caseNamedElement(package_);
				if (result == null) result = caseElement(package_);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ELEMENT_IMPORT: {
				ElementImport elementImport = (ElementImport)theEObject;
				T result = caseElementImport(elementImport);
				if (result == null) result = caseElement(elementImport);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TEST_OBJECTIVE: {
				TestObjective testObjective = (TestObjective)theEObject;
				T result = caseTestObjective(testObjective);
				if (result == null) result = casePackageableElement(testObjective);
				if (result == null) result = caseNamedElement(testObjective);
				if (result == null) result = caseElement(testObjective);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_INSTANCE: {
				DataInstance dataInstance = (DataInstance)theEObject;
				T result = caseDataInstance(dataInstance);
				if (result == null) result = caseMappableDataElement(dataInstance);
				if (result == null) result = casePackageableElement(dataInstance);
				if (result == null) result = caseNamedElement(dataInstance);
				if (result == null) result = caseElement(dataInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.MAPPABLE_DATA_ELEMENT: {
				MappableDataElement mappableDataElement = (MappableDataElement)theEObject;
				T result = caseMappableDataElement(mappableDataElement);
				if (result == null) result = casePackageableElement(mappableDataElement);
				if (result == null) result = caseNamedElement(mappableDataElement);
				if (result == null) result = caseElement(mappableDataElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_TYPE: {
				DataType dataType = (DataType)theEObject;
				T result = caseDataType(dataType);
				if (result == null) result = caseMappableDataElement(dataType);
				if (result == null) result = casePackageableElement(dataType);
				if (result == null) result = caseNamedElement(dataType);
				if (result == null) result = caseElement(dataType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_RESOURCE_MAPPING: {
				DataResourceMapping dataResourceMapping = (DataResourceMapping)theEObject;
				T result = caseDataResourceMapping(dataResourceMapping);
				if (result == null) result = casePackageableElement(dataResourceMapping);
				if (result == null) result = caseNamedElement(dataResourceMapping);
				if (result == null) result = caseElement(dataResourceMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_ELEMENT_MAPPING: {
				DataElementMapping dataElementMapping = (DataElementMapping)theEObject;
				T result = caseDataElementMapping(dataElementMapping);
				if (result == null) result = casePackageableElement(dataElementMapping);
				if (result == null) result = caseNamedElement(dataElementMapping);
				if (result == null) result = caseElement(dataElementMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PARAMETER_MAPPING: {
				ParameterMapping parameterMapping = (ParameterMapping)theEObject;
				T result = caseParameterMapping(parameterMapping);
				if (result == null) result = caseElement(parameterMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PARAMETER: {
				Parameter parameter = (Parameter)theEObject;
				T result = caseParameter(parameter);
				if (result == null) result = caseNamedElement(parameter);
				if (result == null) result = caseElement(parameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.SIMPLE_DATA_TYPE: {
				SimpleDataType simpleDataType = (SimpleDataType)theEObject;
				T result = caseSimpleDataType(simpleDataType);
				if (result == null) result = caseDataType(simpleDataType);
				if (result == null) result = caseMappableDataElement(simpleDataType);
				if (result == null) result = casePackageableElement(simpleDataType);
				if (result == null) result = caseNamedElement(simpleDataType);
				if (result == null) result = caseElement(simpleDataType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.SIMPLE_DATA_INSTANCE: {
				SimpleDataInstance simpleDataInstance = (SimpleDataInstance)theEObject;
				T result = caseSimpleDataInstance(simpleDataInstance);
				if (result == null) result = caseDataInstance(simpleDataInstance);
				if (result == null) result = caseMappableDataElement(simpleDataInstance);
				if (result == null) result = casePackageableElement(simpleDataInstance);
				if (result == null) result = caseNamedElement(simpleDataInstance);
				if (result == null) result = caseElement(simpleDataInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.STRUCTURED_DATA_TYPE: {
				StructuredDataType structuredDataType = (StructuredDataType)theEObject;
				T result = caseStructuredDataType(structuredDataType);
				if (result == null) result = caseDataType(structuredDataType);
				if (result == null) result = caseMappableDataElement(structuredDataType);
				if (result == null) result = casePackageableElement(structuredDataType);
				if (result == null) result = caseNamedElement(structuredDataType);
				if (result == null) result = caseElement(structuredDataType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.MEMBER: {
				Member member = (Member)theEObject;
				T result = caseMember(member);
				if (result == null) result = caseParameter(member);
				if (result == null) result = caseNamedElement(member);
				if (result == null) result = caseElement(member);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.STRUCTURED_DATA_INSTANCE: {
				StructuredDataInstance structuredDataInstance = (StructuredDataInstance)theEObject;
				T result = caseStructuredDataInstance(structuredDataInstance);
				if (result == null) result = caseDataInstance(structuredDataInstance);
				if (result == null) result = caseMappableDataElement(structuredDataInstance);
				if (result == null) result = casePackageableElement(structuredDataInstance);
				if (result == null) result = caseNamedElement(structuredDataInstance);
				if (result == null) result = caseElement(structuredDataInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.MEMBER_ASSIGNMENT: {
				MemberAssignment memberAssignment = (MemberAssignment)theEObject;
				T result = caseMemberAssignment(memberAssignment);
				if (result == null) result = caseElement(memberAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.STATIC_DATA_USE: {
				StaticDataUse staticDataUse = (StaticDataUse)theEObject;
				T result = caseStaticDataUse(staticDataUse);
				if (result == null) result = caseDataUse(staticDataUse);
				if (result == null) result = caseElement(staticDataUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_USE: {
				DataUse dataUse = (DataUse)theEObject;
				T result = caseDataUse(dataUse);
				if (result == null) result = caseElement(dataUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PARAMETER_BINDING: {
				ParameterBinding parameterBinding = (ParameterBinding)theEObject;
				T result = caseParameterBinding(parameterBinding);
				if (result == null) result = caseElement(parameterBinding);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ACTION: {
				Action action = (Action)theEObject;
				T result = caseAction(action);
				if (result == null) result = caseMappableDataElement(action);
				if (result == null) result = casePackageableElement(action);
				if (result == null) result = caseNamedElement(action);
				if (result == null) result = caseElement(action);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.FORMAL_PARAMETER: {
				FormalParameter formalParameter = (FormalParameter)theEObject;
				T result = caseFormalParameter(formalParameter);
				if (result == null) result = caseParameter(formalParameter);
				if (result == null) result = caseNamedElement(formalParameter);
				if (result == null) result = caseElement(formalParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.FUNCTION: {
				Function function = (Function)theEObject;
				T result = caseFunction(function);
				if (result == null) result = caseAction(function);
				if (result == null) result = caseMappableDataElement(function);
				if (result == null) result = casePackageableElement(function);
				if (result == null) result = caseNamedElement(function);
				if (result == null) result = caseElement(function);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.FORMAL_PARAMETER_USE: {
				FormalParameterUse formalParameterUse = (FormalParameterUse)theEObject;
				T result = caseFormalParameterUse(formalParameterUse);
				if (result == null) result = caseDynamicDataUse(formalParameterUse);
				if (result == null) result = caseDataUse(formalParameterUse);
				if (result == null) result = caseElement(formalParameterUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DYNAMIC_DATA_USE: {
				DynamicDataUse dynamicDataUse = (DynamicDataUse)theEObject;
				T result = caseDynamicDataUse(dynamicDataUse);
				if (result == null) result = caseDataUse(dynamicDataUse);
				if (result == null) result = caseElement(dynamicDataUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.VARIABLE: {
				Variable variable = (Variable)theEObject;
				T result = caseVariable(variable);
				if (result == null) result = caseNamedElement(variable);
				if (result == null) result = caseElement(variable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.FUNCTION_CALL: {
				FunctionCall functionCall = (FunctionCall)theEObject;
				T result = caseFunctionCall(functionCall);
				if (result == null) result = caseDynamicDataUse(functionCall);
				if (result == null) result = caseDataUse(functionCall);
				if (result == null) result = caseElement(functionCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.VARIABLE_USE: {
				VariableUse variableUse = (VariableUse)theEObject;
				T result = caseVariableUse(variableUse);
				if (result == null) result = caseDynamicDataUse(variableUse);
				if (result == null) result = caseDataUse(variableUse);
				if (result == null) result = caseElement(variableUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COMPONENT_INSTANCE: {
				ComponentInstance componentInstance = (ComponentInstance)theEObject;
				T result = caseComponentInstance(componentInstance);
				if (result == null) result = caseNamedElement(componentInstance);
				if (result == null) result = caseElement(componentInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COMPONENT_TYPE: {
				ComponentType componentType = (ComponentType)theEObject;
				T result = caseComponentType(componentType);
				if (result == null) result = casePackageableElement(componentType);
				if (result == null) result = caseNamedElement(componentType);
				if (result == null) result = caseElement(componentType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.GATE_INSTANCE: {
				GateInstance gateInstance = (GateInstance)theEObject;
				T result = caseGateInstance(gateInstance);
				if (result == null) result = caseNamedElement(gateInstance);
				if (result == null) result = caseElement(gateInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.GATE_TYPE: {
				GateType gateType = (GateType)theEObject;
				T result = caseGateType(gateType);
				if (result == null) result = casePackageableElement(gateType);
				if (result == null) result = caseNamedElement(gateType);
				if (result == null) result = caseElement(gateType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIMER: {
				Timer timer = (Timer)theEObject;
				T result = caseTimer(timer);
				if (result == null) result = caseNamedElement(timer);
				if (result == null) result = caseElement(timer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.OMIT_VALUE: {
				OmitValue omitValue = (OmitValue)theEObject;
				T result = caseOmitValue(omitValue);
				if (result == null) result = caseSpecialValueUse(omitValue);
				if (result == null) result = caseStaticDataUse(omitValue);
				if (result == null) result = caseDataUse(omitValue);
				if (result == null) result = caseElement(omitValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.SPECIAL_VALUE_USE: {
				SpecialValueUse specialValueUse = (SpecialValueUse)theEObject;
				T result = caseSpecialValueUse(specialValueUse);
				if (result == null) result = caseStaticDataUse(specialValueUse);
				if (result == null) result = caseDataUse(specialValueUse);
				if (result == null) result = caseElement(specialValueUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ANY_VALUE: {
				AnyValue anyValue = (AnyValue)theEObject;
				T result = caseAnyValue(anyValue);
				if (result == null) result = caseSpecialValueUse(anyValue);
				if (result == null) result = caseStaticDataUse(anyValue);
				if (result == null) result = caseDataUse(anyValue);
				if (result == null) result = caseElement(anyValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ANY_VALUE_OR_OMIT: {
				AnyValueOrOmit anyValueOrOmit = (AnyValueOrOmit)theEObject;
				T result = caseAnyValueOrOmit(anyValueOrOmit);
				if (result == null) result = caseSpecialValueUse(anyValueOrOmit);
				if (result == null) result = caseStaticDataUse(anyValueOrOmit);
				if (result == null) result = caseDataUse(anyValueOrOmit);
				if (result == null) result = caseElement(anyValueOrOmit);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_INSTANCE_USE: {
				DataInstanceUse dataInstanceUse = (DataInstanceUse)theEObject;
				T result = caseDataInstanceUse(dataInstanceUse);
				if (result == null) result = caseStaticDataUse(dataInstanceUse);
				if (result == null) result = caseDataUse(dataInstanceUse);
				if (result == null) result = caseElement(dataInstanceUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIME: {
				Time time = (Time)theEObject;
				T result = caseTime(time);
				if (result == null) result = caseSimpleDataType(time);
				if (result == null) result = caseDataType(time);
				if (result == null) result = caseMappableDataElement(time);
				if (result == null) result = casePackageableElement(time);
				if (result == null) result = caseNamedElement(time);
				if (result == null) result = caseElement(time);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIME_LABEL: {
				TimeLabel timeLabel = (TimeLabel)theEObject;
				T result = caseTimeLabel(timeLabel);
				if (result == null) result = caseNamedElement(timeLabel);
				if (result == null) result = caseElement(timeLabel);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIMER_OPERATION: {
				TimerOperation timerOperation = (TimerOperation)theEObject;
				T result = caseTimerOperation(timerOperation);
				if (result == null) result = caseAtomicBehaviour(timerOperation);
				if (result == null) result = caseBehaviour(timerOperation);
				if (result == null) result = caseElement(timerOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ATOMIC_BEHAVIOUR: {
				AtomicBehaviour atomicBehaviour = (AtomicBehaviour)theEObject;
				T result = caseAtomicBehaviour(atomicBehaviour);
				if (result == null) result = caseBehaviour(atomicBehaviour);
				if (result == null) result = caseElement(atomicBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.BEHAVIOUR: {
				Behaviour behaviour = (Behaviour)theEObject;
				T result = caseBehaviour(behaviour);
				if (result == null) result = caseElement(behaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIME_CONSTRAINT: {
				TimeConstraint timeConstraint = (TimeConstraint)theEObject;
				T result = caseTimeConstraint(timeConstraint);
				if (result == null) result = caseElement(timeConstraint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIMER_START: {
				TimerStart timerStart = (TimerStart)theEObject;
				T result = caseTimerStart(timerStart);
				if (result == null) result = caseTimerOperation(timerStart);
				if (result == null) result = caseAtomicBehaviour(timerStart);
				if (result == null) result = caseBehaviour(timerStart);
				if (result == null) result = caseElement(timerStart);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIMER_STOP: {
				TimerStop timerStop = (TimerStop)theEObject;
				T result = caseTimerStop(timerStop);
				if (result == null) result = caseTimerOperation(timerStop);
				if (result == null) result = caseAtomicBehaviour(timerStop);
				if (result == null) result = caseBehaviour(timerStop);
				if (result == null) result = caseElement(timerStop);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIME_OUT: {
				TimeOut timeOut = (TimeOut)theEObject;
				T result = caseTimeOut(timeOut);
				if (result == null) result = caseTimerOperation(timeOut);
				if (result == null) result = caseAtomicBehaviour(timeOut);
				if (result == null) result = caseBehaviour(timeOut);
				if (result == null) result = caseElement(timeOut);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIME_OPERATION: {
				TimeOperation timeOperation = (TimeOperation)theEObject;
				T result = caseTimeOperation(timeOperation);
				if (result == null) result = caseAtomicBehaviour(timeOperation);
				if (result == null) result = caseBehaviour(timeOperation);
				if (result == null) result = caseElement(timeOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.WAIT: {
				Wait wait = (Wait)theEObject;
				T result = caseWait(wait);
				if (result == null) result = caseTimeOperation(wait);
				if (result == null) result = caseAtomicBehaviour(wait);
				if (result == null) result = caseBehaviour(wait);
				if (result == null) result = caseElement(wait);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.QUIESCENCE: {
				Quiescence quiescence = (Quiescence)theEObject;
				T result = caseQuiescence(quiescence);
				if (result == null) result = caseTimeOperation(quiescence);
				if (result == null) result = caseAtomicBehaviour(quiescence);
				if (result == null) result = caseBehaviour(quiescence);
				if (result == null) result = caseElement(quiescence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.GATE_REFERENCE: {
				GateReference gateReference = (GateReference)theEObject;
				T result = caseGateReference(gateReference);
				if (result == null) result = caseElement(gateReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TIME_LABEL_USE: {
				TimeLabelUse timeLabelUse = (TimeLabelUse)theEObject;
				T result = caseTimeLabelUse(timeLabelUse);
				if (result == null) result = caseDynamicDataUse(timeLabelUse);
				if (result == null) result = caseDataUse(timeLabelUse);
				if (result == null) result = caseElement(timeLabelUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TEST_CONFIGURATION: {
				TestConfiguration testConfiguration = (TestConfiguration)theEObject;
				T result = caseTestConfiguration(testConfiguration);
				if (result == null) result = casePackageableElement(testConfiguration);
				if (result == null) result = caseNamedElement(testConfiguration);
				if (result == null) result = caseElement(testConfiguration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.CONNECTION: {
				Connection connection = (Connection)theEObject;
				T result = caseConnection(connection);
				if (result == null) result = caseElement(connection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TEST_DESCRIPTION: {
				TestDescription testDescription = (TestDescription)theEObject;
				T result = caseTestDescription(testDescription);
				if (result == null) result = casePackageableElement(testDescription);
				if (result == null) result = caseNamedElement(testDescription);
				if (result == null) result = caseElement(testDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.BEHAVIOUR_DESCRIPTION: {
				BehaviourDescription behaviourDescription = (BehaviourDescription)theEObject;
				T result = caseBehaviourDescription(behaviourDescription);
				if (result == null) result = caseElement(behaviourDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.BLOCK: {
				Block block = (Block)theEObject;
				T result = caseBlock(block);
				if (result == null) result = caseElement(block);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COMBINED_BEHAVIOUR: {
				CombinedBehaviour combinedBehaviour = (CombinedBehaviour)theEObject;
				T result = caseCombinedBehaviour(combinedBehaviour);
				if (result == null) result = caseBehaviour(combinedBehaviour);
				if (result == null) result = caseElement(combinedBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PERIODIC_BEHAVIOUR: {
				PeriodicBehaviour periodicBehaviour = (PeriodicBehaviour)theEObject;
				T result = casePeriodicBehaviour(periodicBehaviour);
				if (result == null) result = caseBehaviour(periodicBehaviour);
				if (result == null) result = caseElement(periodicBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.EXCEPTIONAL_BEHAVIOUR: {
				ExceptionalBehaviour exceptionalBehaviour = (ExceptionalBehaviour)theEObject;
				T result = caseExceptionalBehaviour(exceptionalBehaviour);
				if (result == null) result = caseBehaviour(exceptionalBehaviour);
				if (result == null) result = caseElement(exceptionalBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ALTERNATIVE_BEHAVIOUR: {
				AlternativeBehaviour alternativeBehaviour = (AlternativeBehaviour)theEObject;
				T result = caseAlternativeBehaviour(alternativeBehaviour);
				if (result == null) result = caseMultipleCombinedBehaviour(alternativeBehaviour);
				if (result == null) result = caseCombinedBehaviour(alternativeBehaviour);
				if (result == null) result = caseBehaviour(alternativeBehaviour);
				if (result == null) result = caseElement(alternativeBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.MULTIPLE_COMBINED_BEHAVIOUR: {
				MultipleCombinedBehaviour multipleCombinedBehaviour = (MultipleCombinedBehaviour)theEObject;
				T result = caseMultipleCombinedBehaviour(multipleCombinedBehaviour);
				if (result == null) result = caseCombinedBehaviour(multipleCombinedBehaviour);
				if (result == null) result = caseBehaviour(multipleCombinedBehaviour);
				if (result == null) result = caseElement(multipleCombinedBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PARALLEL_BEHAVIOUR: {
				ParallelBehaviour parallelBehaviour = (ParallelBehaviour)theEObject;
				T result = caseParallelBehaviour(parallelBehaviour);
				if (result == null) result = caseMultipleCombinedBehaviour(parallelBehaviour);
				if (result == null) result = caseCombinedBehaviour(parallelBehaviour);
				if (result == null) result = caseBehaviour(parallelBehaviour);
				if (result == null) result = caseElement(parallelBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.BOUNDED_LOOP_BEHAVIOUR: {
				BoundedLoopBehaviour boundedLoopBehaviour = (BoundedLoopBehaviour)theEObject;
				T result = caseBoundedLoopBehaviour(boundedLoopBehaviour);
				if (result == null) result = caseSingleCombinedBehaviour(boundedLoopBehaviour);
				if (result == null) result = caseCombinedBehaviour(boundedLoopBehaviour);
				if (result == null) result = caseBehaviour(boundedLoopBehaviour);
				if (result == null) result = caseElement(boundedLoopBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.SINGLE_COMBINED_BEHAVIOUR: {
				SingleCombinedBehaviour singleCombinedBehaviour = (SingleCombinedBehaviour)theEObject;
				T result = caseSingleCombinedBehaviour(singleCombinedBehaviour);
				if (result == null) result = caseCombinedBehaviour(singleCombinedBehaviour);
				if (result == null) result = caseBehaviour(singleCombinedBehaviour);
				if (result == null) result = caseElement(singleCombinedBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.OPTIONAL_BEHAVIOUR: {
				OptionalBehaviour optionalBehaviour = (OptionalBehaviour)theEObject;
				T result = caseOptionalBehaviour(optionalBehaviour);
				if (result == null) result = caseSingleCombinedBehaviour(optionalBehaviour);
				if (result == null) result = caseCombinedBehaviour(optionalBehaviour);
				if (result == null) result = caseBehaviour(optionalBehaviour);
				if (result == null) result = caseElement(optionalBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.UNBOUNDED_LOOP_BEHAVIOUR: {
				UnboundedLoopBehaviour unboundedLoopBehaviour = (UnboundedLoopBehaviour)theEObject;
				T result = caseUnboundedLoopBehaviour(unboundedLoopBehaviour);
				if (result == null) result = caseSingleCombinedBehaviour(unboundedLoopBehaviour);
				if (result == null) result = caseCombinedBehaviour(unboundedLoopBehaviour);
				if (result == null) result = caseBehaviour(unboundedLoopBehaviour);
				if (result == null) result = caseElement(unboundedLoopBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.CONDITIONAL_BEHAVIOUR: {
				ConditionalBehaviour conditionalBehaviour = (ConditionalBehaviour)theEObject;
				T result = caseConditionalBehaviour(conditionalBehaviour);
				if (result == null) result = caseMultipleCombinedBehaviour(conditionalBehaviour);
				if (result == null) result = caseCombinedBehaviour(conditionalBehaviour);
				if (result == null) result = caseBehaviour(conditionalBehaviour);
				if (result == null) result = caseElement(conditionalBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COMPOUND_BEHAVIOUR: {
				CompoundBehaviour compoundBehaviour = (CompoundBehaviour)theEObject;
				T result = caseCompoundBehaviour(compoundBehaviour);
				if (result == null) result = caseSingleCombinedBehaviour(compoundBehaviour);
				if (result == null) result = caseCombinedBehaviour(compoundBehaviour);
				if (result == null) result = caseBehaviour(compoundBehaviour);
				if (result == null) result = caseElement(compoundBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DEFAULT_BEHAVIOUR: {
				DefaultBehaviour defaultBehaviour = (DefaultBehaviour)theEObject;
				T result = caseDefaultBehaviour(defaultBehaviour);
				if (result == null) result = caseExceptionalBehaviour(defaultBehaviour);
				if (result == null) result = caseBehaviour(defaultBehaviour);
				if (result == null) result = caseElement(defaultBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.INTERRUPT_BEHAVIOUR: {
				InterruptBehaviour interruptBehaviour = (InterruptBehaviour)theEObject;
				T result = caseInterruptBehaviour(interruptBehaviour);
				if (result == null) result = caseExceptionalBehaviour(interruptBehaviour);
				if (result == null) result = caseBehaviour(interruptBehaviour);
				if (result == null) result = caseElement(interruptBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TARGET: {
				Target target = (Target)theEObject;
				T result = caseTarget(target);
				if (result == null) result = caseElement(target);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.VERDICT_ASSIGNMENT: {
				VerdictAssignment verdictAssignment = (VerdictAssignment)theEObject;
				T result = caseVerdictAssignment(verdictAssignment);
				if (result == null) result = caseAtomicBehaviour(verdictAssignment);
				if (result == null) result = caseBehaviour(verdictAssignment);
				if (result == null) result = caseElement(verdictAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ASSERTION: {
				Assertion assertion = (Assertion)theEObject;
				T result = caseAssertion(assertion);
				if (result == null) result = caseActionBehaviour(assertion);
				if (result == null) result = caseAtomicBehaviour(assertion);
				if (result == null) result = caseBehaviour(assertion);
				if (result == null) result = caseElement(assertion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.STOP: {
				Stop stop = (Stop)theEObject;
				T result = caseStop(stop);
				if (result == null) result = caseAtomicBehaviour(stop);
				if (result == null) result = caseBehaviour(stop);
				if (result == null) result = caseElement(stop);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.BREAK: {
				Break break_ = (Break)theEObject;
				T result = caseBreak(break_);
				if (result == null) result = caseAtomicBehaviour(break_);
				if (result == null) result = caseBehaviour(break_);
				if (result == null) result = caseElement(break_);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ASSIGNMENT: {
				Assignment assignment = (Assignment)theEObject;
				T result = caseAssignment(assignment);
				if (result == null) result = caseAtomicBehaviour(assignment);
				if (result == null) result = caseBehaviour(assignment);
				if (result == null) result = caseElement(assignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ACTION_BEHAVIOUR: {
				ActionBehaviour actionBehaviour = (ActionBehaviour)theEObject;
				T result = caseActionBehaviour(actionBehaviour);
				if (result == null) result = caseAtomicBehaviour(actionBehaviour);
				if (result == null) result = caseBehaviour(actionBehaviour);
				if (result == null) result = caseElement(actionBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.INLINE_ACTION: {
				InlineAction inlineAction = (InlineAction)theEObject;
				T result = caseInlineAction(inlineAction);
				if (result == null) result = caseActionBehaviour(inlineAction);
				if (result == null) result = caseAtomicBehaviour(inlineAction);
				if (result == null) result = caseBehaviour(inlineAction);
				if (result == null) result = caseElement(inlineAction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ACTION_REFERENCE: {
				ActionReference actionReference = (ActionReference)theEObject;
				T result = caseActionReference(actionReference);
				if (result == null) result = caseActionBehaviour(actionReference);
				if (result == null) result = caseAtomicBehaviour(actionReference);
				if (result == null) result = caseBehaviour(actionReference);
				if (result == null) result = caseElement(actionReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.TEST_DESCRIPTION_REFERENCE: {
				TestDescriptionReference testDescriptionReference = (TestDescriptionReference)theEObject;
				T result = caseTestDescriptionReference(testDescriptionReference);
				if (result == null) result = caseAtomicBehaviour(testDescriptionReference);
				if (result == null) result = caseBehaviour(testDescriptionReference);
				if (result == null) result = caseElement(testDescriptionReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COMPONENT_INSTANCE_BINDING: {
				ComponentInstanceBinding componentInstanceBinding = (ComponentInstanceBinding)theEObject;
				T result = caseComponentInstanceBinding(componentInstanceBinding);
				if (result == null) result = caseElement(componentInstanceBinding);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.INTERACTION: {
				Interaction interaction = (Interaction)theEObject;
				T result = caseInteraction(interaction);
				if (result == null) result = caseAtomicBehaviour(interaction);
				if (result == null) result = caseBehaviour(interaction);
				if (result == null) result = caseElement(interaction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.MESSAGE: {
				Message message = (Message)theEObject;
				T result = caseMessage(message);
				if (result == null) result = caseInteraction(message);
				if (result == null) result = caseAtomicBehaviour(message);
				if (result == null) result = caseBehaviour(message);
				if (result == null) result = caseElement(message);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PREDEFINED_FUNCTION: {
				PredefinedFunction predefinedFunction = (PredefinedFunction)theEObject;
				T result = casePredefinedFunction(predefinedFunction);
				if (result == null) result = casePackageableElement(predefinedFunction);
				if (result == null) result = caseNamedElement(predefinedFunction);
				if (result == null) result = caseElement(predefinedFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.MEMBER_REFERENCE: {
				MemberReference memberReference = (MemberReference)theEObject;
				T result = caseMemberReference(memberReference);
				if (result == null) result = caseElement(memberReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PREDEFINED_FUNCTION_CALL: {
				PredefinedFunctionCall predefinedFunctionCall = (PredefinedFunctionCall)theEObject;
				T result = casePredefinedFunctionCall(predefinedFunctionCall);
				if (result == null) result = caseDynamicDataUse(predefinedFunctionCall);
				if (result == null) result = caseDataUse(predefinedFunctionCall);
				if (result == null) result = caseElement(predefinedFunctionCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.LOCAL_EXPRESSION: {
				LocalExpression localExpression = (LocalExpression)theEObject;
				T result = caseLocalExpression(localExpression);
				if (result == null) result = caseElement(localExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.VALUE_ASSIGNMENT: {
				ValueAssignment valueAssignment = (ValueAssignment)theEObject;
				T result = caseValueAssignment(valueAssignment);
				if (result == null) result = caseElement(valueAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PROCEDURE_CALL: {
				ProcedureCall procedureCall = (ProcedureCall)theEObject;
				T result = caseProcedureCall(procedureCall);
				if (result == null) result = caseInteraction(procedureCall);
				if (result == null) result = caseAtomicBehaviour(procedureCall);
				if (result == null) result = caseBehaviour(procedureCall);
				if (result == null) result = caseElement(procedureCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PROCEDURE_SIGNATURE: {
				ProcedureSignature procedureSignature = (ProcedureSignature)theEObject;
				T result = caseProcedureSignature(procedureSignature);
				if (result == null) result = caseDataType(procedureSignature);
				if (result == null) result = caseMappableDataElement(procedureSignature);
				if (result == null) result = casePackageableElement(procedureSignature);
				if (result == null) result = caseNamedElement(procedureSignature);
				if (result == null) result = caseElement(procedureSignature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.PROCEDURE_PARAMETER: {
				ProcedureParameter procedureParameter = (ProcedureParameter)theEObject;
				T result = caseProcedureParameter(procedureParameter);
				if (result == null) result = caseParameter(procedureParameter);
				if (result == null) result = caseNamedElement(procedureParameter);
				if (result == null) result = caseElement(procedureParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COLLECTION_DATA_TYPE: {
				CollectionDataType collectionDataType = (CollectionDataType)theEObject;
				T result = caseCollectionDataType(collectionDataType);
				if (result == null) result = caseDataType(collectionDataType);
				if (result == null) result = caseMappableDataElement(collectionDataType);
				if (result == null) result = casePackageableElement(collectionDataType);
				if (result == null) result = caseNamedElement(collectionDataType);
				if (result == null) result = caseElement(collectionDataType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.COLLECTION_DATA_INSTANCE: {
				CollectionDataInstance collectionDataInstance = (CollectionDataInstance)theEObject;
				T result = caseCollectionDataInstance(collectionDataInstance);
				if (result == null) result = caseDataInstance(collectionDataInstance);
				if (result == null) result = caseMappableDataElement(collectionDataInstance);
				if (result == null) result = casePackageableElement(collectionDataInstance);
				if (result == null) result = caseNamedElement(collectionDataInstance);
				if (result == null) result = caseElement(collectionDataInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.EXTENSION: {
				Extension extension = (Extension)theEObject;
				T result = caseExtension(extension);
				if (result == null) result = caseElement(extension);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.LITERAL_VALUE_USE: {
				LiteralValueUse literalValueUse = (LiteralValueUse)theEObject;
				T result = caseLiteralValueUse(literalValueUse);
				if (result == null) result = caseStaticDataUse(literalValueUse);
				if (result == null) result = caseDataUse(literalValueUse);
				if (result == null) result = caseElement(literalValueUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.CONSTRAINT_TYPE: {
				ConstraintType constraintType = (ConstraintType)theEObject;
				T result = caseConstraintType(constraintType);
				if (result == null) result = casePackageableElement(constraintType);
				if (result == null) result = caseNamedElement(constraintType);
				if (result == null) result = caseElement(constraintType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.CONSTRAINT: {
				Constraint constraint = (Constraint)theEObject;
				T result = caseConstraint(constraint);
				if (result == null) result = caseElement(constraint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.ENUM_DATA_TYPE: {
				EnumDataType enumDataType = (EnumDataType)theEObject;
				T result = caseEnumDataType(enumDataType);
				if (result == null) result = caseSimpleDataType(enumDataType);
				if (result == null) result = caseDataType(enumDataType);
				if (result == null) result = caseMappableDataElement(enumDataType);
				if (result == null) result = casePackageableElement(enumDataType);
				if (result == null) result = caseNamedElement(enumDataType);
				if (result == null) result = caseElement(enumDataType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case tdlPackage.DATA_ELEMENT_USE: {
				DataElementUse dataElementUse = (DataElementUse)theEObject;
				T result = caseDataElementUse(dataElementUse);
				if (result == null) result = caseDataUse(dataElementUse);
				if (result == null) result = caseElement(dataElementUse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseElement(Element object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComment(Comment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotation(Annotation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotation Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotation Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotationType(AnnotationType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Packageable Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Packageable Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePackageableElement(PackageableElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedElement(NamedElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Package</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Package</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePackage(org.etsi.mts.tdl.Package object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Element Import</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Element Import</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseElementImport(ElementImport object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Test Objective</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Test Objective</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTestObjective(TestObjective object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataInstance(DataInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mappable Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mappable Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMappableDataElement(MappableDataElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataType(DataType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Resource Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Resource Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataResourceMapping(DataResourceMapping object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Element Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Element Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataElementMapping(DataElementMapping object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameterMapping(ParameterMapping object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameter(Parameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Simple Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Simple Data Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSimpleDataType(SimpleDataType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Simple Data Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Simple Data Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSimpleDataInstance(SimpleDataInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Structured Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Structured Data Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStructuredDataType(StructuredDataType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMember(Member object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Structured Data Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Structured Data Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStructuredDataInstance(StructuredDataInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemberAssignment(MemberAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Static Data Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Static Data Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStaticDataUse(StaticDataUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataUse(DataUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter Binding</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter Binding</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameterBinding(ParameterBinding object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Action</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Action</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAction(Action object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Formal Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Formal Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFormalParameter(FormalParameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunction(Function object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Formal Parameter Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Formal Parameter Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFormalParameterUse(FormalParameterUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dynamic Data Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dynamic Data Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDynamicDataUse(DynamicDataUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariable(Variable object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunctionCall(FunctionCall object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariableUse(VariableUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Component Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Component Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComponentInstance(ComponentInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Component Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Component Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComponentType(ComponentType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gate Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gate Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGateInstance(GateInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gate Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gate Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGateType(GateType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Timer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Timer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimer(Timer object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Omit Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Omit Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOmitValue(OmitValue object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Special Value Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Special Value Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSpecialValueUse(SpecialValueUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Any Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Any Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnyValue(AnyValue object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Any Value Or Omit</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Any Value Or Omit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnyValueOrOmit(AnyValueOrOmit object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Instance Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Instance Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataInstanceUse(DataInstanceUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTime(Time object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Label</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Label</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeLabel(TimeLabel object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Timer Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Timer Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimerOperation(TimerOperation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Atomic Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Atomic Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAtomicBehaviour(AtomicBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBehaviour(Behaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeConstraint(TimeConstraint object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Timer Start</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Timer Start</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimerStart(TimerStart object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Timer Stop</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Timer Stop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimerStop(TimerStop object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Out</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Out</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeOut(TimeOut object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeOperation(TimeOperation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Wait</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Wait</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWait(Wait object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Quiescence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Quiescence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQuiescence(Quiescence object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gate Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gate Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGateReference(GateReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Label Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Label Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeLabelUse(TimeLabelUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Test Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Test Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTestConfiguration(TestConfiguration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Connection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Connection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConnection(Connection object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Test Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Test Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTestDescription(TestDescription object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Behaviour Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Behaviour Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBehaviourDescription(BehaviourDescription object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBlock(Block object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Combined Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Combined Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCombinedBehaviour(CombinedBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Periodic Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Periodic Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePeriodicBehaviour(PeriodicBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Exceptional Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Exceptional Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExceptionalBehaviour(ExceptionalBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Alternative Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Alternative Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAlternativeBehaviour(AlternativeBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Multiple Combined Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Multiple Combined Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMultipleCombinedBehaviour(MultipleCombinedBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parallel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parallel Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParallelBehaviour(ParallelBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bounded Loop Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bounded Loop Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBoundedLoopBehaviour(BoundedLoopBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Single Combined Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Single Combined Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSingleCombinedBehaviour(SingleCombinedBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Optional Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Optional Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOptionalBehaviour(OptionalBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unbounded Loop Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unbounded Loop Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnboundedLoopBehaviour(UnboundedLoopBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Conditional Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Conditional Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConditionalBehaviour(ConditionalBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Compound Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Compound Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompoundBehaviour(CompoundBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Default Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Default Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDefaultBehaviour(DefaultBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Interrupt Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Interrupt Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInterruptBehaviour(InterruptBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Target</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Target</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTarget(Target object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Verdict Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Verdict Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVerdictAssignment(VerdictAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assertion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assertion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssertion(Assertion object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stop</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStop(Stop object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Break</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Break</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBreak(Break object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignment(Assignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Action Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Action Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseActionBehaviour(ActionBehaviour object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Inline Action</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Inline Action</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInlineAction(InlineAction object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Action Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Action Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseActionReference(ActionReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Test Description Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Test Description Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTestDescriptionReference(TestDescriptionReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Component Instance Binding</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Component Instance Binding</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComponentInstanceBinding(ComponentInstanceBinding object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Interaction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Interaction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInteraction(Interaction object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Message</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Message</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMessage(Message object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Predefined Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Predefined Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePredefinedFunction(PredefinedFunction object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemberReference(MemberReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Predefined Function Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Predefined Function Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePredefinedFunctionCall(PredefinedFunctionCall object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Local Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Local Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLocalExpression(LocalExpression object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Value Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Value Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseValueAssignment(ValueAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Procedure Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Procedure Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcedureCall(ProcedureCall object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Procedure Signature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Procedure Signature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcedureSignature(ProcedureSignature object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Procedure Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Procedure Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcedureParameter(ProcedureParameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Collection Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Collection Data Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCollectionDataType(CollectionDataType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Collection Data Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Collection Data Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCollectionDataInstance(CollectionDataInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Extension</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Extension</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExtension(Extension object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Literal Value Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Literal Value Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLiteralValueUse(LiteralValueUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constraint Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstraintType(ConstraintType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstraint(Constraint object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enum Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enum Data Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnumDataType(EnumDataType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Element Use</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Element Use</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataElementUse(DataElementUse object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object)
	{
		return null;
	}

} //tdlSwitch
