/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.html.HTMLConversionContext;
import org.docx4j.convert.out.html.SdtTagHandler;
import org.docx4j.jaxb.Context;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.SdtPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class SdtWriter {
    private static Logger log = LoggerFactory.getLogger(SdtWriter.class);
    private static Map<String, SdtTagHandler> handlers = new HashMap<String, SdtTagHandler>();
    static IdentityHandler identity = new IdentityHandler();

    public static void registerTagHandler(String key, SdtTagHandler handler) {
        handlers.put(key, handler);
    }

    private static Node debug(Node n) {
        String xml = XmlUtils.w3CDomNodeToString(n);
        log.debug("result: " + xml);
        return n;
    }

    public static Node toNode(HTMLConversionContext context, NodeIterator sdtPrNodeIt, NodeIterator childResults) throws TransformerException {
        SdtTagHandler handler;
        SdtPr sdtPr;
        Node result = null;
        try {
            Node n = sdtPrNodeIt.nextNode();
            sdtPr = (SdtPr)XmlUtils.unmarshal(n, Context.jc, SdtPr.class);
        }
        catch (JAXBException e1) {
            throw new TransformerException("Missing or broken w:sdtPr", e1);
        }
        log.debug("in sdt");
        if (sdtPr.getTag() == null) {
            log.debug(".. no w:tag");
            if (handlers.get("*") != null) {
                log.debug("'*' handler");
                SdtTagHandler handler2 = handlers.get("*");
                result = handler2.toNode(context.getWmlPackage(), null, null, childResults);
            } else {
                log.debug("identity handler");
                result = identity.toNode(context.getWmlPackage(), null, null, childResults);
            }
            return SdtWriter.debug(result);
        }
        HashMap<String, String> map = QueryString.parseQueryString(sdtPr.getTag().getVal(), true);
        for (String key : map.keySet()) {
            handler = handlers.get(key);
            if (handler == null) {
                log.info("No model registered for sdt tag key " + key + "; ignoring ..");
                continue;
            }
            log.debug("Using model " + handler.getClass().getName() + " for sdt tag key " + key);
            if (result == null) {
                result = handler.toNode(context.getWmlPackage(), sdtPr, map, childResults);
                continue;
            }
            result = handler.toNode(context.getWmlPackage(), sdtPr, map, result);
        }
        if (handlers.get("**") != null) {
            handler = handlers.get("**");
            log.info("applying handler '**' ");
            result = result == null ? handler.toNode(context.getWmlPackage(), sdtPr, map, childResults) : handler.toNode(context.getWmlPackage(), sdtPr, map, result);
        }
        if (result == null) {
            if (handlers.get("*") != null) {
                log.info("applying handler '*' ");
                handler = handlers.get("*");
                result = handler.toNode(context.getWmlPackage(), sdtPr, map, childResults);
            } else {
                log.info("using identity ");
                result = identity.toNode(context.getWmlPackage(), sdtPr, map, childResults);
            }
        }
        return SdtWriter.debug(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullHandler
    extends SdtTagHandler {
        NullHandler() {
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
            return this.emptyFragment();
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
            return this.emptyFragment();
        }

        private DocumentFragment emptyFragment() throws TransformerException {
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            return document.createDocumentFragment();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdentityHandler
    extends SdtTagHandler {
        IdentityHandler() {
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
            try {
                Document document = XmlUtils.getNewDocumentBuilder().newDocument();
                DocumentFragment docfrag = document.createDocumentFragment();
                return this.attachContents(docfrag, (Node)docfrag, childResults);
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
            try {
                Document document = XmlUtils.getNewDocumentBuilder().newDocument();
                DocumentFragment docfrag = document.createDocumentFragment();
                return this.attachContents(docfrag, (Node)docfrag, resultSoFar);
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }
    }
}

