/**
 */
package org.etsi.mts.tdl.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.tdlPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Block</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.etsi.mts.tdl.impl.BlockImpl#getBehaviour <em>Behaviour</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.BlockImpl#getGuard <em>Guard</em>}</li>
 * </ul>
 *
 * @generated
 */
public class BlockImpl extends ElementImpl implements Block
{
	/**
	 * The cached value of the '{@link #getBehaviour() <em>Behaviour</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehaviour()
	 * @generated
	 * @ordered
	 */
	protected EList<Behaviour> behaviour;

	/**
	 * The cached value of the '{@link #getGuard() <em>Guard</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGuard()
	 * @generated
	 * @ordered
	 */
	protected EList<LocalExpression> guard;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return tdlPackage.Literals.BLOCK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Behaviour> getBehaviour()
	{
		if (behaviour == null) {
			behaviour = new EObjectContainmentEList<Behaviour>(Behaviour.class, this, tdlPackage.BLOCK__BEHAVIOUR);
		}
		return behaviour;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LocalExpression> getGuard()
	{
		if (guard == null) {
			guard = new EObjectContainmentEList<LocalExpression>(LocalExpression.class, this, tdlPackage.BLOCK__GUARD);
		}
		return guard;
	}

	/**
	 * The cached invocation delegate for the '{@link #getParticipatingComponents() <em>Get Participating Components</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParticipatingComponents()
	 * @generated
	 * @ordered
	 */
	protected static final EOperation.Internal.InvocationDelegate GET_PARTICIPATING_COMPONENTS__EINVOCATION_DELEGATE = ((EOperation.Internal)tdlPackage.Literals.BLOCK___GET_PARTICIPATING_COMPONENTS).getInvocationDelegate();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<ComponentInstance> getParticipatingComponents()
	{
		try {
			return (EList<ComponentInstance>)GET_PARTICIPATING_COMPONENTS__EINVOCATION_DELEGATE.dynamicInvoke(this, null);
		}
		catch (InvocationTargetException ite) {
			throw new WrappedException(ite);
		}
	}

	/**
	 * The cached invocation delegate for the '{@link #getParticipatingComponentsExcluding(org.etsi.mts.tdl.Behaviour) <em>Get Participating Components Excluding</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParticipatingComponentsExcluding(org.etsi.mts.tdl.Behaviour)
	 * @generated
	 * @ordered
	 */
	protected static final EOperation.Internal.InvocationDelegate GET_PARTICIPATING_COMPONENTS_EXCLUDING_BEHAVIOUR__EINVOCATION_DELEGATE = ((EOperation.Internal)tdlPackage.Literals.BLOCK___GET_PARTICIPATING_COMPONENTS_EXCLUDING__BEHAVIOUR).getInvocationDelegate();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<ComponentInstance> getParticipatingComponentsExcluding(Behaviour excluded)
	{
		try {
			return (EList<ComponentInstance>)GET_PARTICIPATING_COMPONENTS_EXCLUDING_BEHAVIOUR__EINVOCATION_DELEGATE.dynamicInvoke(this, new BasicEList.UnmodifiableEList<Object>(1, new Object[]{excluded}));
		}
		catch (InvocationTargetException ite) {
			throw new WrappedException(ite);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID) {
			case tdlPackage.BLOCK__BEHAVIOUR:
				return ((InternalEList<?>)getBehaviour()).basicRemove(otherEnd, msgs);
			case tdlPackage.BLOCK__GUARD:
				return ((InternalEList<?>)getGuard()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID) {
			case tdlPackage.BLOCK__BEHAVIOUR:
				return getBehaviour();
			case tdlPackage.BLOCK__GUARD:
				return getGuard();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID) {
			case tdlPackage.BLOCK__BEHAVIOUR:
				getBehaviour().clear();
				getBehaviour().addAll((Collection<? extends Behaviour>)newValue);
				return;
			case tdlPackage.BLOCK__GUARD:
				getGuard().clear();
				getGuard().addAll((Collection<? extends LocalExpression>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID) {
			case tdlPackage.BLOCK__BEHAVIOUR:
				getBehaviour().clear();
				return;
			case tdlPackage.BLOCK__GUARD:
				getGuard().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID) {
			case tdlPackage.BLOCK__BEHAVIOUR:
				return behaviour != null && !behaviour.isEmpty();
			case tdlPackage.BLOCK__GUARD:
				return guard != null && !guard.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
	{
		switch (operationID) {
			case tdlPackage.BLOCK___GET_PARTICIPATING_COMPONENTS:
				return getParticipatingComponents();
			case tdlPackage.BLOCK___GET_PARTICIPATING_COMPONENTS_EXCLUDING__BEHAVIOUR:
				return getParticipatingComponentsExcluding((Behaviour)arguments.get(0));
		}
		return super.eInvoke(operationID, arguments);
	}

} //BlockImpl
