/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.html.SdtTagHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.SdtPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagClass
extends SdtTagHandler {
    private static Logger log = LoggerFactory.getLogger(TagClass.class);

    private Element createDiv(Document document, DocumentFragment docfrag, SdtPr sdtPr, HashMap<String, String> tagMap) throws ParserConfigurationException, IOException, SAXException {
        String classVal = tagMap.get("@class");
        String sdtId = "??";
        if (sdtPr.getId() != null) {
            sdtId = sdtPr.getId().getVal().toString();
        }
        String sdtAlias = "??";
        SdtPr.Alias alias = this.getAlias(sdtPr);
        if (alias != null) {
            sdtAlias = alias.getVal();
        }
        if (classVal.equals("collapse")) {
            XmlUtils.appendXmlFragment(document, docfrag, "<p style=\"padding-left: 30px;\"><a onmousedown=\"toggleDiv('t" + sdtId + "');\" href=\"javascript:;\">Toggle:" + sdtAlias + "</a></p>");
        }
        Element xhtmlDiv = document.createElement("div");
        docfrag.appendChild(xhtmlDiv);
        xhtmlDiv.setAttribute("class", tagMap.get("@class"));
        if (classVal.equals("collapse")) {
            xhtmlDiv.setAttribute("id", "t" + sdtId);
            if (tagMap.get("display") != null && tagMap.get("display").equals("block")) {
                xhtmlDiv.setAttribute("style", "display: block;");
            } else {
                xhtmlDiv.setAttribute("style", "display: none;");
            }
        }
        return xhtmlDiv;
    }

    @Override
    public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
        try {
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            DocumentFragment docfrag = document.createDocumentFragment();
            Element xhtmlDiv = this.createDiv(document, docfrag, sdtPr, tagMap);
            return this.attachContents(docfrag, (Node)xhtmlDiv, childResults);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
    }

    @Override
    public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
        try {
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            DocumentFragment docfrag = document.createDocumentFragment();
            Element xhtmlDiv = this.createDiv(document, docfrag, sdtPr, tagMap);
            return this.attachContents(docfrag, (Node)xhtmlDiv, resultSoFar);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
    }
}

