package org.etsi.mts.tdl.execution.java.tri;

import java.util.Collection;
import java.util.List;

/**
 * Representation of a TDL model element of class <i>DataType</i> and its
 * sub-classes.
 */
public interface Type extends NamedElement {

	/**
	 * If this type is a structure.
	 * 
	 * @return <b>true</b> if this type represents a <i>StructureDataType</i>
	 *         element.
	 */
	boolean isStructure();

	/**
	 * If this type is a collection.
	 * 
	 * @return <b>true</b> if this type represents a <i>CollectionDataType</i>
	 *         element.
	 */
	boolean isCollection();

	/**
	 * If this type is an enum.
	 * 
	 * @return <b>true</b> if this type represents a <i>EnumDataType</i> element.
	 */
	boolean isEnum();

	/**
	 * Get the data mapping chosen for the runtime. The mapping that is chosen is
	 * implementation specific.
	 * 
	 * @return A <code>Mapping</code> representing a <i>DataElementMapping</i>
	 *         element.
	 */
	Mapping getMapping();

	/**
	 * Get the names of members of this structured type. Includes all inherited
	 * members as well.
	 * 
	 * @return Collection of names from the <i>Member</i> elements contained or
	 *         inherited in the corresponding <i>StructuredDataType</i> element.
	 */
	Collection<String> getParameters();

	/**
	 * Get the type of a parameter.
	 * 
	 * @param parameterName Name of the parameter as returned by
	 *                      {@link #getParameters() getParameters()}.
	 * @return The <code>Type</code> of the parameter representing the
	 *         <i>DataType</i> of the <i>Member</i> element corresponding to the
	 *         parameter.
	 */
	Type getParameterType(String parameterName);

	/**
	 * Get the type of items of this collection type.
	 * 
	 * @return The <code>Type</code> of the items contained in a collection of this
	 *         <code>Type</code>.
	 */
	Type getItemType();

	/**
	 * Get the literal values of this enumerated type.
	 * 
	 * @return The <code>Data</code> objects representing the
	 *         <i>SimpleDataInstance</i> elements contained in the corresponding
	 *         <i>EnumDataType</i> element.
	 */
	List<Data<Type, Value>> getEnumLiterals();
}
