/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import java.util.HashMap;
import java.util.List;
import org.docx4j.model.listnumbering.ListLevel;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.Numbering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractListNumberingDefinition {
    protected static Logger log = LoggerFactory.getLogger(AbstractListNumberingDefinition.class);
    private HashMap<String, ListLevel> listLevels;
    private Numbering.AbstractNum abstractNumNode;
    private String linkedStyleId;
    private String abstractNumDefId;

    public Numbering.AbstractNum getAbstractNumNode() {
        return this.abstractNumNode;
    }

    public AbstractListNumberingDefinition(Numbering.AbstractNum abstractNumNode) {
        this.abstractNumNode = abstractNumNode;
        String abstractNumString = abstractNumNode.getAbstractNumId().toString();
        if (abstractNumString != null && !abstractNumString.equals("")) {
            this.abstractNumDefId = abstractNumString;
            this.readListLevelsFromAbsNode(abstractNumNode);
            Numbering.AbstractNum.NumStyleLink linkedStyleNode = abstractNumNode.getNumStyleLink();
            if (linkedStyleNode != null) {
                this.linkedStyleId = linkedStyleNode.getVal();
            }
        }
    }

    public void updateDefinitionFromLinkedStyle(Numbering.AbstractNum linkedNode) {
        if (!this.hasLinkedStyle()) {
            return;
        }
        this.readListLevelsFromAbsNode(linkedNode);
    }

    private void readListLevelsFromAbsNode(Numbering.AbstractNum abstractNumNode) {
        List<Lvl> levelNodes = abstractNumNode.getLvl();
        if (this.listLevels == null) {
            this.listLevels = new HashMap(levelNodes.size());
        }
        for (Lvl levelNode : levelNodes) {
            ListLevel level = new ListLevel(levelNode);
            this.listLevels.put(level.getID(), level);
        }
    }

    public String getLinkedStyleId() {
        return this.linkedStyleId;
    }

    public boolean hasLinkedStyle() {
        return this.linkedStyleId != null && !this.linkedStyleId.equals("");
    }

    public String getID() {
        return this.abstractNumDefId;
    }

    public HashMap<String, ListLevel> getListLevels() {
        return this.listLevels;
    }

    public int getLevelCount() {
        if (this.listLevels != null) {
            return this.listLevels.size();
        }
        return 0;
    }
}

