package org.etsi.mts.tdl.execution.java.tri;

/**
 * Helper functions to provide environment specific implementation for various
 * operations.
 */
public interface RuntimeHelper {
	/**
	 * Compare two objects. Can be used to implement deep equals operation for
	 * {@link Data Data} objects.
	 * 
	 * @return <code>True</code> if objects are equal.
	 */
	boolean equals(Object o0, Object o1);

	/**
	 * Create a copy of an object. Can be used to implement deep clone of
	 * {@link Data Data} objects.
	 */
	<T> T clone(T object);
}
