package org.etsi.mts.tdl.execution.java.rt.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import org.etsi.mts.tdl.execution.java.tri.Parameter;
import org.etsi.mts.tdl.execution.java.tri.Procedure;

/**
 * May optionally be mapped to a method that implements the calling of the
 * procedure
 */
public class ProcedureImpl extends NamedElementImpl implements Procedure {

	private List<ParameterImpl> in = new ArrayList<ParameterImpl>();
	private List<ParameterImpl> out = new ArrayList<ParameterImpl>();
	private List<ParameterImpl> exception = new ArrayList<ParameterImpl>();

	private Consumer<Object[]> function;
	
	public ProcedureImpl addIn(ParameterImpl p) {
		this.in.add(p);
		return this;
	}

	public ProcedureImpl addOut(ParameterImpl p) {
		this.out.add(p);
		return this;
	}

	public ProcedureImpl addException(ParameterImpl p) {
		this.exception.add(p);
		return this;
	}

	@Override
	public List<Parameter> getIn() {
		return (List)in;
	}

	@Override
	public List<Parameter> getOut() {
		return (List)out;
	}

	@Override
	public List<Parameter> getException() {
		return (List)exception;
	}

	/**
	 * Optional function that implements this procedure call.
	 * <p>
	 * The function parameters must match the order and types of parameters of the
	 * procedure call. That is, for each parameter of a procedure call, a method
	 * parameter must exist such that the procedure call parameter type is mapped to
	 * the method parameter type (or class).
	 */
	public void setFunction(Consumer<Object[]> function) {
		this.function = function;
	}
	public Consumer<Object[]> getFunction() {
		return function;
	}
}
