package org.etsi.mts.tdl.project;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PropertyPage extends FieldEditorPreferencePage implements IWorkbenchPropertyPage {

	public static final String PREFERENCE_SCOPE = "org.etsi.mts.tdl.project";

	private static final List<String> REQUIRED_SETTINGS = Arrays.asList(new String[] { /* TODO */ });

	protected IAdaptable element;

	protected Map<FieldEditor, String> fields = new Hashtable<FieldEditor, String>();

	public PropertyPage() {
		super(GRID);
	}

	@Override
	public IAdaptable getElement() {
		return element;
	}

	@Override
	public void setElement(IAdaptable element) {
		this.element = element;
	}

	@Override
	protected IPreferenceStore doGetPreferenceStore() {
		ProjectScope ps = new ProjectScope((IProject) this.element);
		return new ScopedPreferenceStore(ps, PREFERENCE_SCOPE);
	}

	@Override
	protected void initialize() {
		for (FieldEditor e : fields.keySet()) {
			String value = getPreferenceStore().getString(e.getPreferenceName());
			fields.put(e, value);
			initialize(e.getPreferenceName(), value, e);
		}
		super.initialize();
	}

	protected void initialize(String name, String value, FieldEditor e) {
	}

	@Override
	protected void addField(FieldEditor editor) {
		super.addField(editor);
		fields.put(editor, "");
	}

	@Override
	public void propertyChange(PropertyChangeEvent event) {
		super.propertyChange(event);
		if (event.getProperty().equals(FieldEditor.VALUE)) {
			FieldEditor e = (FieldEditor) event.getSource();

			String name = e.getPreferenceName();
			String value = (String) event.getNewValue();

			fields.put(e, value);

			initialize(name, value, e);

			checkState();
		}
	}

	@Override
	protected void checkState() {
		setErrorMessage(null);
		super.checkState();
	}

	@Override
	protected void createFieldEditors() {
		// TODO
	}

	private boolean isValid(FieldEditor e) {
		String name = e.getPreferenceName();
		String value = fields.get(e);

		if (REQUIRED_SETTINGS.contains(name)) {
			if (value.isEmpty()) {
				setErrorMessage(String.format("%s must be selected!", e.getLabelText()));
				return false;
			}
		}

		return true;
	}

}