package org.etsi.mts.tdl.constraints.ui.handlers;

import java.net.URI;
import java.util.Collection;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.epsilon.evl.emf.validation.CompositeEValidator;
import org.eclipse.epsilon.evl.emf.validation.EvlValidator;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.etsi.mts.tdl.tdlPackage;

public class ToggleValidationHandler  extends AbstractHandler {
	private static boolean initialised;
	private static EvlValidator evlValidator;

	//TODO: for some reason seems to hang now..
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ScopedPreferenceStore s = new ScopedPreferenceStore(new InstanceScope(), "org.etsi.mts.tdl.constraints.ui.autoValidation");
		boolean enabled = s.getBoolean("enabled");
		//TODO: some constraints seems to be providing strange errors
		//TODO: maintain state across menu toolbar and others
		//TODO: maintain state across launches
		if (!enabled) {
			try {
				init();
				registerValidator(tdlPackage.eINSTANCE);
				enabled = true;
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			stop();
			enabled = false;
		}
		s.setValue("enabled", enabled);
		return null;
	}

	public static void stop() {
		EPackage ePackage = tdlPackage.eINSTANCE;
		EValidator existingValidator = EValidator.Registry.INSTANCE.getEValidator(ePackage);
		if (existingValidator instanceof CompositeEValidator) {
			//TODO: check for evl validators?
		    ((CompositeEValidator) existingValidator).getDelegates().remove(evlValidator);
		    Collection<EValidator> delegates = ((CompositeEValidator) existingValidator).getDelegates();
		    //TODO: make more robust
		    delegates.removeIf(d -> d instanceof EvlValidator);
		} else {
		    if (existingValidator == null) {
		        existingValidator = EObjectValidator.INSTANCE;
		    }
		    CompositeEValidator newValidator = new CompositeEValidator();
		    newValidator.getDelegates().add(existingValidator);
		    newValidator.getDelegates().add(evlValidator);
		    EValidator.Registry.INSTANCE.put(ePackage, newValidator);
		}

	}
	
	public static void init() throws Exception {
		if (initialised) {
			return;
		}
		//TODO: goes a bit in circles
		//TODO: extract into an activator or something? also as command
		//TODO: works in principle, occasionally causes hangs and strange errors though...
		System.out.println("Init EVL validator..");
		// Assuming you have generated the metamodel code
		EPackage ePackage = tdlPackage.eINSTANCE;

		// Pass a model name if your script uses it
		// Pass a valid bundle ID as it used for reporting (if not in a plugin use your project name or similar)
		
		String modelName = "TDL"; //This seems to be important! Otherwise strange hangs occur -> TDL?
		String bundleId = "org.etsi.mts.tdl.constraints";
		URI evlScriptURI = new URI("platform:/plugin/"+bundleId+"/constraints/tdl-generated-ETSI-ES-203-119-1-V1.5.1-fixed.evl");
		//TODO: try out extension point integration
		//TODO: try out fixes -> can they be in a separate module?
		//TODO: add other constraints for TO/TC
		evlValidator = new EvlValidator(
		    evlScriptURI, modelName , ePackage.getNsURI(), bundleId);

		evlValidator.setShowErrorDialog(false);
		//TODO: extract to optional on demand / auto validation
		//TODO: this brings all the epsilon dependencies here as well
		//-> effectively requires constraints to be installed.. shall be plugged in ideally..
		//-> check again extension point integration..
//		registerValidator(ePackage);
		initialised = true;
	}


	//TODO: reorganise and reuse (from TDLtxValidator, shall migrate local Validator as well) 
	private static void registerValidator(EPackage ePackage) {
		EValidator existingValidator = EValidator.Registry.INSTANCE.getEValidator(ePackage);
		if (existingValidator instanceof CompositeEValidator) {
		    ((CompositeEValidator) existingValidator).getDelegates().add(evlValidator);
		} else {
		    if (existingValidator == null) {
		        existingValidator = EObjectValidator.INSTANCE;
		    }
		    CompositeEValidator newValidator = new CompositeEValidator();
		    newValidator.getDelegates().add(existingValidator);
		    newValidator.getDelegates().add(evlValidator);
		    EValidator.Registry.INSTANCE.put(ePackage, newValidator);
		}
	}

}
