/*
 * generated by Xtext 2.25.0
 */
package org.etsi.mts.tdl.formatting2;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractJavaFormatter;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.xbase.lib.Extension;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Comment;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.ExceptionalBehaviour;
import org.etsi.mts.tdl.FormalParameter;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.Action;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.TimeConstraint;
import org.etsi.mts.tdl.TimeLabel;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.services.TDLtxGrammarAccess;

import com.google.inject.Inject;

public class TDLtxFormatterRef extends AbstractJavaFormatter {
	@Inject
	@Extension
	private TDLtxGrammarAccess _grammarAccess;
		
	//lazy short default formatting approach based on delimiters
	//TODO: it does not work with white-space delimiters
	protected void formatCustom(Element e, IFormattableDocument doc) {
		doc.prepend(e, p -> p.setNewLines(1));
		//TODO: repeated formatting doesn't work very well..

	    doc.prepend(this.textRegionExtensions.allRegionsFor(e).keyword(","), r->r.noSpace());

		List<ISemanticRegion> rbs = this.textRegionExtensions.regionFor(e).ruleCallsTo(this._grammarAccess.getBEGINRule());
		List<ISemanticRegion> res = this.textRegionExtensions.regionFor(e).ruleCallsTo(this._grammarAccess.getENDRule());
//		System.out.println(res.size());
		int i = 0;
		for (ISemanticRegion rs : rbs) {
			i++;
			ISemanticRegion re = res.get(res.size() - i);
			doc.interior(rs, re, p -> p.indent());
		}

		for (ISemanticRegion r : rbs) {
			doc.append(r, p -> p.setNewLines(1));
		}
		for (ISemanticRegion r : res) {
			doc.surround(r, p -> p.setNewLines(1));
		}
	}
	
	protected void format(org.etsi.mts.tdl.Block e, IFormattableDocument doc) {
		for (EObject m : e.eContents()) {
			if (!(m instanceof Annotation) && !(m instanceof LocalExpression)) {
				//TODO: handle nested behaviour
				doc.prepend(m, p->p.newLine());
				doc.surround(m, p->p.indent());
				doc.append(m, p->p.newLine());
			} else if (m instanceof Annotation) {
				doc.append(m, p->p.newLine());
			} else {
			}
			doc.format(m);
		}
	}

	protected void format(org.etsi.mts.tdl.Element e, IFormattableDocument doc) {
		List<ISemanticRegion> open = this.textRegionExtensions.regionFor(e).ruleCallsTo(this._grammarAccess.getBEGINRule());
		List<ISemanticRegion> close = this.textRegionExtensions.regionFor(e).ruleCallsTo(this._grammarAccess.getENDRule());
		if (!open.isEmpty()) {
			doc.append(open.get(0), p->p.newLine());
			doc.interior(open.get(0), close.get(0), p->p.indent());
		}
//		doc.interior(e, p->p.indent());
		if (e instanceof Behaviour) {
//			List<ISemanticRegion> assignments = this.textRegionExtensions.regionFor(e).assignments(this._grammarAccess.findAssignments(this._grammarAccess.getTimeConstraintFragmentRule()).toArray(new Assignment[] {}));
//			for (var a : assignments) {
//				doc.prepend(a.getPreviousSemanticRegion(), p->p.newLine());
//				doc.surround(a.getPreviousSemanticRegion(), p->p.indent());
//				doc.append(a, p->p.newLine());
//			}
			List<ISemanticRegion> features = this.textRegionExtensions.regionFor(e).features(
					tdlPackage.Literals.BEHAVIOUR__TEST_OBJECTIVE
//					tdlPackage.Literals.ATOMIC_BEHAVIOUR__TIME_CONSTRAINT, 
//					tdlPackage.Literals.ATOMIC_BEHAVIOUR__TIME_LABEL 
					);
			for (ISemanticRegion f : features) {
				//TODO: this depends on keywords..
				doc.prepend(f.getPreviousSemanticRegion(), p->p.newLine());
				doc.surround(f.getPreviousSemanticRegion(), p->p.indent());
				doc.append(f, p->p.newLine());
			}
		}
		if (e instanceof Connection) {
			doc.prepend(e, p->p.newLine());
		}
		
		
		for (EObject m : e.eContents()) {
			if (m instanceof TimeLabel ||
					m instanceof TimeConstraint //||
//					m instanceof Comment
					) { 
				doc.append(m, p->p.newLine());
			} else if (m instanceof Comment || 
					m instanceof TestObjective ||
					m instanceof ExceptionalBehaviour ||
					m instanceof PeriodicBehaviour
					) {
				doc.prepend(m, p->p.newLine());
				doc.surround(m, p->p.indent());
				doc.append(m, p->p.newLine());
			}
			doc.format(m);
		}
	}

	
	protected void format(org.etsi.mts.tdl.NamedElement e, IFormattableDocument doc) {
//		System.out.println("Formatting: "+e.getName() + " : "+e.eClass().getName());
//		doc.interior(e, p->p.indent());
		//formatCustom(e, doc);
		if (e instanceof FormalParameter) {
//			doc.surround(e, p->p.indent());
//			doc.prepend(e, p->p.setNewLines(0));
		}

		for (Comment comment : e.getComment()) {
			doc.surround(comment, p -> p.setNewLines(1));
			doc.format(comment);
		}
		for (Annotation _annotation : e.getAnnotation()) {
//			this.textRegionExtensions.regionFor(e).keyword("@") 			
			doc.append(_annotation, p -> p.setNewLines(1));
			doc.format(_annotation);
		}
//		doc.surround(this.textRegionExtensions.regionFor(e).keyword("@"), p->p.noSpace());
		for (EObject c : e.eContents()) {
			if (c instanceof NamedElement 
					|| c instanceof MemberAssignment
					|| c instanceof ParameterMapping
					|| c instanceof Comment
					|| c instanceof Connection
					) {
				//TODO: re-enable in select contexts?
				//doc.surround(c, p->p.setNewLines(1));
			    doc.prepend(this.textRegionExtensions.allRegionsFor(e).keyword(","), r->r.noSpace());

				formatCustom((Element)c, doc);
				doc.format(c);
			}
		}
		if (e instanceof TestObjective) {
			//TODO: a bit of a hack
			for (ISemanticRegion rs : this.textRegionExtensions.regionFor(e).ruleCallsTo(this._grammarAccess.getEStringRule())) {
				doc.append(rs, p -> p.setNewLines(1));
			}
		}
		if (e instanceof Action) {
			int size = ((Action)e).getFormalParameter().size();
			int i = 0;

			for (FormalParameter m :((Action) e).getFormalParameter()) {
				i++;
				doc.prepend(m, r->r.newLine());
				doc.surround(m, p->p.indent());

				if (i==size) {
					doc.append(m, p->p.newLine());
				}
				doc.format(m);
			}
		}
		if (e instanceof StructuredDataType) {
			if (!((StructuredDataType) e).getMember().isEmpty()) {
				doc.interior(
						doc.append(this.textRegionExtensions.regionFor(e).keyword("("), r->r.newLine()), 
						doc.prepend(this.textRegionExtensions.regionFor(e).keyword(")"), r->r.newLine()), 
						r->r.indent());
			}
			int size = ((StructuredDataType)e).getMember().size();
			int i = 0;

			for (Member m :((StructuredDataType) e).getMember()) {
				i++;
				doc.prepend(m, r->r.newLine());
				doc.surround(m, p->p.indent());

				if (i==size) {
					doc.append(m, p->p.newLine());
				}
				doc.format(m);
			}
		}

		if (e instanceof StructuredDataInstance) {
			int size = ((StructuredDataInstance)e).getMemberAssignment().size();
			int i = 0;
			for (MemberAssignment m : ((StructuredDataInstance)e).getMemberAssignment()) {
				i++;
				doc.prepend(m, p->p.newLine());
				doc.surround(m, p->p.indent());
//				doc.append(m, p->p.newLine());
				if (i==size) {
					doc.append(m, p->p.newLine());
				}
				doc.format(m);
			}
		}

	}

	protected void format(org.etsi.mts.tdl.Package _package, IFormattableDocument doc) {
		// TODO: format HiddenRegions around keywords, attributes, cross references,
		// etc.
//		getPreferences().getPreference(FormatterPreferenceKeys.indentation);
		//setPreference(FormatterPreferenceKeys.indentation);
		if (getPreferences() instanceof MapBasedPreferenceValues) {
			MapBasedPreferenceValues preferences = (MapBasedPreferenceValues) getPreferences();
			preferences.put(FormatterPreferenceKeys.indentation, "    ");
		}

		doc.interior(_package, p->p.indent());

//		Formatter
		org.etsi.mts.tdl.Package e = _package;
		formatCustom(e, doc);
		
		List<ISemanticRegion> dots = this.textRegionExtensions.allRegionsFor(e).keywords(".", "@", ",", "::");
		for (ISemanticRegion dot : dots) {
			doc.surround(dot, p -> p.noSpace());
		}

		for (Comment comment : _package.getComment()) {
			doc.surround(comment, p -> p.setNewLines(1));
			doc.format(comment);
		}
		for (Annotation _annotation : _package.getAnnotation()) {
			doc.surround(_annotation, p -> p.setNewLines(1));
			doc.format(_annotation);
		}
		for (PackageableElement packageableElement : _package.getPackagedElement()) {
			doc.surround(packageableElement, p -> p.setNewLines(1));
			doc.format(packageableElement);
		}
		for (ElementImport elementImport : _package.getImport()) {
			doc.surround(elementImport, p -> p.setNewLines(1));
			doc.format(elementImport);
		}
		for (org.etsi.mts.tdl.Package __package : _package.getNestedPackage()) {
			doc.format(__package);
		}
	}

	protected void format(Comment comment, IFormattableDocument doc) {
		// TODO: format HiddenRegions around keywords, attributes, cross references,
		// etc.
		doc.surround(comment, p -> p.setNewLines(1));
	}

	// TODO: implement for Annotation, ElementImport, AnnotationType, Extension,
	// TestObjective, DataResourceMapping, DataElementMapping, SimpleDataType,
	// SimpleDataInstance, StructuredDataType, StructuredDataInstance, Action,
	// Function, ComponentType, GateType, Time, TestConfiguration, TestDescription,
	// PredefinedFunction, ProcedureSignature, CollectionDataType,
	// CollectionDataInstance, ParameterMapping, Member, FormalParameter,
	// ProcedureParameter, MemberAssignment, ParameterBinding, MemberReference,
	// OmitValue, AnyValue, AnyValueOrOmit, DataInstanceUse, LiteralValueUse,
	// FormalParameterUse, FunctionCall, VariableUse, TimeLabelUse,
	// PredefinedFunctionCall, ComponentInstance, Variable, TimeLabel, GateInstance,
	// Timer, Connection, GateReference, BehaviourDescription, TimerStart,
	// TimerStop, TimeOut, Wait, Quiescence, PeriodicBehaviour,
	// AlternativeBehaviour, ParallelBehaviour, BoundedLoopBehaviour,
	// OptionalBehaviour, UnboundedLoopBehaviour, ConditionalBehaviour,
	// CompoundBehaviour, DefaultBehaviour, InterruptBehaviour, VerdictAssignment,
	// Assertion, Stop, Break, Assignment, InlineAction, ActionReference,
	// TestDescriptionReference, Interaction, Message, ProcedureCall,
	// TimeConstraint, Block, LocalExpression, ComponentInstanceBinding, Target,
	// ValueAssignment
}
