package org.etsi.mts.tdl.tools.to.docx.poi;

import java.io.File;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.common.OCLConstants;
import org.eclipse.ocl.pivot.internal.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.TPLan2StandaloneSetup;
import org.etsi.mts.tdl.impl.tdlPackageImpl;
import org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl;

import com.google.inject.Injector;

public class GeneratorApp {

	public static void main(String[] args) {
		Generator generator = new Generator();
		try {
			String filename = args[0];
			init();
			Resource resource = load(filename);
			File file = new File(filename);
			String target = file.getName()+".docx";
			generator.generate(resource, target, "TEST-RESOURCE");
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static void init() {
		tdlPackageImpl.init();
		StructuredObjectivesPackageImpl.init();
		EssentialOCLStandaloneSetup.doSetup();
		initializeValidator();
	}

	public static Resource load(String filename) {
		new org.eclipse.emf.mwe.utils.StandaloneSetup().setPlatformUri("../");
		Injector injector = new TPLan2StandaloneSetup().createInjectorAndDoEMFRegistration();
		XtextResourceSet resourceSet = injector.getInstance(XtextResourceSet.class);
		resourceSet.addLoadOption(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
		Resource resource = resourceSet.getResource(URI.createURI(filename), true);
		return resource;
	}

	public static void initializeValidator() {
	//		OCL.initialize(null);
			String oclDelegateURI = OCLConstants.OCL_DELEGATE_URI+"/Pivot";
			
		    EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put(oclDelegateURI,
		        new OCLInvocationDelegateFactory(oclDelegateURI));
		    EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put(oclDelegateURI,
		        new OCLSettingDelegateFactory(oclDelegateURI));
		    EValidator.ValidationDelegate.Registry.INSTANCE.put(oclDelegateURI,
		        new OCLValidationDelegateFactory(oclDelegateURI));
		    
	//	    EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put(oclDelegateURI, 
	//	    	new OCLSettingDelegateFactory.Global());
	//	    QueryDelegate.Factory.Registry.INSTANCE.put(oclDelegateURI, new OCLQueryDelegateFactory.Global());
		    
	}

	
}
