/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.model;

import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTShapeProperties;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.ShapeWrapper;
import org.pptx4j.pml.CTBackground;
import org.pptx4j.pml.CTPlaceholder;
import org.pptx4j.pml.GroupShape;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.Sld;
import org.pptx4j.pml.SldLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedLayout
implements Cloneable {
    protected static Logger log = LoggerFactory.getLogger(ResolvedLayout.class);
    private CTBackground bg;
    private GroupShape shapeTree;
    private int masterNumber;
    public RelationshipsPart relationships;

    public CTBackground getBg() {
        return this.bg;
    }

    public void setBg(CTBackground bg) {
        this.bg = bg;
    }

    public GroupShape getShapeTree() {
        return this.shapeTree;
    }

    public void setShapeTree(GroupShape shapeTree) {
        this.shapeTree = shapeTree;
    }

    public int getMasterNumber() {
        return this.masterNumber;
    }

    public static ResolvedLayout resolveSlideLayout(SlideLayoutPart slideLayoutPart) {
        ResolvedLayout resolvedLayout = new ResolvedLayout();
        SlideMasterPart master = slideLayoutPart.getSlideMasterPart();
        ResolvedLayout masterLayout = master.getResolvedLayout();
        Map<String, ShapeWrapper> masterPlaceholders = master.getIndexedPlaceHolders();
        if (masterLayout.getBg() != null) {
            resolvedLayout.bg = XmlUtils.deepCopy(masterLayout.getBg(), Context.jcPML);
        }
        resolvedLayout.shapeTree = ResolvedLayout.createEffectiveShapeTree(((SldLayout)slideLayoutPart.getJaxbElement()).getCSld().getSpTree(), masterPlaceholders);
        resolvedLayout.masterNumber = 1;
        return resolvedLayout;
    }

    public static ResolvedLayout resolveSlideLayout(SlidePart slidePart) {
        ResolvedLayout resolvedLayout = new ResolvedLayout();
        SlideLayoutPart layoutPart = null;
        resolvedLayout.relationships = slidePart.getRelationshipsPart();
        Relationship rel = slidePart.getRelationshipsPart().getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout");
        if (rel == null) {
            log.warn(slidePart.getPartName().getName() + " has no explicit layout!");
            Map<String, ShapeWrapper> globalPlaceHolders = ((PresentationMLPackage)slidePart.getPackage()).getPlaceHoldersFromAcrossLayouts();
            resolvedLayout.shapeTree = ResolvedLayout.createEffectiveShapeTree(((Sld)slidePart.getJaxbElement()).getCSld().getSpTree(), globalPlaceHolders);
        } else {
            layoutPart = (SlideLayoutPart)slidePart.getRelationshipsPart().getPart(rel);
            resolvedLayout.shapeTree = ResolvedLayout.createEffectiveShapeTree(((Sld)slidePart.getJaxbElement()).getCSld().getSpTree(), layoutPart.getIndexedPlaceHolders());
        }
        resolvedLayout.masterNumber = 1;
        return resolvedLayout;
    }

    public static GroupShape createEffectiveShapeTree(GroupShape shapeTree, Map<String, ShapeWrapper> placeholders) {
        GroupShape effectiveShapeTree = XmlUtils.deepCopy(shapeTree, Context.jcPML);
        List<Object> possiblyShapes = effectiveShapeTree.getSpOrGrpSpOrGraphicFrame();
        for (Object o : possiblyShapes) {
            Shape sp;
            if (!(o instanceof Shape) || (sp = (Shape)o).getNvSpPr() == null || sp.getNvSpPr().getNvPr() == null || sp.getNvSpPr().getNvPr().getPh() == null) continue;
            CTPlaceholder placeholder = sp.getNvSpPr().getNvPr().getPh();
            String placeholderType = placeholder.getType().toString();
            log.info("Handling placeholder: " + placeholderType);
            ResolvedLayout.handle(placeholders, placeholderType, sp);
        }
        return effectiveShapeTree;
    }

    private static void handle(Map<String, ShapeWrapper> placeholders, String placeholderType, Shape sp) {
        Shape layoutShape = null;
        if (placeholders.get(placeholderType) == null) {
            log.debug("Missing..");
            return;
        }
        log.debug("Got it..");
        layoutShape = placeholders.get(placeholderType).getSp();
        ResolvedLayout.handleNvSpPr(sp.getNvSpPr(), layoutShape.getNvSpPr());
        ResolvedLayout.handleSpPr(sp.getSpPr(), layoutShape.getSpPr());
        ResolvedLayout.handleTxBody(sp.getTxBody(), layoutShape.getTxBody());
    }

    private static void handleNvSpPr(Shape.NvSpPr sp, Shape.NvSpPr layoutShape) {
    }

    private static void handleSpPr(CTShapeProperties sp, CTShapeProperties layoutShape) {
        if (sp.getXfrm() == null && layoutShape.getXfrm() != null) {
            sp.setXfrm(XmlUtils.deepCopy(layoutShape.getXfrm(), Context.jcPML));
        }
    }

    private static void handleTxBody(CTTextBody sp, CTTextBody layoutShape) {
        if (sp.getLstStyle() != null) {
            log.warn("Slide shape contains lstStyle! (Not expected at that level)");
            log.debug(XmlUtils.marshaltoString(sp.getLstStyle(), false, true, Context.jcPML, "FIXME", "lstStyle", CTTextListStyle.class));
        }
        if (layoutShape.getLstStyle() != null) {
            sp.setLstStyle(XmlUtils.deepCopy(layoutShape.getLstStyle(), Context.jcPML));
        }
    }

    protected ResolvedLayout clone() throws CloneNotSupportedException {
        ResolvedLayout clone = (ResolvedLayout)super.clone();
        if (this.bg != null) {
            clone.bg = XmlUtils.deepCopy(this.bg, Context.jcPML);
        }
        if (this.shapeTree != null) {
            clone.shapeTree = XmlUtils.deepCopy(this.shapeTree, Context.jcPML);
        }
        return clone;
    }
}

