package org.etsi.mts.tdl.execution.java.rt.core;

import java.util.Collection;

import org.etsi.mts.tdl.execution.java.tri.Data;
import org.etsi.mts.tdl.execution.java.tri.PredefinedFunctions;
import org.etsi.mts.tdl.execution.java.tri.Value;

import com.google.inject.Inject;

/**
 * Default implementation of predefined functions specified in TDL.
 */
public class PredefinedFunctionsImpl implements PredefinedFunctions {

	@Inject
	public PredefinedFunctionsImpl() {
	}

	@Override
	public boolean equals(Data<?, ?> d0, Data<?, ?> d1) {
		Object v0 = d0.getValue();
		Object v1 = d1.getValue();
		if (v0 == null)
			return v1 == null;
		return v0.equals(v1);
	}

	@Override
	public boolean notEquals(Data<?, ?> d0, Data<?, ?> d1) {
		return !equals(d0, d1);
	}

	@Override
	public boolean and(boolean b0, boolean b1) {
		return b0 && b1;
	}

	@Override
	public boolean or(boolean b0, boolean b1) {
		return b0 || b1;
	}

	@Override
	public boolean xor(boolean b0, boolean b1) {
		return b0 ^ b1;
	}

	@Override
	public boolean not(boolean b) {
		return !b;
	}

	@Override
	public boolean lt(int i0, int i1) {
		return i0 < i1;
	}

	@Override
	public boolean gt(int i0, int i1) {
		return i0 > i1;
	}

	@Override
	public boolean lteq(int i0, int i1) {
		return i0 <= i1;
	}

	@Override
	public boolean gteq(int i0, int i1) {
		return i0 >= i1;
	}

	@Override
	public boolean lt(long i0, long i1) {
		return i0 < i1;
	}

	@Override
	public boolean gt(long i0, long i1) {
		return i0 > i1;
	}

	@Override
	public boolean lteq(long i0, long i1) {
		return i0 <= i1;
	}

	@Override
	public boolean gteq(long i0, long i1) {
		return i0 >= i1;
	}

	@Override
	public int plus(int i0, int i1) {
		return i0 + i1;
	}

	@Override
	public int minus(int i0, int i1) {
		return i0 - i1;
	}

	@Override
	public int multiply(int i0, int i1) {
		return i0 * i1;
	}

	@Override
	public int divide(int i0, int i1) {
		return i0 / i1;
	}

	@Override
	public int mod(int i0, int i1) {
		return i0 % i1;
	}

	@Override
	public long plus(long i0, long i1) {
		return i0 + i1;
	}

	@Override
	public long minus(long i0, long i1) {
		return i0 - i1;
	}

	@Override
	public long multiply(long i0, long i1) {
		return i0 * i1;
	}

	@Override
	public long divide(long i0, long i1) {
		return i0 / i1;
	}

	@Override
	public long mod(long i0, long i1) {
		return i0 % i1;
	}

	@Override
	public int size(Data<?, ?> collection) {
		Object v = collection.getValue();
		if (v instanceof Collection<?>)
			return ((Collection<?>) v).size();
		if (v instanceof Value)
			if (((Value) v).isCollection())
				return ((Value) v).getItems().size();
		throw new IllegalArgumentException("Argument is not a collection.");
	}

}
