/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import java.math.BigInteger;
import org.docx4j.model.PropertyResolver;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emulator {
    protected static Logger log = LoggerFactory.getLogger(Emulator.class);

    public static ResultTriple getNumber(WordprocessingMLPackage wmlPackage, PPr pPr) {
        if (pPr == null) {
            return null;
        }
        String pStyleVal = null;
        if (pPr.getPStyle() != null) {
            pStyleVal = pPr.getPStyle().getVal();
        }
        String numIdStr = null;
        String levelIdStr = null;
        if (pPr.getNumPr() != null) {
            BigInteger levelId;
            BigInteger numId;
            if (pPr.getNumPr().getNumId() != null && (numId = pPr.getNumPr().getNumId().getVal()) != null) {
                numIdStr = numId.toString();
            }
            if (pPr.getNumPr().getIlvl() != null && (levelId = pPr.getNumPr().getIlvl().getVal()) != null) {
                levelIdStr = levelId.toString();
            }
        }
        return Emulator.getNumber(wmlPackage, pStyleVal, numIdStr, levelIdStr);
    }

    public static ResultTriple getNumber(WordprocessingMLPackage wmlPackage, String pStyleVal, String numId, String levelId) {
        NumberingDefinitionsPart numberingPart = wmlPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        if (numberingPart == null) {
            return null;
        }
        Emulator em = numberingPart.getEmulator();
        ResultTriple triple = em.new ResultTriple();
        StyleDefinitionsPart stylesPart = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart();
        PropertyResolver propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
        if (numId == null || numId.equals("")) {
            Style style = null;
            if (pStyleVal == null || pStyleVal.equals("")) {
                log.debug("no explicit numId; no style either");
                return null;
            }
            log.debug("no explicit numId; looking in styles");
            style = propertyResolver.getStyle(pStyleVal);
            if (style == null) {
                log.debug("Couldn't find style '" + pStyleVal + "'");
                return null;
            }
            if (style.getPPr() == null) {
                log.debug("Style '" + pStyleVal + "' has no pPr");
                return null;
            }
            PPrBase.NumPr numPr = style.getPPr().getNumPr();
            if (numPr == null) {
                log.debug("Couldn't get NumPr from " + pStyleVal);
                return null;
            }
            if (numPr.getNumId() == null) {
                log.debug("NumPr element has no numId");
                if (pStyleVal == null) {
                    return null;
                }
                log.debug(pStyleVal + ".. use propertyResolver to follow basedOn");
                PPr ppr = propertyResolver.getEffectivePPr(pStyleVal);
                numPr = ppr.getNumPr();
                if (numPr == null) {
                    log.debug(pStyleVal + "NumPr element still has no numId (basedOn didn't help)");
                    return null;
                }
                log.info("Got numId: " + numPr.getNumId());
            }
            if (numPr.getNumId() == null) {
                log.error("numId was null!");
                return null;
            }
            numId = numPr.getNumId().getVal().toString();
            if (numId.equals("")) {
                log.error("numId was empty!");
                return null;
            }
            if (levelId == null || levelId.equals("")) {
                if (numPr.getIlvl() != null) {
                    levelId = numPr.getIlvl().getVal().toString();
                    log.info("levelId=" + levelId + " (from style)");
                } else {
                    levelId = "0";
                }
            }
        }
        log.debug("Using numId: " + numId);
        if (levelId == null || levelId.equals("")) {
            log.warn("No level id?! Default to 0.");
            levelId = "0";
        }
        if (numberingPart.getInstanceListDefinitions().containsKey(numId) && numberingPart.getInstanceListDefinitions().get(numId).LevelExists(levelId)) {
            numberingPart.getInstanceListDefinitions().get(numId).IncrementCounter(levelId);
            triple.numString = numberingPart.getInstanceListDefinitions().get(numId).GetCurrentNumberString(levelId);
            log.debug("Got number: " + triple.numString);
            String font = numberingPart.getInstanceListDefinitions().get(numId).GetFont(levelId);
            if (font != null && !font.equals("")) {
                triple.numFont = font;
            }
            if (numberingPart.getInstanceListDefinitions().get(numId).IsBullet(levelId)) {
                triple.bullet = numberingPart.getInstanceListDefinitions().get(numId).getLevel(levelId).getLevelText();
            }
            triple.lvl = numberingPart.getInstanceListDefinitions().get(numId).getLevel(levelId).getJaxbAbstractLvl();
            PPr ppr = triple.getLvl().getPPr();
            if (ppr != null) {
                triple.ind = ppr.getInd();
            }
            triple.rPr = triple.getLvl().getRPr();
        } else if (!numberingPart.getInstanceListDefinitions().containsKey(numId)) {
            if (numId.equals("0")) {
                log.debug("Couldn't find list " + numId);
            } else {
                log.warn("Couldn't find list " + numId);
            }
        } else if (!numberingPart.getInstanceListDefinitions().get(numId).LevelExists(levelId)) {
            log.error("Couldn't find level " + levelId + " in list " + numId);
        }
        return triple;
    }

    public static PPrBase.Ind getInd(WordprocessingMLPackage wmlPackage, String pStyleVal, String numId, String levelId) {
        NumberingDefinitionsPart numberingPart = wmlPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        if (numberingPart == null) {
            return null;
        }
        StyleDefinitionsPart stylesPart = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart();
        PropertyResolver propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
        if (numId == null || numId.equals("")) {
            Style style = null;
            if (pStyleVal == null || pStyleVal.equals("")) {
                log.debug("no explicit numId; no style either");
                return null;
            }
            log.debug("no explicit numId; looking in styles");
            style = propertyResolver.getStyle(pStyleVal);
            if (style == null) {
                log.debug("Couldn't find style '" + pStyleVal + "'");
                return null;
            }
            if (style.getPPr() == null) {
                log.debug("Style '" + pStyleVal + "' has no pPr");
                return null;
            }
            PPrBase.NumPr numPr = style.getPPr().getNumPr();
            if (numPr == null) {
                log.debug("Couldn't get NumPr from " + pStyleVal);
                return null;
            }
            if (numPr.getNumId() == null) {
                log.debug("NumPr element has no numId");
                if (pStyleVal == null) {
                    return null;
                }
                log.debug(pStyleVal + ".. use propertyResolver to follow basedOn");
                PPr ppr = propertyResolver.getEffectivePPr(pStyleVal);
                numPr = ppr.getNumPr();
                if (numPr == null) {
                    log.debug(pStyleVal + "NumPr element still has no numId (basedOn didn't help)");
                    return null;
                }
                log.info("Got numId: " + numPr.getNumId());
            }
            if (numPr.getNumId() == null) {
                log.error("numId was null!");
                return null;
            }
            numId = numPr.getNumId().getVal().toString();
            if (numId.equals("")) {
                log.error("numId was empty!");
                return null;
            }
            if (levelId == null || levelId.equals("")) {
                if (numPr.getIlvl() != null) {
                    levelId = numPr.getIlvl().getVal().toString();
                    log.info("levelId=" + levelId + " (from style)");
                } else {
                    levelId = "0";
                }
            }
        }
        log.debug("Using numId: " + numId);
        if (levelId == null || levelId.equals("")) {
            log.warn("No level id?! Default to 0.");
            levelId = "0";
        }
        if (numberingPart.getInstanceListDefinitions().containsKey(numId) && numberingPart.getInstanceListDefinitions().get(numId).LevelExists(levelId)) {
            Lvl lvl = numberingPart.getInstanceListDefinitions().get(numId).getLevel(levelId).getJaxbAbstractLvl();
            PPr ppr = lvl.getPPr();
            if (ppr == null) {
                return null;
            }
            return ppr.getInd();
        }
        return null;
    }

    public class ResultTriple {
        String numString;
        String numFont;
        String bullet = null;
        PPrBase.Ind ind = null;
        RPr rPr;
        Lvl lvl;

        public String getNumString() {
            return this.numString;
        }

        @Deprecated
        public String getNumFont() {
            return this.numFont;
        }

        public String getBullet() {
            return this.bullet;
        }

        @Deprecated
        public PPrBase.Ind getIndent() {
            return this.ind;
        }

        public RPr getRPr() {
            return this.rPr;
        }

        public Lvl getLvl() {
            return this.lvl;
        }
    }
}

