/**
 */
package org.etsi.mts.tdl.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.IdResolver.IdResolverExtension;
import org.eclipse.ocl.pivot.library.collection.CollectionAsOrderedSetOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionIncludingOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsSetOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.BagValue.Accumulator;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.etsi.mts.tdl.AtomicBehaviour;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.Interaction;
import org.etsi.mts.tdl.Target;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.tdlTables;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interaction</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.etsi.mts.tdl.impl.InteractionImpl#getSourceGate <em>Source Gate</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.InteractionImpl#getTarget <em>Target</em>}</li>
 * </ul>
 *
 * @generated
 */
public class InteractionImpl extends AtomicBehaviourImpl implements Interaction
{
	/**
	 * The cached value of the '{@link #getSourceGate() <em>Source Gate</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceGate()
	 * @generated
	 * @ordered
	 */
	protected GateReference sourceGate;

	/**
	 * The cached value of the '{@link #getTarget() <em>Target</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTarget()
	 * @generated
	 * @ordered
	 */
	protected EList<Target> target;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return tdlPackage.Literals.INTERACTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GateReference getSourceGate()
	{
		if (sourceGate != null && sourceGate.eIsProxy()) {
			InternalEObject oldSourceGate = (InternalEObject)sourceGate;
			sourceGate = (GateReference)eResolveProxy(oldSourceGate);
			if (sourceGate != oldSourceGate) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, tdlPackage.INTERACTION__SOURCE_GATE, oldSourceGate, sourceGate));
			}
		}
		return sourceGate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GateReference basicGetSourceGate()
	{
		return sourceGate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSourceGate(GateReference newSourceGate)
	{
		GateReference oldSourceGate = sourceGate;
		sourceGate = newSourceGate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, tdlPackage.INTERACTION__SOURCE_GATE, oldSourceGate, sourceGate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Target> getTarget()
	{
		if (target == null) {
			target = new EObjectContainmentEList<Target>(Target.class, this, tdlPackage.INTERACTION__TARGET);
		}
		return target;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<ComponentInstance> getParticipatingComponents()
	{
		/**
		 *
		 * if
		 *   self.getParentTestDescription()
		 *   ->exists(td | td.isLocallyOrdered)
		 * then
		 *   self.target->collect(targetGate.component)
		 *   ->including(sourceGate.component)
		 *   ->asOrderedSet()
		 * else
		 *   self.getParentTestDescription()
		 *   .testConfiguration.componentInstance->asOrderedSet()
		 * endif
		 */
		final /*@NonInvalid*/ Executor executor = PivotUtil.getExecutor(this);
		final /*@NonInvalid*/ IdResolver idResolver = executor.getIdResolver();
		final /*@NonInvalid*/ TestDescription getParentTestDescription = this.getParentTestDescription();
		final /*@NonInvalid*/ SetValue oclAsSet = OclAnyOclAsSetOperation.INSTANCE.evaluate(executor, tdlTables.SET_CLSSid_TestDescription, getParentTestDescription);
		/*@Thrown*/ Object accumulator = ValueUtil.FALSE_VALUE;
		Iterator<Object> ITERATOR_td = oclAsSet.iterator();
		/*@NonInvalid*/ Boolean exists;
		while (true) {
			if (!ITERATOR_td.hasNext()) {
				if (accumulator == ValueUtil.FALSE_VALUE) {
					exists = ValueUtil.FALSE_VALUE;
				}
				else {
					throw (InvalidValueException)accumulator;
				}
				break;
			}
			/*@NonInvalid*/ TestDescription td = (TestDescription)ITERATOR_td.next();
			/**
			 * td.isLocallyOrdered
			 */
			final /*@NonInvalid*/ boolean isLocallyOrdered = td.isIsLocallyOrdered();
			//
			if (isLocallyOrdered) {					// Normal successful body evaluation result
				exists = ValueUtil.TRUE_VALUE;
				break;														// Stop immediately
			}
			else if (!isLocallyOrdered) {				// Normal unsuccessful body evaluation result
				;															// Carry on
			}
			else {															// Impossible badly typed result
				accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "exists");
			}
		}
		if (exists == null) {
			throw new InvalidValueException("Null if condition");
		}
		/*@NonInvalid*/ OrderedSetValue local_0;
		if (exists) {
			final /*@NonInvalid*/ List<Target> target = this.getTarget();
			final /*@NonInvalid*/ SetValue BOXED_target = idResolver.createSetOfAll(tdlTables.SET_CLSSid_Target, target);
			/*@Thrown*/ Accumulator accumulator_0 = ValueUtil.createBagAccumulatorValue(tdlTables.BAG_CLSSid_ComponentInstance);
			Iterator<Object> ITERATOR__1 = BOXED_target.iterator();
			/*@NonInvalid*/ BagValue collect;
			while (true) {
				if (!ITERATOR__1.hasNext()) {
					collect = accumulator_0;
					break;
				}
				/*@NonInvalid*/ Target _1 = (Target)ITERATOR__1.next();
				/**
				 * targetGate.component
				 */
				final /*@NonInvalid*/ GateReference targetGate = _1.getTargetGate();
				final /*@NonInvalid*/ ComponentInstance component = targetGate.getComponent();
				//
				accumulator_0.add(component);
			}
			final /*@NonInvalid*/ GateReference sourceGate = this.getSourceGate();
			final /*@NonInvalid*/ ComponentInstance component_0 = sourceGate.getComponent();
			final /*@NonInvalid*/ BagValue including = (BagValue)CollectionIncludingOperation.INSTANCE.evaluate(collect, component_0);
			final /*@NonInvalid*/ OrderedSetValue asOrderedSet = CollectionAsOrderedSetOperation.INSTANCE.evaluate(including);
			local_0 = asOrderedSet;
		}
		else {
			final /*@NonInvalid*/ TestConfiguration testConfiguration = getParentTestDescription.getTestConfiguration();
			final /*@NonInvalid*/ List<ComponentInstance> componentInstance = testConfiguration.getComponentInstance();
			final /*@NonInvalid*/ SetValue BOXED_componentInstance = idResolver.createSetOfAll(tdlTables.SET_CLSSid_ComponentInstance, componentInstance);
			final /*@NonInvalid*/ OrderedSetValue asOrderedSet_0 = CollectionAsOrderedSetOperation.INSTANCE.evaluate(BOXED_componentInstance);
			local_0 = asOrderedSet_0;
		}
		final /*@NonInvalid*/ List<ComponentInstance> ECORE_local_0 = ((IdResolverExtension)idResolver).ecoreValueOfAll(ComponentInstance.class, local_0);
		return (EList<ComponentInstance>)ECORE_local_0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID) {
			case tdlPackage.INTERACTION__TARGET:
				return ((InternalEList<?>)getTarget()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID) {
			case tdlPackage.INTERACTION__SOURCE_GATE:
				if (resolve) return getSourceGate();
				return basicGetSourceGate();
			case tdlPackage.INTERACTION__TARGET:
				return getTarget();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID) {
			case tdlPackage.INTERACTION__SOURCE_GATE:
				setSourceGate((GateReference)newValue);
				return;
			case tdlPackage.INTERACTION__TARGET:
				getTarget().clear();
				getTarget().addAll((Collection<? extends Target>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID) {
			case tdlPackage.INTERACTION__SOURCE_GATE:
				setSourceGate((GateReference)null);
				return;
			case tdlPackage.INTERACTION__TARGET:
				getTarget().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID) {
			case tdlPackage.INTERACTION__SOURCE_GATE:
				return sourceGate != null;
			case tdlPackage.INTERACTION__TARGET:
				return target != null && !target.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedOperationID(int baseOperationID, Class<?> baseClass)
	{
		if (baseClass == Behaviour.class) {
			switch (baseOperationID) {
				case tdlPackage.BEHAVIOUR___GET_PARTICIPATING_COMPONENTS: return tdlPackage.INTERACTION___GET_PARTICIPATING_COMPONENTS;
				default: return super.eDerivedOperationID(baseOperationID, baseClass);
			}
		}
		if (baseClass == AtomicBehaviour.class) {
			switch (baseOperationID) {
				case tdlPackage.ATOMIC_BEHAVIOUR___GET_PARTICIPATING_COMPONENTS: return tdlPackage.INTERACTION___GET_PARTICIPATING_COMPONENTS;
				default: return super.eDerivedOperationID(baseOperationID, baseClass);
			}
		}
		return super.eDerivedOperationID(baseOperationID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
	{
		switch (operationID) {
			case tdlPackage.INTERACTION___GET_PARTICIPATING_COMPONENTS:
				return getParticipatingComponents();
		}
		return super.eInvoke(operationID, arguments);
	}

} //InteractionImpl
