/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.TransformerException;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModelCell;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModelRow;
import org.docx4j.finders.TcFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTrPrBase;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTableWriterModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableWriterModel.class);
    private static final int DEFAULT_PAGE_WIDTH_TWIPS = 12240;
    protected List<AbstractTableWriterModelRow> cells;
    private int headerMaxRow;
    private int row;
    private int col;
    private int width = -1;
    private boolean drawTableBorder = true;
    protected String styleId;
    protected Style effectiveTableStyle;
    protected TblPr tblPr;
    protected TblGrid tblGrid;
    boolean borderConflictResolutionRequired = true;

    public AbstractTableWriterModel() {
        this.resetIndexes();
        this.cells = new ArrayList<AbstractTableWriterModelRow>();
        this.headerMaxRow = -1;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public Style getEffectiveTableStyle() {
        return this.effectiveTableStyle;
    }

    public TblPr getTblPr() {
        return this.tblPr;
    }

    public TblGrid getTblGrid() {
        return this.tblGrid;
    }

    public boolean isBorderConflictResolutionRequired() {
        return this.borderConflictResolutionRequired;
    }

    public boolean isDrawTableBorders() {
        return this.drawTableBorder;
    }

    public int getTableWidth() {
        return this.width;
    }

    public void resetIndexes() {
        this.row = -1;
        this.col = -1;
    }

    public void startRow(Tr tr) {
        this.cells.add(new AbstractTableWriterModelRow(tr));
        ++this.row;
        this.col = -1;
    }

    public void addCell(Tc tc, Node content) {
        this.addCell(new AbstractTableWriterModelCell(this, this.row, ++this.col, tc, content));
    }

    private void addDummyCell() {
        this.addDummyCell(0);
    }

    private void addDummyCell(int colSpan) {
        AbstractTableWriterModelCell cell = new AbstractTableWriterModelCell(this, this.row, ++this.col);
        if (colSpan > 0) {
            cell.colspan = colSpan;
        }
        this.addCell(cell);
    }

    private void addCell(AbstractTableWriterModelCell cell) {
        this.cells.get(this.row).add(cell);
    }

    public AbstractTableWriterModelCell getCell(int row, int col) {
        return this.cells.get(row).get(col);
    }

    public String getColName(int col) {
        return "col" + String.valueOf(col + 1);
    }

    public int getColCount() {
        return this.cells.get(0).size();
    }

    public List<AbstractTableWriterModelRow> getCells() {
        return this.cells;
    }

    public int getHeaderMaxRow() {
        return this.headerMaxRow;
    }

    public void build(AbstractWmlConversionContext conversionContext, Object node, Node content) throws TransformerException {
        Tbl tbl = null;
        try {
            tbl = (Tbl)node;
        }
        catch (ClassCastException e) {
            throw new TransformerException("Node is not of the type Tbl it is " + node.getClass().getName());
        }
        if (tbl.getTblPr() != null && tbl.getTblPr().getTblStyle() != null) {
            this.styleId = tbl.getTblPr().getTblStyle().getVal();
        }
        this.tblGrid = tbl.getTblGrid();
        this.tblPr = tbl.getTblPr();
        PropertyResolver pr = conversionContext.getPropertyResolver();
        this.effectiveTableStyle = pr.getEffectiveTableStyle(tbl.getTblPr());
        NodeList cellContents = content.getChildNodes();
        TrFinder trFinder = new TrFinder();
        new TraversalUtil(tbl, trFinder);
        this.ensureFoTableBody(trFinder.trList);
        int r = 0;
        for (Tr tr : trFinder.trList) {
            this.startRow(tr);
            this.handleRow(cellContents, tr, r);
            ++r;
            if (!this.cells.get(this.row).getRowContents().isEmpty()) continue;
            this.cells.remove(this.row);
            --this.row;
            --r;
        }
        CTTblPrBase tblPr = this.effectiveTableStyle.getTblPr();
        if (tblPr != null && tblPr.getTblCellSpacing() != null) {
            this.borderConflictResolutionRequired = false;
        }
        this.width = this.calcTableWidth();
    }

    private void ensureFoTableBody(List<Tr> rows) {
        Tr tr;
        int i;
        int numRows = rows.size();
        if (numRows == 0) {
            log.warn("Encountered table with no rows");
            return;
        }
        Tr lastRow = rows.get(numRows - 1);
        if (this.isHeaderRow(lastRow)) {
            List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore = lastRow.getTrPr().getCnfStyleOrDivIdOrGridBefore();
            JAXBElement<?> tblHeader = this.getElement(cnfStyleOrDivIdOrGridBefore, "tblHeader");
            cnfStyleOrDivIdOrGridBefore.remove(tblHeader);
        }
        int indexOfLastHeaderRow = -1;
        for (i = rows.size(); i > 0; --i) {
            tr = rows.get(i - 1);
            if (!this.isHeaderRow(tr)) continue;
            indexOfLastHeaderRow = i - 1;
            break;
        }
        for (i = 0; i < indexOfLastHeaderRow; ++i) {
            tr = rows.get(i);
            if (this.isHeaderRow(tr)) continue;
            TrPr trpr = null;
            if (tr.getTrPr() == null) {
                trpr = Context.getWmlObjectFactory().createTrPr();
                tr.setTrPr(trpr);
            }
            BooleanDefaultTrue booleandefaulttrue = Context.getWmlObjectFactory().createBooleanDefaultTrue();
            JAXBElement<BooleanDefaultTrue> booleandefaulttrueWrapped = Context.getWmlObjectFactory().createCTTrPrBaseTblHeader(booleandefaulttrue);
            trpr.getCnfStyleOrDivIdOrGridBefore().add(booleandefaulttrueWrapped);
        }
    }

    private void handleRow(NodeList cellContents, Tr tr, int r) {
        int gridAfter = this.getGridAfter(tr);
        int gridBefore = this.getGridBefore(tr);
        boolean headerRow = this.isHeaderRow(tr);
        log.debug("Processing r " + r);
        if (this.borderConflictResolutionRequired && tr.getTblPrEx() != null && tr.getTblPrEx().getTblCellSpacing() != null) {
            this.borderConflictResolutionRequired = false;
        }
        if (headerRow && this.headerMaxRow < r) {
            this.headerMaxRow = r;
        }
        if (this.drawTableBorder) {
            this.drawTableBorder = gridBefore == 0 && gridAfter == 0;
        }
        TcFinder tcFinder = new TcFinder();
        new TraversalUtil(tr, tcFinder);
        if (gridBefore > 0) {
            this.addDummyCell(gridBefore);
        }
        int c = 0;
        log.debug("Processing c " + c);
        for (Tc tc : tcFinder.tcList) {
            Node wtrNode = cellContents.item(r);
            if (wtrNode == null) {
                log.warn("Couldn't find item " + r);
            }
            this.addCell(tc, this.getTc(wtrNode, c, new IntRef(0)));
            ++c;
        }
        if (gridAfter > 0) {
            this.addDummyCell(gridAfter);
        }
    }

    protected boolean isHeaderRow(Tr tr) {
        List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore = tr.getTrPr() != null ? tr.getTrPr().getCnfStyleOrDivIdOrGridBefore() : null;
        JAXBElement<?> element = this.getElement(cnfStyleOrDivIdOrGridBefore, "tblHeader");
        BooleanDefaultTrue boolVal = element != null ? (BooleanDefaultTrue)element.getValue() : null;
        return boolVal != null ? boolVal.isVal() : false;
    }

    protected int getGridAfter(Tr tr) {
        List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore = tr.getTrPr() != null ? tr.getTrPr().getCnfStyleOrDivIdOrGridBefore() : null;
        JAXBElement<?> element = this.getElement(cnfStyleOrDivIdOrGridBefore, "gridAfter");
        CTTrPrBase.GridAfter gridAfter = element != null ? (CTTrPrBase.GridAfter)element.getValue() : null;
        BigInteger val = gridAfter != null ? gridAfter.getVal() : null;
        return val != null ? val.intValue() : 0;
    }

    protected int getGridBefore(Tr tr) {
        List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore = tr.getTrPr() != null ? tr.getTrPr().getCnfStyleOrDivIdOrGridBefore() : null;
        JAXBElement<?> element = this.getElement(cnfStyleOrDivIdOrGridBefore, "gridBefore");
        CTTrPrBase.GridBefore gridBefore = element != null ? (CTTrPrBase.GridBefore)element.getValue() : null;
        BigInteger val = gridBefore != null ? gridBefore.getVal() : null;
        return val != null ? val.intValue() : 0;
    }

    protected JAXBElement<?> getElement(List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore, String localName) {
        JAXBElement<?> element = null;
        if (cnfStyleOrDivIdOrGridBefore != null && !cnfStyleOrDivIdOrGridBefore.isEmpty()) {
            for (int i = 0; i < cnfStyleOrDivIdOrGridBefore.size(); ++i) {
                element = cnfStyleOrDivIdOrGridBefore.get(i);
                if (!localName.equals(element.getName().getLocalPart())) continue;
                return element;
            }
        }
        return null;
    }

    protected int calcTableWidth() {
        List<TblGridCol> gridCols;
        int ret = -1;
        List<TblGridCol> list = gridCols = this.getTblGrid() != null ? this.getTblGrid().getGridCol() : null;
        if (gridCols != null && !gridCols.isEmpty()) {
            ret = 0;
            for (int i = 0; i < gridCols.size(); ++i) {
                ret += gridCols.get(i).getW().intValue();
            }
        }
        return ret;
    }

    private Node getTc(Node wtrNode, int wanted, IntRef current) {
        for (int i = 0; i < wtrNode.getChildNodes().getLength(); ++i) {
            Node thisChild = wtrNode.getChildNodes().item(i);
            if (thisChild.getNodeType() != 1) continue;
            log.debug("Looking at " + thisChild.getLocalName() + "; have encountered " + current.i);
            if (thisChild.getLocalName().equals("tc")) {
                if (current.i == wanted) {
                    return thisChild;
                }
                current.increment();
                continue;
            }
            Node n = this.getTc(thisChild, wanted, current);
            if (n == null) continue;
            return n;
        }
        log.error("Couldn't find tc in: " + XmlUtils.w3CDomNodeToString(wtrNode));
        return null;
    }

    public String debugStr() {
        StringBuffer buf = new StringBuffer();
        for (AbstractTableWriterModelRow row : this.cells) {
            List<AbstractTableWriterModelCell> rowContents = row.getRowContents();
            for (AbstractTableWriterModelCell c : rowContents) {
                if (c == null) {
                    buf.append("null     ");
                    continue;
                }
                buf.append(c.debugStr());
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    static class IntRef {
        int i;

        IntRef(int i) {
            this.i = i;
        }

        void increment() {
            ++this.i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TrFinder
    extends TraversalUtil.CallbackImpl {
        List<Tr> trList = new ArrayList<Tr>();

        TrFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof Tr) {
                this.trList.add((Tr)o);
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof Tbl);
        }
    }
}

