package org.etsi.mts.tdl.execution.java.rt.core;

import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;

public class TimeLabel {

	private int denominator = 1;

	private Deque<Long> timestampMillis = new ConcurrentLinkedDeque<Long>();

	public TimeLabel() {
		setUnit(TimeUnit.MilliSecond);
	}

	public void setUnit(TimeUnit unit) {
		this.denominator = unit.getNsDenominator();
	}

	long currentTime() {
		return System.nanoTime() / this.denominator;
	}

	public void timestamp() {
		this.timestampMillis.add(System.nanoTime());
	}

	public long first() throws NoSuchElementException {
		return this.timestampMillis.getFirst() / this.denominator;
	}

	public long previous() throws NoSuchElementException {
		return this.timestampMillis.getLast() / this.denominator;
	}

	public long last() throws NoSuchElementException {
		return this.timestampMillis.getLast() / this.denominator;
	}
}
