/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mapper {
    protected static Logger log = LoggerFactory.getLogger(Mapper.class);
    protected static final Map<String, PhysicalFont> fontMappings = Collections.synchronizedMap(new HashMap());
    public static final String FONT_FALLBACK = "Times New Roman";

    @Deprecated
    public Map<String, PhysicalFont> getFontMappings() {
        return fontMappings;
    }

    public PhysicalFont get(String key) {
        return fontMappings.get(key.toLowerCase());
    }

    public void put(String key, PhysicalFont pf) {
        fontMappings.put(key.toLowerCase(), pf);
    }

    public int size() {
        return fontMappings.size();
    }

    public abstract void populateFontMappings(Set<String> var1, Fonts var2) throws Exception;

    public static String getSubstituteFontXsltExtension(Mapper s, String documentStyleId, String bolditalic, boolean fontFamilyStack) {
        return s.getSubstituteFontXsltExtension(documentStyleId, bolditalic, fontFamilyStack);
    }

    public String getSubstituteFontXsltExtension(String documentStyleId, String bolditalic, boolean fontFamilyStack) {
        log.debug("Trying to insert HTML font-family value for " + documentStyleId);
        if (documentStyleId == null) {
            log.error("passed null documentStyleId");
            return "nullInputToExtension";
        }
        PhysicalFont physicalFont = this.get(documentStyleId);
        if (physicalFont == null) {
            log.error("No mapping for: " + documentStyleId);
            return FONT_FALLBACK;
        }
        String fontFamily = physicalFont.getName();
        if (fontFamily.startsWith("Britannic")) {
            return fontFamily;
        }
        if (fontFamily.endsWith(" Demibold")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 9);
        }
        if (fontFamily.endsWith(" Oblique")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 8);
        }
        if (fontFamily.endsWith(" Italic")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 7);
        }
        if (fontFamily.endsWith(" Bold")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 5);
        }
        log.debug("Mapping " + documentStyleId + " to " + physicalFont.getName());
        return fontFamily;
    }
}

