/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.DocumentProperties;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Doc {
    private static Logger log = LoggerFactory.getLogger(Doc.class);
    private static int ID1 = 1;
    private static int ID2 = 2;

    public static WordprocessingMLPackage convert(InputStream in) throws Exception {
        HWPFDocument doc = new HWPFDocument(in);
        WordprocessingMLPackage out = WordprocessingMLPackage.createPackage();
        Doc.convert(doc, out);
        return out;
    }

    private static void convert(HWPFDocument doc, WordprocessingMLPackage wordMLPackage) throws Exception {
        StyleSheet stylesheet = doc.getStyleSheet();
        ListTables listTables = doc.getListTables();
        DocumentProperties docProps = doc.getDocProperties();
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        ObjectFactory factory = new ObjectFactory();
        Range r = doc.getRange();
        for (int x = 0; x < r.numSections(); ++x) {
            Section s = r.getSection(x);
            for (int y = 0; y < s.numParagraphs(); ++y) {
                Paragraph p = s.getParagraph(y);
                if (p.isInTable()) {
                    Table t = s.getTable(p);
                    int cl = Doc.numCol(t);
                    log.info("Found " + t.numRows() + "x" + cl + " table - TODO - convert");
                    Doc.handleTable(wordMLPackage, doc, t, stylesheet, documentPart, factory);
                    y += t.numParagraphs() - 1;
                    continue;
                }
                P paraToAdd = Doc.handleP(wordMLPackage, doc, p, stylesheet, documentPart, factory);
                documentPart.addObject(paraToAdd);
            }
        }
    }

    private static P handleP(WordprocessingMLPackage wordMLPackage, HWPFDocument doc, Paragraph p, StyleSheet stylesheet, MainDocumentPart documentPart, ObjectFactory factory) {
        P wmlP = null;
        if (p.getStyleIndex() > 0) {
            log.debug("Styled paragraph, with index: " + p.getStyleIndex());
            String styleName = stylesheet.getStyleDescription((int)p.getStyleIndex()).getName();
            log.debug(styleName);
            wmlP = documentPart.createStyledParagraphOfText(Doc.stripSpace(styleName), null);
        } else {
            wmlP = documentPart.createParagraphOfText(null);
        }
        for (int z = 0; z < p.numCharacterRuns(); ++z) {
            CharacterRun run = p.getCharacterRun(z);
            RPr rPr = null;
            if (run.isBold()) {
                if (rPr == null) {
                    rPr = factory.createRPr();
                }
                BooleanDefaultTrue boldOn = factory.createBooleanDefaultTrue();
                boldOn.setVal(Boolean.TRUE);
                rPr.setB(boldOn);
            }
            if (doc instanceof HWPFDocument && doc.getPicturesTable().hasPicture(run)) {
                Picture picture = doc.getPicturesTable().extractPicture(run, true);
                try {
                    BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(wordMLPackage, picture.getContent());
                    long cx = UnitsOfMeasurement.twipToEMU(Math.round((double)imagePart.getImageInfo().getSize().getWidthMpt() * ((double)picture.getHorizontalScalingFactor() * 1.0E-5))) * 2L;
                    long cy = UnitsOfMeasurement.twipToEMU(Math.round((double)imagePart.getImageInfo().getSize().getHeightMpt() * ((double)picture.getVerticalScalingFactor() * 1.0E-5))) * 2L;
                    Inline inline = imagePart.createImageInline(null, "", ID1++, ID2++, cx, cy, false);
                    R imgrun = factory.createR();
                    Drawing drawing = factory.createDrawing();
                    imgrun.getContent().add(drawing);
                    drawing.getAnchorOrInline().add(inline);
                    wmlP.getContent().add(imgrun);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            String text = run.text();
            log.debug("Processing: " + text);
            String cleansed = Doc.stripNonValidXMLCharacters(text);
            if (!text.equals(cleansed)) {
                log.warn("Cleansed..");
            }
            Text t = factory.createText();
            t.setValue(cleansed);
            R wmlRun = factory.createR();
            if (rPr != null) {
                wmlRun.setRPr(rPr);
            }
            wmlRun.getRunContent().add(t);
            wmlP.getParagraphContent().add(wmlRun);
        }
        System.out.println(XmlUtils.marshaltoString((Object)wmlP, true, true));
        return wmlP;
    }

    private static String stripSpace(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == ' ') continue;
            sb.append(in.charAt(i));
        }
        return sb.toString();
    }

    private static void addTODO(ObjectFactory factory, P wmlP, String message) {
        Text t = factory.createText();
        t.setValue(message);
        R wmlRun = factory.createR();
        wmlRun.getRunContent().add(t);
        wmlP.getParagraphContent().add(wmlRun);
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
                continue;
            }
            out.append("[#?]");
        }
        return out.toString();
    }

    private static int numCol(Table t) {
        int col = 0;
        for (int i = 0; i < t.numRows(); ++i) {
            if (t.getRow(i).numCells() <= col) continue;
            col = t.getRow(i).numCells();
        }
        return col;
    }

    private static void handleTable(WordprocessingMLPackage wordMLPackage, HWPFDocument doc, Table t, StyleSheet stylesheet, MainDocumentPart documentPart, ObjectFactory factory) {
        Tbl tbl = factory.createTbl();
        documentPart.addObject(tbl);
        TblPr tblPr = factory.createTblPr();
        tbl.setTblPr(tblPr);
        TblGrid tblGrid = factory.createTblGrid();
        tbl.setTblGrid(tblGrid);
        for (int i = 0; i < t.numRows(); ++i) {
            TableRow tr = t.getRow(i);
            Tr trOut = factory.createTr();
            tbl.getEGContentRowContent().add(trOut);
            for (int j = 0; j < tr.numCells(); ++j) {
                TableCell tc = tr.getCell(j);
                Tc tcOut = factory.createTc();
                trOut.getEGContentCellContent().add(tcOut);
                for (int y = 0; y < tc.numParagraphs(); ++y) {
                    Paragraph p = tc.getParagraph(y);
                    P paraToAdd = Doc.handleP(wordMLPackage, doc, p, stylesheet, documentPart, factory);
                    tcOut.getEGBlockLevelElts().add(paraToAdd);
                    log.debug("Added p to tc");
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String localPath = System.getProperty("user.dir") + "/LineSpacing.doc";
        WordprocessingMLPackage out = Doc.convert(new FileInputStream(localPath));
    }
}

