package org.etsi.mts.tdl.yang2tdl;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.helper.TDLHelper;

public class YANGConverter {
	public static void main(String[] args) {
		String inputPath = "samples/simple/sports.yang";
//		inputPath = "samples/simple/links.yang";
//		inputPath = "samples/simple/example.yang";
//		inputPath = "samples/simple/acme.yang";
		String output = processToString(inputPath, inputPath+".tdltx");
		System.out.println(output);
	}
	public static String processToString(String inputPath, String outputPath) {
		return processToString(inputPath, outputPath, "SOURCE_MAPPING", "TARGET_MAPPING");
	}
	
	//TODO: will need to resolve related files as well
	public static String processToString(String inputPath, String outputPath, String sourceMapping, String targetMapping) {
		System.out.println("Exporting: "+outputPath+ " : "+ new File(outputPath).getAbsolutePath());
		Yang2TDLTranslator translator = new Yang2TDLTranslator();
		String content = "Package imported {}";
		try {
//			Resource tr = TDLHelper.create(outputPath+".tdl");
			Resource tr = TDLHelper.create(outputPath);
			translator.setTargetResource(tr);
			translator.initTargetResource(translator.cleanName(new File(inputPath).getName()));
			translator.translate(inputPath);
			//update non-unique names
			//TODO: does not quite work yet
			//TODO: references not updated?
//			int s = 0;
//			ArrayList<String> names = new ArrayList<String>();
//			for (PackageableElement e : translator.getGeneratedPackage().getPackagedElement()) {
//				if (names.contains(e.getName()) ) {
//					e.setName(e.getName()+s);
//					s++;
//				} 
//				names.add(e.getName());
//			}
			content = TDLHelper.getText(tr);
			TDLHelper.store(tr);
//			Resource tdl = TDLHelper.load(outputPath+".tdl");
//			Resource tdltx = TDLHelper.create(outputPath);
//			tdltx.getContents().addAll(EcoreUtil.copyAll(tdl.getContents()));
//			content = TDLHelper.getText(tdltx);
//			TDLHelper.store(tdltx);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return content;
	}

}

