package org.etsi.mts.tdl.execution.java.tri;

import java.util.Collection;

import com.google.inject.Inject;

/**
 * Default implementation of predefined functions specified in TDL.
 */
public class PredefinedFunctions {

	public RuntimeHelper helper;

	@Inject
	public PredefinedFunctions(RuntimeHelper helper) {
		this.helper = helper;
	}

	public boolean equals(Data<?, ?> d0, Data<?, ?> d1) {
		return helper.equals(d0.getValue(), d1.getValue());
	}

	public boolean notEquals(Data<?, ?> d0, Data<?, ?> d1) {
		return !equals(d0, d1);
	}

	public boolean and(boolean b0, boolean b1) {
		return b0 && b1;
	}

	public boolean or(boolean b0, boolean b1) {
		return b0 || b1;
	}

	public boolean xor(boolean b0, boolean b1) {
		return b0 ^ b1;
	}

	public boolean not(boolean b) {
		return !b;
	}

	public boolean lt(int i0, int i1) {
		return i0 < i1;
	}

	public boolean gt(int i0, int i1) {
		return i0 > i1;
	}

	public boolean lteq(int i0, int i1) {
		return i0 <= i1;
	}

	public boolean gteq(int i0, int i1) {
		return i0 >= i1;
	}

	public boolean lt(long i0, long i1) {
		return i0 < i1;
	}

	public boolean gt(long i0, long i1) {
		return i0 > i1;
	}

	public boolean lteq(long i0, long i1) {
		return i0 <= i1;
	}

	public boolean gteq(long i0, long i1) {
		return i0 >= i1;
	}

	public int plus(int i0, int i1) {
		return i0 + i1;
	}

	public int minus(int i0, int i1) {
		return i0 - i1;
	}

	public int multiply(int i0, int i1) {
		return i0 * i1;
	}

	public int divide(int i0, int i1) {
		return i0 / i1;
	}

	public int mod(int i0, int i1) {
		return i0 % i1;
	}

	public long plus(long i0, long i1) {
		return i0 + i1;
	}

	public long minus(long i0, long i1) {
		return i0 - i1;
	}

	public long multiply(long i0, long i1) {
		return i0 * i1;
	}

	public long divide(long i0, long i1) {
		return i0 / i1;
	}

	public long mod(long i0, long i1) {
		return i0 % i1;
	}

	/**
	 * @param collection An object that a CollectionDataInstance is mapped to.
	 */
	public int size(Data<?, Collection<?>> collection) {
		return collection.getValue().size();
	}

}
